/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@Metrics(about="SCM Container Placement Metrics", context="ozone")
public class SCMContainerPlacementMetrics
implements MetricsSource {
    public static final String SOURCE_NAME = SCMContainerPlacementMetrics.class.getSimpleName();
    private static final MetricsInfo RECORD_INFO = Interns.info((String)SOURCE_NAME, (String)"SCM Container Placement Metrics");
    private static MetricsRegistry registry;
    @Metric
    private MutableCounterLong datanodeRequestCount;
    @Metric
    private MutableCounterLong datanodeChooseAttemptCount;
    @Metric
    private MutableCounterLong datanodeChooseSuccessCount;
    @Metric
    private MutableCounterLong datanodeChooseFallbackCount;

    public static SCMContainerPlacementMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        MetricsSource existingSource = ms.getSource(SOURCE_NAME);
        if (existingSource != null) {
            return (SCMContainerPlacementMetrics)existingSource;
        }
        registry = new MetricsRegistry(RECORD_INFO);
        return (SCMContainerPlacementMetrics)ms.register(SOURCE_NAME, "SCM Container Placement Metrics", (Object)new SCMContainerPlacementMetrics());
    }

    public void incrDatanodeRequestCount(long count) {
        this.datanodeRequestCount.incr(count);
    }

    public void incrDatanodeChooseSuccessCount() {
        this.datanodeChooseSuccessCount.incr(1L);
    }

    public void incrDatanodeChooseFallbackCount() {
        this.datanodeChooseFallbackCount.incr(1L);
    }

    public void incrDatanodeChooseAttemptCount() {
        this.datanodeChooseAttemptCount.incr(1L);
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    @VisibleForTesting
    public long getDatanodeRequestCount() {
        return this.datanodeRequestCount.value();
    }

    @VisibleForTesting
    public long getDatanodeChooseSuccessCount() {
        return this.datanodeChooseSuccessCount.value();
    }

    @VisibleForTesting
    public long getDatanodeChooseFallbackCount() {
        return this.datanodeChooseFallbackCount.value();
    }

    @VisibleForTesting
    public long getDatanodeChooseAttemptCount() {
        return this.datanodeChooseAttemptCount.value();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        registry.snapshot(collector.addRecord(registry.info().name()), true);
    }
}

