/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.ozone.BasicKeyInfo;
import org.apache.hadoop.fs.ozone.BasicOzoneClientAdapterImpl;
import org.apache.hadoop.fs.ozone.FileStatusAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientUtils;
import org.apache.hadoop.fs.ozone.OzoneFSDataStreamOutput;
import org.apache.hadoop.fs.ozone.OzoneFSInputStream;
import org.apache.hadoop.fs.ozone.OzoneFSOutputStream;
import org.apache.hadoop.fs.ozone.Statistic;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.ozone.OzoneFsServerDefaults;
import org.apache.hadoop.ozone.client.io.SelectorOutputStream;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.apache.http.client.utils.URIBuilder;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BasicOzoneFileSystem
extends FileSystem {
    static final Logger LOG = LoggerFactory.getLogger(BasicOzoneFileSystem.class);
    private URI uri;
    private String userName;
    private Path workingDir;
    private OzoneClientAdapter adapter;
    private int listingPageSize = 1024;
    private boolean hsyncEnabled = false;
    private boolean isRatisStreamingEnabled = false;
    private int streamingAutoThreshold;
    private static final Pattern URL_SCHEMA_PATTERN = Pattern.compile("([^\\.]+)\\.([^\\.]+)\\.{0,1}(.*)");
    private static final String URI_EXCEPTION_TEXT = "Ozone file system URL should be one of the following formats: o3fs://bucket.volume/key  OR o3fs://bucket.volume.om-host.example.com/key  OR o3fs://bucket.volume.om-host.example.com:5678/key  OR o3fs://bucket.volume.omServiceId/key";
    private static final int PATH_DEPTH_TO_BUCKET = 0;

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.listingPageSize = conf.getInt("ozone.fs.listing.page.size", 1024);
        this.listingPageSize = OzoneClientUtils.limitValue(this.listingPageSize, "ozone.fs.listing.page.size", 5000);
        this.isRatisStreamingEnabled = conf.getBoolean("ozone.fs.datastream.enabled", false);
        this.streamingAutoThreshold = (int)OzoneConfiguration.of((Configuration)conf).getStorageSize("ozone.fs.datastream.auto.threshold", "4MB", StorageUnit.BYTES);
        this.setConf(conf);
        Preconditions.checkNotNull((Object)name.getScheme(), (String)"No scheme provided in %s", (Object)name);
        Preconditions.checkArgument((boolean)this.getScheme().equals(name.getScheme()), (String)"Invalid scheme provided in %s", (Object)name);
        String authority = name.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
        }
        Matcher matcher = URL_SCHEMA_PATTERN.matcher(authority);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
        }
        String bucketStr = matcher.group(1);
        String volumeStr = matcher.group(2);
        String remaining = matcher.groupCount() == 3 ? matcher.group(3) : null;
        String omHost = null;
        int omPort = -1;
        if (!this.isEmpty(remaining)) {
            String[] parts = remaining.split(":");
            if (parts.length > 2) {
                throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
            }
            omHost = parts[0];
            if (parts.length == 2) {
                try {
                    omPort = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
                }
            }
        }
        try {
            this.uri = new URIBuilder().setScheme("o3fs").setHost(authority).build();
            LOG.trace("Ozone URI for ozfs initialization is {}", (Object)this.uri);
            ConfigurationSource source = this.getConfSource();
            this.hsyncEnabled = OzoneFSUtils.canEnableHsync((ConfigurationSource)source, (boolean)true);
            LOG.debug("hsyncEnabled = {}", (Object)this.hsyncEnabled);
            this.adapter = this.createAdapter(source, bucketStr, volumeStr, omHost, omPort);
            try {
                this.userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                this.userName = "hdfs";
            }
            this.workingDir = new Path("/user", this.userName).makeQualified(this.uri, this.workingDir);
        }
        catch (URISyntaxException ue) {
            String msg = "Invalid Ozone endpoint " + name;
            LOG.error(msg, (Throwable)ue);
            throw new IOException(msg, ue);
        }
    }

    protected OzoneClientAdapter createAdapter(ConfigurationSource conf, String bucketStr, String volumeStr, String omHost, int omPort) throws IOException {
        return new BasicOzoneClientAdapterImpl(omHost, omPort, conf, volumeStr, bucketStr);
    }

    protected boolean isHsyncEnabled() {
        return this.hsyncEnabled;
    }

    public void close() throws IOException {
        try {
            this.adapter.close();
        }
        finally {
            super.close();
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public String getScheme() {
        return "o3fs";
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_OPEN, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("open() path:{}", (Object)f);
        String key = this.pathToKey(f);
        InputStream inputStream = this.adapter.readFile(key);
        return new FSDataInputStream(this.createFSInputStream(inputStream));
    }

    protected InputStream createFSInputStream(InputStream inputStream) {
        return new OzoneFSInputStream(inputStream, this.statistics);
    }

    protected void incrementCounter(Statistic statistic) {
        this.incrementCounter(statistic, 1L);
    }

    protected void incrementCounter(Statistic statistic, long count) {
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        LOG.trace("create() path:{}", (Object)f);
        this.incrementCounter(Statistic.INVOCATION_CREATE, 1L);
        this.statistics.incrementWriteOps(1);
        String key = this.pathToKey(f);
        return this.createOutputStream(key, replication, overwrite, true);
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_CREATE_NON_RECURSIVE, 1L);
        this.statistics.incrementWriteOps(1);
        String key = this.pathToKey(path);
        return this.createOutputStream(key, replication, flags.contains(CreateFlag.OVERWRITE), false);
    }

    private OutputStream selectOutputStream(String key, short replication, boolean overwrite, boolean recursive, int byteWritten) throws IOException {
        return this.isRatisStreamingEnabled && byteWritten > this.streamingAutoThreshold ? this.createFSDataStreamOutput(this.adapter.createStreamFile(key, replication, overwrite, recursive)) : this.createFSOutputStream(this.adapter.createFile(key, replication, overwrite, recursive));
    }

    private FSDataOutputStream createOutputStream(String key, short replication, boolean overwrite, boolean recursive) throws IOException {
        if (this.isRatisStreamingEnabled) {
            CheckedFunction selector = byteWritten -> this.selectOutputStream(key, replication, overwrite, recursive, (int)byteWritten);
            return new FSDataOutputStream((OutputStream)new SelectorOutputStream(this.streamingAutoThreshold, selector), this.statistics);
        }
        return new FSDataOutputStream((OutputStream)this.createFSOutputStream(this.adapter.createFile(key, replication, overwrite, recursive)), this.statistics);
    }

    protected OzoneFSOutputStream createFSOutputStream(OzoneFSOutputStream outputStream) {
        return outputStream;
    }

    protected OzoneFSDataStreamOutput createFSDataStreamOutput(OzoneFSDataStreamOutput outputDataStream) {
        return outputDataStream;
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("append() Not implemented by the " + ((Object)((Object)this)).getClass().getSimpleName() + " FileSystem implementation");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        FileStatus dstStatus;
        FileStatus srcStatus;
        this.incrementCounter(Statistic.INVOCATION_RENAME, 1L);
        this.statistics.incrementWriteOps(1);
        super.checkPath(src);
        super.checkPath(dst);
        String srcPath = src.toUri().getPath();
        String dstPath = dst.toUri().getPath();
        if (srcPath.equals(dstPath)) {
            return true;
        }
        LOG.trace("rename() from:{} to:{}", (Object)src, (Object)dst);
        if (src.isRoot()) {
            LOG.trace("Cannot rename the root of a filesystem");
            return false;
        }
        if (this.adapter.isFSOptimizedBucket()) {
            String srcKey = this.pathToKey(src);
            String dstKey = this.pathToKey(dst);
            return this.renameFSO(srcKey, dstKey);
        }
        try {
            srcStatus = this.getFileStatus(src);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        if (srcStatus.isDirectory()) {
            Path dstParent;
            for (dstParent = dst.getParent(); dstParent != null && !src.equals((Object)dstParent); dstParent = dstParent.getParent()) {
            }
            Preconditions.checkArgument((dstParent == null ? 1 : 0) != 0, (Object)"Cannot rename a directory to its own subdirectory");
        }
        try {
            dstStatus = this.getFileStatus(dst);
        }
        catch (FileNotFoundException fnde) {
            dstStatus = null;
        }
        if (dstStatus == null) {
            dstStatus = this.getFileStatus(dst.getParent());
            if (!dstStatus.isDirectory()) {
                throw new IOException(String.format("Failed to rename %s to %s, %s is a file", src, dst, dst.getParent()));
            }
        } else {
            if (srcStatus.getPath().equals((Object)dstStatus.getPath())) {
                return !srcStatus.isDirectory();
            }
            if (dstStatus.isDirectory()) {
                FileStatus[] statuses;
                dst = new Path(dst, src.getName());
                dstPath = dst.toUri().getPath();
                try {
                    statuses = this.listStatus(dst);
                }
                catch (FileNotFoundException fnde) {
                    statuses = null;
                }
                if (statuses != null && statuses.length > 0) {
                    LOG.warn("Failed to rename {} to {}, file already exists or not empty!", (Object)src, (Object)dst);
                    return false;
                }
            } else {
                LOG.warn("Failed to rename {} to {}, file already exists!", (Object)src, (Object)dst);
                return false;
            }
        }
        if (srcStatus.isDirectory() && dstPath.toString().startsWith(srcPath.toString() + "/")) {
            LOG.trace("Cannot rename a directory to a subdirectory of self");
            return false;
        }
        RenameIterator iterator = new RenameIterator(src, dst);
        boolean result = iterator.iterate();
        if (result) {
            this.createFakeParentDirectory(src);
        }
        return result;
    }

    private boolean renameFSO(String srcPath, String dstPath) throws IOException {
        try {
            this.adapter.renameKey(srcPath, dstPath);
        }
        catch (OMException ome) {
            LOG.error("rename key failed: {}. Error code: {} source:{}, destin:{}", new Object[]{ome.getMessage(), ome.getResult(), srcPath, dstPath});
            if (OMException.ResultCodes.KEY_ALREADY_EXISTS == ome.getResult() || OMException.ResultCodes.KEY_RENAME_ERROR == ome.getResult() || OMException.ResultCodes.KEY_NOT_FOUND == ome.getResult()) {
                return false;
            }
            throw ome;
        }
        return true;
    }

    @Deprecated
    protected void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        boolean hasMoveToTrash = false;
        if (options != null) {
            for (Options.Rename option : options) {
                if (option != Options.Rename.TO_TRASH) continue;
                hasMoveToTrash = true;
                break;
            }
        }
        if (!hasMoveToTrash) {
            super.rename(src, dst, options);
        } else {
            this.rename(src, dst);
        }
    }

    private boolean innerDelete(Path f, boolean recursive) throws IOException {
        LOG.trace("delete() path:{} recursive:{}", (Object)f, (Object)recursive);
        try {
            DeleteIterator iterator = new DeleteIterator(f, recursive);
            if (f.isRoot()) {
                LOG.warn("Cannot delete root directory.");
                return false;
            }
            return iterator.iterate();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't delete {} - does not exist", (Object)f);
            }
            return false;
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        boolean result;
        FileStatus status;
        this.incrementCounter(Statistic.INVOCATION_DELETE, 1L);
        this.statistics.incrementWriteOps(1);
        LOG.debug("Delete path {} - recursive {}", (Object)f, (Object)recursive);
        if (this.adapter.isFSOptimizedBucket()) {
            if (f.isRoot()) {
                if (!recursive && this.listStatus(f).length != 0) {
                    throw new PathIsNotEmptyDirectoryException(f.toString());
                }
                LOG.warn("Cannot delete root directory.");
                return false;
            }
            String key = this.pathToKey(f);
            return this.adapter.deleteObject(key, recursive);
        }
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException ex) {
            LOG.warn("delete: Path does not exist: {}", (Object)f);
            return false;
        }
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            LOG.debug("delete: Path is a directory: {}", (Object)f);
            result = this.innerDelete(f, recursive);
        } else {
            LOG.debug("delete: Path is a file: {}", (Object)f);
            result = this.adapter.deleteObject(key);
        }
        if (result) {
            this.createFakeParentDirectory(f);
        }
        return result;
    }

    private void createFakeParentDirectory(Path f) throws IOException {
        Path parent = f.getParent();
        if (parent != null && !parent.isRoot()) {
            this.createFakeDirectoryIfNecessary(parent);
        }
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.o3Exists(f)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            String dirKey = this.addTrailingSlashIfNeeded(key);
            this.adapter.createDirectory(dirKey);
        }
    }

    private boolean o3Exists(Path f) throws IOException {
        Path path = this.makeQualified(f);
        try {
            this.getFileStatus(path);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        int entriesAdded;
        this.incrementCounter(Statistic.INVOCATION_LIST_STATUS, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("listStatus() path:{}", (Object)f);
        int numEntries = this.listingPageSize;
        LinkedList statuses = new LinkedList();
        String startKey = "";
        do {
            List tmpStatusList = this.adapter.listStatus(this.pathToKey(f), false, startKey, numEntries, this.uri, this.workingDir, this.getUsername(), true).stream().map(this::convertFileStatus).collect(Collectors.toList());
            entriesAdded = 0;
            if (tmpStatusList.isEmpty()) continue;
            if (startKey.isEmpty() || !((FileStatus)statuses.getLast()).getPath().toString().equals(((FileStatus)tmpStatusList.get(0)).getPath().toString())) {
                statuses.addAll(tmpStatusList);
                entriesAdded += tmpStatusList.size();
            } else {
                statuses.addAll(tmpStatusList.subList(1, tmpStatusList.size()));
                entriesAdded += tmpStatusList.size() - 1;
            }
            startKey = this.pathToKey(((FileStatus)statuses.getLast()).getPath());
        } while (entriesAdded > 0);
        return statuses.toArray(new FileStatus[0]);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + this.userName));
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.adapter.getDelegationToken(renewer);
    }

    public String getCanonicalServiceName() {
        return this.adapter.getCanonicalServiceName();
    }

    public String getUsername() {
        return this.userName;
    }

    public Path getTrashRoot(Path path) {
        Path pathToTrash = new Path("/", ".Trash");
        return this.makeQualified(new Path(pathToTrash, this.getUsername()));
    }

    public Collection<FileStatus> getTrashRoots(boolean allUsers) {
        Path trashRoot = new Path("/", ".Trash");
        ArrayList<FileStatus> ret = new ArrayList<FileStatus>();
        try {
            if (!allUsers) {
                Path userTrash = new Path(trashRoot, this.userName);
                if (this.exists(userTrash) && this.getFileStatus(userTrash).isDirectory()) {
                    ret.add(this.getFileStatus(userTrash));
                }
            } else if (this.exists(trashRoot)) {
                FileStatus[] candidates;
                for (FileStatus candidate : candidates = this.listStatus(trashRoot)) {
                    if (!candidate.isDirectory()) continue;
                    ret.add(candidate);
                }
            }
        }
        catch (IOException ex) {
            LOG.warn("Can't get all trash roots", (Throwable)ex);
        }
        return ret;
    }

    private boolean mkdir(Path path) throws IOException {
        return this.adapter.createDirectory(this.pathToKey(path));
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_MKDIRS);
        LOG.trace("mkdir() path:{} ", (Object)f);
        String key = this.pathToKey(f);
        if (this.isEmpty(key)) {
            return false;
        }
        return this.mkdir(f);
    }

    public long getDefaultBlockSize() {
        return (long)this.getConfSource().getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GET_FILE_STATUS, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("getFileStatus() path:{}", (Object)f);
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        String key = this.pathToKey(qualifiedPath);
        FileStatus fileStatus = null;
        try {
            fileStatus = this.convertFileStatus(this.adapter.getFileStatus(key, this.uri, qualifiedPath, this.getUsername()));
        }
        catch (IOException ex) {
            if (ex instanceof OMException && ((OMException)((Object)ex)).getResult().equals((Object)OMException.ResultCodes.KEY_NOT_FOUND)) {
                throw new FileNotFoundException("File not found. path:" + f);
            }
            throw ex;
        }
        return fileStatus;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus fileStatus, long start, long len) throws IOException {
        if (fileStatus instanceof LocatedFileStatus) {
            return ((LocatedFileStatus)fileStatus).getBlockLocations();
        }
        return super.getFileBlockLocations(fileStatus, start, len);
    }

    public short getDefaultReplication() {
        return this.adapter.getDefaultReplication();
    }

    public OzoneFsServerDefaults getServerDefaults() throws IOException {
        return this.adapter.getServerDefaults();
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        super.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        super.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public boolean exists(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_EXISTS);
        return super.exists(f);
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GET_FILE_CHECKSUM);
        this.statistics.incrementReadOps(1);
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        String key = this.pathToKey(qualifiedPath);
        return this.adapter.getFileChecksum(key, length);
    }

    protected Path fixRelativePart(Path p) {
        String pathPatternString = p.toUri().getPath();
        if (pathPatternString.isEmpty()) {
            return new Path("/");
        }
        return super.fixRelativePart(p);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern, filter);
    }

    public boolean isDirectory(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_IS_DIRECTORY);
        return super.isDirectory(f);
    }

    public boolean isFile(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_IS_FILE);
        return super.isFile(f);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_LIST_FILES);
        return super.listFiles(f, recursive);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_LIST_LOCATED_STATUS);
        return new OzoneFileStatusIterator<LocatedFileStatus>(f, stat -> stat instanceof LocatedFileStatus ? (LocatedFileStatus)stat : new LocatedFileStatus(stat, null), false);
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path f) throws IOException {
        return new OzoneFileStatusIterator<FileStatus>(f, stat -> stat, true);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        String snapshot = this.getAdapter().createSnapshot(this.pathToKey(path), snapshotName);
        return new Path(OzoneFSUtils.trimPathToDepth((Path)path, (int)0), ".snapshot/" + snapshot);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.getAdapter().renameSnapshot(this.pathToKey(path), snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.adapter.deleteSnapshot(this.pathToKey(path), snapshotName);
    }

    public void setTimes(Path f, long mtime, long atime) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_SET_TIMES, 1L);
        this.statistics.incrementWriteOps(1);
        LOG.trace("setTimes() path:{}", (Object)f);
        Path qualifiedPath = this.makeQualified(f);
        String key = this.pathToKey(qualifiedPath);
        this.adapter.setTimes(key, mtime, atime);
    }

    private List<FileStatus> listFileStatus(Path f, String startPath, boolean lite) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_LIST_STATUS, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("listFileStatus() path:{}", (Object)f);
        List<FileStatus> statusList = this.adapter.listStatus(this.pathToKey(f), false, startPath, this.listingPageSize, this.uri, this.workingDir, this.getUsername(), lite).stream().map(this::convertFileStatus).collect(Collectors.toList());
        if (!statusList.isEmpty() && !startPath.isEmpty()) {
            statusList.remove(0);
        }
        return statusList;
    }

    public String pathToKey(Path path) {
        String key;
        Objects.requireNonNull(path, "Path can not be null!");
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (!OzoneFSUtils.isValidName((String)(key = path.toUri().getPath()))) {
            throw new InvalidPathException("Invalid path Name " + key);
        }
        LOG.trace("path for key:{} is:{}", (Object)key, (Object)path);
        return key.substring(1);
    }

    private String addTrailingSlashIfNeeded(String key) {
        if (!this.isEmpty(key) && !key.endsWith("/")) {
            return key + "/";
        }
        return key;
    }

    public ConfigurationSource getConfSource() {
        Configuration conf = super.getConf();
        Object source = conf instanceof OzoneConfiguration ? (ConfigurationSource)conf : new LegacyHadoopConfigurationSource(conf);
        return source;
    }

    public String toString() {
        return "OzoneFileSystem{URI=" + this.uri + ", workingDir=" + this.workingDir + ", userName=" + this.userName + ", statistics=" + this.statistics + "}";
    }

    public OzoneClientAdapter getAdapter() {
        return this.adapter;
    }

    public boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public boolean isNumber(String number) {
        try {
            Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    protected FileStatus constructFileStatus(FileStatusAdapter fileStatusAdapter) {
        return new FileStatus(fileStatusAdapter.getLength(), fileStatusAdapter.isDir(), (int)fileStatusAdapter.getBlockReplication(), fileStatusAdapter.getBlocksize(), fileStatusAdapter.getModificationTime(), fileStatusAdapter.getAccessTime(), new FsPermission(fileStatusAdapter.getPermission()), fileStatusAdapter.getOwner(), fileStatusAdapter.getGroup(), fileStatusAdapter.getSymlink(), fileStatusAdapter.getPath(), false, fileStatusAdapter.isEncrypted(), fileStatusAdapter.isErasureCoded());
    }

    private FileStatus convertFileStatus(FileStatusAdapter fileStatusAdapter) {
        FileStatus fileStatus = this.constructFileStatus(fileStatusAdapter);
        BlockLocation[] blockLocations = fileStatusAdapter.getBlockLocations();
        if (blockLocations.length == 0) {
            return fileStatus;
        }
        return new LocatedFileStatus(fileStatus, blockLocations);
    }

    protected boolean setSafeModeUtil(SafeModeAction action, boolean isChecked) throws IOException {
        if (action == SafeModeAction.GET) {
            this.statistics.incrementReadOps(1);
        } else {
            this.statistics.incrementWriteOps(1);
        }
        LOG.trace("setSafeMode() action:{}", (Object)action);
        return this.getAdapter().setSafeMode(action, isChecked);
    }

    private abstract class OzoneListingIterator {
        private final Path path;
        private final FileStatus status;
        private String pathKey;
        private Iterator<BasicKeyInfo> keyIterator;

        OzoneListingIterator(Path path) throws IOException {
            this.path = path;
            this.status = BasicOzoneFileSystem.this.getFileStatus(path);
            this.pathKey = BasicOzoneFileSystem.this.pathToKey(path);
            if (this.status.isDirectory()) {
                this.pathKey = BasicOzoneFileSystem.this.addTrailingSlashIfNeeded(this.pathKey);
            }
            this.keyIterator = BasicOzoneFileSystem.this.adapter.listKeys(this.pathKey);
        }

        abstract boolean processKey(List<String> var1) throws IOException;

        boolean iterate() throws IOException {
            LOG.trace("Iterating path {}", (Object)this.path);
            ArrayList<String> keyList = new ArrayList<String>();
            int batchSize = BasicOzoneFileSystem.this.getConf().getInt("ozone.fs.iterate.batch-size", 100);
            if (this.status.isDirectory()) {
                LOG.trace("Iterating directory:{}", (Object)this.pathKey);
                while (this.keyIterator.hasNext()) {
                    BasicKeyInfo key = this.keyIterator.next();
                    LOG.trace("iterating key:{}", (Object)key.getName());
                    if (!key.getName().equals("")) {
                        keyList.add(key.getName());
                    }
                    if (keyList.size() < batchSize) continue;
                    if (!this.processKey(keyList)) {
                        return false;
                    }
                    keyList.clear();
                }
                return keyList.isEmpty() || this.processKey(keyList);
            }
            LOG.trace("iterating file:{}", (Object)this.path);
            keyList.add(this.pathKey);
            return this.processKey(keyList);
        }

        String getPathKey() {
            return this.pathKey;
        }

        boolean pathIsDirectory() {
            return this.status.isDirectory();
        }

        FileStatus getStatus() {
            return this.status;
        }
    }

    private final class OzoneFileStatusIterator<T extends FileStatus>
    implements RemoteIterator<T> {
        private List<FileStatus> thisListing;
        private int i;
        private Path p;
        private T curStat = null;
        private String startPath = "";
        private boolean lite;
        private Function<FileStatus, T> transformFunc;

        private OzoneFileStatusIterator(Path p, Function<FileStatus, T> transformFunc, boolean lite) throws IOException {
            this.p = p;
            this.lite = lite;
            this.transformFunc = transformFunc;
            this.thisListing = BasicOzoneFileSystem.this.listFileStatus(p, this.startPath, lite);
            if (this.thisListing != null && !this.thisListing.isEmpty()) {
                this.startPath = BasicOzoneFileSystem.this.pathToKey(this.thisListing.get(this.thisListing.size() - 1).getPath());
                LOG.debug("Got {} file status, next start path {}", (Object)this.thisListing.size(), (Object)this.startPath);
            }
            this.i = 0;
        }

        public boolean hasNext() throws IOException {
            while (this.curStat == null && this.hasNextNoFilter()) {
                FileStatus fileStat = this.thisListing.get(this.i++);
                FileStatus next = (FileStatus)this.transformFunc.apply((Object)fileStat);
                this.curStat = next;
            }
            return this.curStat != null;
        }

        private boolean hasNextNoFilter() throws IOException {
            if (this.thisListing == null) {
                return false;
            }
            if (this.i >= this.thisListing.size() && this.startPath != null && !this.thisListing.isEmpty()) {
                this.thisListing = BasicOzoneFileSystem.this.listFileStatus(this.p, this.startPath, this.lite);
                if (this.thisListing == null || this.thisListing.isEmpty()) {
                    return false;
                }
                this.startPath = BasicOzoneFileSystem.this.pathToKey(this.thisListing.get(this.thisListing.size() - 1).getPath());
                LOG.debug("Got {} file status, next start path {}", (Object)this.thisListing.size(), (Object)this.startPath);
                this.i = 0;
            }
            return this.i < this.thisListing.size();
        }

        public T next() throws IOException {
            if (this.hasNext()) {
                T tmp = this.curStat;
                this.curStat = null;
                return tmp;
            }
            throw new NoSuchElementException("No more entry in " + this.p);
        }
    }

    private class DeleteIterator
    extends OzoneListingIterator {
        private boolean recursive;

        DeleteIterator(Path f, boolean recursive) throws IOException {
            super(f);
            this.recursive = recursive;
            if (this.getStatus().isDirectory() && !this.recursive && BasicOzoneFileSystem.this.listStatus(f).length != 0) {
                throw new PathIsNotEmptyDirectoryException(f.toString());
            }
        }

        @Override
        boolean processKey(List<String> key) throws IOException {
            LOG.trace("deleting key:{}", key);
            boolean succeed = BasicOzoneFileSystem.this.adapter.deleteObjects(key);
            return this.recursive || succeed;
        }
    }

    private class RenameIterator
    extends OzoneListingIterator {
        private final String srcKey;
        private final String dstKey;

        RenameIterator(Path srcPath, Path dstPath) throws IOException {
            super(srcPath);
            this.srcKey = BasicOzoneFileSystem.this.pathToKey(srcPath);
            this.dstKey = BasicOzoneFileSystem.this.pathToKey(dstPath);
            LOG.trace("rename from:{} to:{}", (Object)this.srcKey, (Object)this.dstKey);
        }

        @Override
        boolean processKey(List<String> keyList) throws IOException {
            for (String key : keyList) {
                String newKeyName = this.dstKey.concat(key.substring(this.srcKey.length()));
                try {
                    BasicOzoneFileSystem.this.adapter.renameKey(key, newKeyName);
                }
                catch (OMException ome) {
                    LOG.error("Key rename failed for source key: {} to destination key: {}.", new Object[]{key, newKeyName, ome});
                    if (OMException.ResultCodes.KEY_ALREADY_EXISTS == ome.getResult() || OMException.ResultCodes.KEY_RENAME_ERROR == ome.getResult() || OMException.ResultCodes.KEY_NOT_FOUND == ome.getResult()) {
                        return false;
                    }
                    throw ome;
                }
            }
            return true;
        }
    }
}

