/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.nifi.registry.db.entity.BucketItemEntity;
import org.apache.nifi.registry.db.entity.BucketItemEntityType;
import org.apache.nifi.registry.db.entity.BundleEntity;
import org.apache.nifi.registry.db.entity.FlowEntity;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.jspecify.annotations.Nullable;
import org.springframework.jdbc.core.RowMapper;

public class BucketItemEntityRowMapper
implements RowMapper<BucketItemEntity> {
    public @Nullable BucketItemEntity mapRow(ResultSet rs, int rowNum) throws SQLException {
        BucketItemEntityType type = BucketItemEntityType.valueOf(rs.getString("ITEM_TYPE"));
        BucketItemEntity item = null;
        switch (type) {
            case FLOW: {
                item = new FlowEntity();
                break;
            }
            case BUNDLE: {
                BundleEntity bundleEntity = new BundleEntity();
                bundleEntity.setBundleType(BundleType.valueOf((String)rs.getString("BUNDLE_TYPE")));
                bundleEntity.setGroupId(rs.getString("BUNDLE_GROUP_ID"));
                bundleEntity.setArtifactId(rs.getString("BUNDLE_ARTIFACT_ID"));
                item = bundleEntity;
            }
        }
        item.setId(rs.getString("ID"));
        item.setName(rs.getString("NAME"));
        item.setDescription(rs.getString("DESCRIPTION"));
        item.setCreated(rs.getTimestamp("CREATED"));
        item.setModified(rs.getTimestamp("MODIFIED"));
        item.setBucketId(rs.getString("BUCKET_ID"));
        item.setBucketName(rs.getString("BUCKET_NAME"));
        item.setType(type);
        return item;
    }
}

