/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj.key;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.Subkey;

public class KeyForSigning
extends Key {
    public KeyForSigning() {
    }

    public KeyForSigning(List<Subkey> subkeys) {
        super(subkeys);
    }

    public KeyForSigning(String armor) throws IOException, PGPException {
        super(armor);
    }

    public KeyForSigning(String armor, char[] passphraseChars) throws IOException, PGPException {
        super(armor, passphraseChars);
    }

    public KeyForSigning(String armor, String passphrase) throws IOException, PGPException {
        super(armor, passphrase);
    }

    public KeyForSigning(File file) throws IOException, PGPException {
        super(file);
    }

    public KeyForSigning(File file, char[] passphraseChars) throws IOException, PGPException {
        super(file, passphraseChars);
    }

    public KeyForSigning(File file, String passphrase) throws IOException, PGPException {
        super(file, passphrase);
    }

    public KeyForSigning(InputStream stream) throws IOException, PGPException {
        super(stream);
    }

    public KeyForSigning(InputStream stream, char[] passphraseChars) throws IOException, PGPException {
        super(stream, passphraseChars);
    }

    public KeyForSigning(InputStream stream, String passphrase) throws IOException, PGPException {
        super(stream, passphrase);
    }

    @Override
    protected void setSubkeys(List<Subkey> x) {
        super.setSubkeys(x);
        this.setSubkeysUsage();
    }

    protected void setSubkeysUsage() {
        if (this.subkeys.isEmpty()) {
            return;
        }
        for (Subkey subkey : this.subkeys) {
            subkey.setForVerification(false);
            subkey.setForEncryption(false);
            subkey.setForDecryption(false);
        }
        for (Subkey subkey : this.subkeys) {
            if (!subkey.isForSigning()) continue;
            return;
        }
        ArrayList preferred = new ArrayList(this.subkeys);
        if (preferred.size() > 2) {
            Collections.reverse(preferred);
        }
        for (Subkey subkey : preferred) {
            if (!subkey.isUsableForSigning()) continue;
            subkey.setForSigning(true);
            return;
        }
    }
}

