/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;

public class RequestBeanHolder
implements BeanHolder {
    private final BeanHolder holder;
    private final String key;

    public RequestBeanHolder(BeanHolder holder) {
        this.holder = holder;
        this.key = "CamelBeanRequestScope-" + holder.getBeanInfo().getType().getName();
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.holder.getOptions();
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        this.holder.setOptions(options);
    }

    @Override
    public Object getBean(Exchange exchange) throws NoSuchBeanException {
        if (exchange == null) {
            return this.holder.getBean(null);
        }
        Object bean = exchange.getProperty(this.key);
        if (bean == null) {
            bean = this.holder.getBean(exchange);
            exchange.setProperty(this.key, bean);
        }
        return bean;
    }

    @Override
    public Processor getProcessor() {
        return null;
    }

    @Override
    public boolean supportProcessor() {
        return false;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.holder.getBeanInfo();
    }

    @Override
    public BeanInfo getBeanInfo(Object bean) {
        return this.holder.getBeanInfo(bean);
    }
}

