/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.packages.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.karaf.packages.core.PackageRequirement;
import org.apache.karaf.packages.core.PackageService;
import org.apache.karaf.packages.core.PackageVersion;
import org.apache.karaf.packages.core.internal.ImportDetails;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

public class PackageServiceImpl
implements PackageService {
    private final BundleContext bundleContext;

    public PackageServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public List<PackageVersion> getExports() {
        Bundle[] bundles = this.bundleContext.getBundles();
        TreeMap<String, PackageVersion> packageVersionMap = new TreeMap<String, PackageVersion>();
        for (Bundle bundle : bundles) {
            BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (rev == null) continue;
            List caps = rev.getDeclaredCapabilities("osgi.wiring.package");
            for (BundleCapability cap : caps) {
                Map attr = cap.getAttributes();
                String packageName = (String)attr.get("osgi.wiring.package");
                Version version = (Version)attr.get("version");
                String key = packageName + ":" + version.toString();
                PackageVersion pVer = packageVersionMap.computeIfAbsent(key, k -> new PackageVersion(packageName, version));
                pVer.addBundle(bundle);
            }
        }
        return new ArrayList<PackageVersion>(packageVersionMap.values());
    }

    @Override
    public List<PackageRequirement> getImports() {
        Bundle[] bundles = this.bundleContext.getBundles();
        TreeMap<String, PackageRequirement> requirements = new TreeMap<String, PackageRequirement>();
        for (Bundle bundle : bundles) {
            BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (rev == null) continue;
            List reqs = rev.getDeclaredRequirements("osgi.wiring.package");
            for (BundleRequirement req : reqs) {
                PackageRequirement preq = this.create(req, bundle);
                requirements.put(preq.getPackageName() + "|" + preq.getFilter() + "|" + preq.getBundle().getBundleId(), preq);
            }
        }
        return new ArrayList<PackageRequirement>(requirements.values());
    }

    private boolean checkResolveAble(BundleRequirement req) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (rev == null) continue;
            List caps = rev.getDeclaredCapabilities("osgi.wiring.package");
            for (BundleCapability cap : caps) {
                if (!req.matches(cap)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> getExports(long bundleId) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        List caps = rev.getDeclaredCapabilities("osgi.wiring.package");
        ArrayList<String> exports = new ArrayList<String>();
        for (BundleCapability cap : caps) {
            Map attr = cap.getAttributes();
            String packageName = (String)attr.get("osgi.wiring.package");
            exports.add(packageName);
        }
        return exports;
    }

    @Override
    public List<String> getImports(long bundleId) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        List reqs = rev.getDeclaredRequirements("osgi.wiring.package");
        ArrayList<String> imports = new ArrayList<String>();
        for (BundleRequirement req : reqs) {
            PackageRequirement packageReq = this.create(req, bundle);
            imports.add(packageReq.getPackageName());
        }
        return imports;
    }

    PackageRequirement create(BundleRequirement req, Bundle bundle) {
        Map attr = req.getDirectives();
        String filter = (String)attr.get("filter");
        String resolution = (String)attr.get("resolution");
        boolean optional = "optional".equals(resolution);
        boolean resolveable = this.checkResolveAble(req);
        ImportDetails details = new ImportDetails(filter);
        return new PackageRequirement(filter, optional, bundle, resolveable, details.name, details.minVersion, details.maxVersion);
    }
}

