/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.image.node.ProducerIdsImageNode;
import org.apache.kafka.image.writer.ImageWriter;

public record ProducerIdsImage(long nextProducerId) {
    public static final ProducerIdsImage EMPTY = new ProducerIdsImage(-1L);

    public void write(ImageWriter writer) {
        if (this.nextProducerId >= 0L) {
            writer.write(0, new ProducerIdsRecord().setBrokerId(-1).setBrokerEpoch(-1L).setNextProducerId(this.nextProducerId));
        }
    }

    public boolean isEmpty() {
        return this.nextProducerId == ProducerIdsImage.EMPTY.nextProducerId;
    }

    @Override
    public String toString() {
        return new ProducerIdsImageNode(this).stringify();
    }
}

