/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class ChangeLoggingSessionBytesStore
extends WrappedStateStore<SessionStore<Bytes, byte[]>, byte[], byte[]>
implements SessionStore<Bytes, byte[]> {
    private InternalProcessorContext<?, ?> internalContext;

    ChangeLoggingSessionBytesStore(SessionStore<Bytes, byte[]> bytesStore) {
        super(bytesStore);
    }

    @Override
    public void init(StateStoreContext stateStoreContext, StateStore root) {
        this.internalContext = ProcessorContextUtils.asInternalProcessorContext(stateStoreContext);
        super.init(stateStoreContext, root);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        return ((SessionStore)this.wrapped()).findSessions(key, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFindSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        return ((SessionStore)this.wrapped()).backwardFindSessions(key, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        return ((SessionStore)this.wrapped()).findSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFindSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        return ((SessionStore)this.wrapped()).backwardFindSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public void remove(Windowed<Bytes> sessionKey) {
        ((SessionStore)this.wrapped()).remove(sessionKey);
        this.internalContext.logChange(this.name(), SessionKeySchema.toBinary(sessionKey), null, this.internalContext.recordContext().timestamp(), ((SessionStore)this.wrapped()).getPosition());
    }

    @Override
    public void put(Windowed<Bytes> sessionKey, byte[] aggregate) {
        ((SessionStore)this.wrapped()).put(sessionKey, aggregate);
        this.internalContext.logChange(this.name(), SessionKeySchema.toBinary(sessionKey), aggregate, this.internalContext.recordContext().timestamp(), ((SessionStore)this.wrapped()).getPosition());
    }

    @Override
    public byte[] fetchSession(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        return (byte[])((SessionStore)this.wrapped()).fetchSession(key, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(long earliestSessionEndTime, long latestSessionEndTime) {
        return ((SessionStore)this.wrapped()).findSessions(earliestSessionEndTime, latestSessionEndTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes key) {
        return ((SessionStore)this.wrapped()).backwardFetch(key);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes key) {
        return ((SessionStore)this.wrapped()).fetch(key);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo) {
        return ((SessionStore)this.wrapped()).backwardFetch(keyFrom, keyTo);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo) {
        return ((SessionStore)this.wrapped()).fetch(keyFrom, keyTo);
    }
}

