/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.juneau.commons.collections.CacheMode;
import org.apache.juneau.commons.function.Function3;
import org.apache.juneau.commons.function.Tuple3;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.SystemUtils;
import org.apache.juneau.commons.utils.Utils;

public class Cache3<K1, K2, K3, V> {
    private final Map<Tuple3<K1, K2, K3>, V> map;
    private final ThreadLocal<Map<Tuple3<K1, K2, K3>, V>> threadLocalMap;
    private final boolean isThreadLocal;
    private final int maxSize;
    private final CacheMode cacheMode;
    private final Function3<K1, K2, K3, V> supplier;
    private final AtomicInteger cacheHits = new AtomicInteger();

    public static <K1, K2, K3, V> Builder<K1, K2, K3, V> create() {
        return new Builder();
    }

    public static <K1, K2, K3, V> Builder<K1, K2, K3, V> of(Class<K1> key1, Class<K2> key2, Class<K3> key3, Class<V> type) {
        return new Builder();
    }

    protected Cache3(Builder<K1, K2, K3, V> builder) {
        this.maxSize = builder.maxSize;
        this.cacheMode = builder.cacheMode;
        this.supplier = builder.supplier;
        this.isThreadLocal = builder.threadLocal;
        if (this.isThreadLocal) {
            this.threadLocalMap = builder.cacheMode == CacheMode.WEAK ? ThreadLocal.withInitial(() -> Collections.synchronizedMap(new WeakHashMap())) : ThreadLocal.withInitial(() -> new ConcurrentHashMap());
            this.map = null;
        } else {
            this.map = builder.cacheMode == CacheMode.WEAK ? Collections.synchronizedMap(new WeakHashMap()) : new ConcurrentHashMap<Tuple3<K1, K2, K3>, V>();
            this.threadLocalMap = null;
        }
        if (builder.logOnExit) {
            SystemUtils.shutdownMessage(() -> builder.id + ":  hits=" + this.cacheHits.get() + ", misses: " + this.size());
        }
    }

    public void clear() {
        this.getMap().clear();
    }

    public boolean containsKey(K1 key1, K2 key2, K3 key3) {
        return this.getMap().containsKey(Tuple3.of(key1, key2, key3));
    }

    public boolean containsValue(V value) {
        if (value == null) {
            return false;
        }
        return this.getMap().containsValue(value);
    }

    public V get(K1 key1, K2 key2, K3 key3) {
        return (V)this.get(key1, key2, key3, () -> this.supplier.apply(key1, key2, key3));
    }

    public V get(K1 key1, K2 key2, K3 key3, Supplier<V> supplier) {
        Tuple3<K1, K2, K3> wrapped;
        AssertionUtils.assertArgNotNull("supplier", supplier);
        if (this.cacheMode == CacheMode.NONE) {
            return supplier.get();
        }
        Map<Tuple3<K1, K2, K3>, V> m = this.getMap();
        V v = m.get(wrapped = Tuple3.of(key1, key2, key3));
        if (v == null) {
            if (this.size() > this.maxSize) {
                this.clear();
            }
            if ((v = supplier.get()) == null) {
                m.remove(wrapped);
            } else {
                m.putIfAbsent(wrapped, v);
            }
        } else {
            this.cacheHits.incrementAndGet();
        }
        return v;
    }

    public int getCacheHits() {
        return this.cacheHits.get();
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public V put(K1 key1, K2 key2, K3 key3, V value) {
        Map<Tuple3<K1, K2, K3>, V> m = this.getMap();
        if (value == null) {
            return m.remove(Tuple3.of(key1, key2, key3));
        }
        return m.put(Tuple3.of(key1, key2, key3), value);
    }

    public V remove(K1 key1, K2 key2, K3 key3) {
        return this.getMap().remove(Tuple3.of(key1, key2, key3));
    }

    public int size() {
        return this.getMap().size();
    }

    private Map<Tuple3<K1, K2, K3>, V> getMap() {
        return this.isThreadLocal ? this.threadLocalMap.get() : this.map;
    }

    public static class Builder<K1, K2, K3, V> {
        CacheMode cacheMode = Utils.env("juneau.cache.mode", CacheMode.FULL);
        int maxSize = Utils.env("juneau.cache.maxSize", 1000);
        String id = "Cache3";
        boolean logOnExit = Utils.env("juneau.cache.logOnExit", false);
        boolean threadLocal;
        Function3<K1, K2, K3, V> supplier;

        Builder() {
        }

        public Cache3<K1, K2, K3, V> build() {
            return new Cache3(this);
        }

        public Builder<K1, K2, K3, V> cacheMode(CacheMode value) {
            this.cacheMode = value;
            return this;
        }

        public Builder<K1, K2, K3, V> logOnExit(boolean value, String idValue) {
            this.id = idValue;
            this.logOnExit = value;
            return this;
        }

        public Builder<K1, K2, K3, V> logOnExit(String value) {
            this.id = value;
            this.logOnExit = true;
            return this;
        }

        public Builder<K1, K2, K3, V> maxSize(int value) {
            this.maxSize = value;
            return this;
        }

        public Builder<K1, K2, K3, V> supplier(Function3<K1, K2, K3, V> value) {
            this.supplier = value;
            return this;
        }

        public Builder<K1, K2, K3, V> threadLocal() {
            this.threadLocal = true;
            return this;
        }

        public Builder<K1, K2, K3, V> weak() {
            return this.cacheMode(CacheMode.WEAK);
        }
    }
}

