/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.swagger;

import jakarta.servlet.ServletException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.annotation.ExternalDocs;
import org.apache.juneau.annotation.ExternalDocsAnnotation;
import org.apache.juneau.annotation.Items;
import org.apache.juneau.annotation.ItemsAnnotation;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SchemaAnnotation;
import org.apache.juneau.annotation.SubItems;
import org.apache.juneau.annotation.SubItemsAnnotation;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.http.annotation.Contact;
import org.apache.juneau.http.annotation.ContactAnnotation;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.FormDataAnnotation;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.HeaderAnnotation;
import org.apache.juneau.http.annotation.License;
import org.apache.juneau.http.annotation.LicenseAnnotation;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.PathAnnotation;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.QueryAnnotation;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseAnnotation;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.annotation.Tag;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.annotation.OpSwagger;
import org.apache.juneau.rest.annotation.OpSwaggerAnnotation;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.annotation.SwaggerAnnotation;
import org.apache.juneau.rest.httppart.RestPartType;
import org.apache.juneau.rest.swagger.SwaggerException;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.svl.VarResolverSession;

public class BasicSwaggerProviderSession {
    private final RestContext context;
    private final Class<?> c;
    private final ClassInfo rci;
    private final FileFinder ff;
    private final Messages mb;
    private final VarResolverSession vr;
    private final JsonParser jp = JsonParser.create().ignoreUnknownBeanProperties().build();
    private final JsonSchemaGeneratorSession js;
    private final Locale locale;

    private static Set<Integer> getCodes(List<StatusCode> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (StatusCode a : la) {
            for (int i : a.value()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && Utils.nn((Object)def)) {
            codes.add(def);
        }
        return codes;
    }

    private static JsonMap newMap(JsonMap om) {
        if (om == null) {
            return new JsonMap();
        }
        return om.modifiable();
    }

    private static JsonList nullIfEmpty(JsonList l) {
        return l == null || l.isEmpty() ? null : l;
    }

    private static JsonMap nullIfEmpty(JsonMap m) {
        return m == null || m.isEmpty() ? null : m;
    }

    static String joinnl(String[] ... s) {
        for (Object[] objectArray : s) {
            if (objectArray.length == 0) continue;
            return StringUtils.joinnl((Object[])objectArray).trim();
        }
        return "";
    }

    public BasicSwaggerProviderSession(RestContext context, Locale locale, FileFinder ff, Messages messages, VarResolverSession vr, JsonSchemaGeneratorSession js) {
        this.context = context;
        this.c = context.getResourceClass();
        this.rci = ClassInfo.of(this.c);
        this.ff = ff;
        this.mb = messages;
        this.vr = vr;
        this.js = js;
        this.locale = locale;
    }

    public Swagger getSwagger() throws Exception {
        String s;
        InputStream is = this.ff.getStream(this.rci.getNameSimple() + ".json", this.locale).orElse(null);
        AnnotationProvider ap = this.context.getBeanContext().getAnnotationProvider();
        Predicate<String> ne = Utils::ne;
        Predicate<Collection> nec = Utils::ne;
        Predicate<Map> nem = Utils::ne;
        JsonMap omSwagger = (JsonMap)Json5.DEFAULT.read((Object)is, JsonMap.class);
        if (omSwagger == null) {
            omSwagger = new JsonMap();
        }
        List<Rest> restAnnotations = CollectionUtils.rstream((List)ap.find(Rest.class, this.rci, new AnnotationTraversal[0])).map(AnnotationInfo::inner).toList();
        for (Rest rr : restAnnotations) {
            JsonMap sInfo = omSwagger.getMap("info", true);
            sInfo.appendIf(ne, "title", (Object)BasicSwaggerProviderSession.firstNonEmpty(sInfo.getString("title"), this.resolve(new String[][]{rr.title()}))).appendIf(ne, "description", (Object)BasicSwaggerProviderSession.firstNonEmpty(sInfo.getString("description"), this.resolve(new String[][]{rr.description()})));
            org.apache.juneau.rest.annotation.Swagger r = rr.swagger();
            omSwagger.append((Map)this.parseMap(r.value(), "@Swagger(value) on class {0}", this.c));
            if (!SwaggerAnnotation.empty(r)) {
                JsonMap info = omSwagger.getMap("info", true);
                info.appendIf(ne, "title", (Object)this.resolve(new String[][]{r.title()})).appendIf(ne, "description", (Object)this.resolve(new String[][]{r.description()})).appendIf(ne, "version", (Object)this.resolve(r.version())).appendIf(ne, "termsOfService", (Object)this.resolve(new String[][]{r.termsOfService()})).appendIf(nem, "contact", (Object)BasicSwaggerProviderSession.merge(info.getMap("contact"), this.toMap(r.contact(), "@Swagger(contact) on class {0}", this.c))).appendIf(nem, "license", (Object)BasicSwaggerProviderSession.merge(info.getMap("license"), this.toMap(r.license(), "@Swagger(license) on class {0}", this.c)));
            }
            omSwagger.appendIf(nem, "externalDocs", (Object)BasicSwaggerProviderSession.merge(omSwagger.getMap("externalDocs"), this.toMap(r.externalDocs(), "@Swagger(externalDocs) on class {0}", this.c))).appendIf(nec, "tags", (Object)BasicSwaggerProviderSession.merge(omSwagger.getList("tags"), this.toList(r.tags(), "@Swagger(tags) on class {0}", this.c)));
        }
        omSwagger.appendIf(nem, "externalDocs", (Object)this.parseMap(this.mb.findFirstString(new String[]{"externalDocs"}), "Messages/externalDocs on class {0}", this.c));
        JsonMap info = omSwagger.getMap("info", true);
        info.appendIf(ne, "title", (Object)this.resolve(this.mb.findFirstString(new String[]{"title"}))).appendIf(ne, "description", (Object)this.resolve(this.mb.findFirstString(new String[]{"description"}))).appendIf(ne, "version", (Object)this.resolve(this.mb.findFirstString(new String[]{"version"}))).appendIf(ne, "termsOfService", (Object)this.resolve(this.mb.findFirstString(new String[]{"termsOfService"}))).appendIf(nem, "contact", (Object)this.parseMap(this.mb.findFirstString(new String[]{"contact"}), "Messages/contact on class {0}", this.c)).appendIf(nem, "license", (Object)this.parseMap(this.mb.findFirstString(new String[]{"license"}), "Messages/license on class {0}", this.c));
        if (info.isEmpty()) {
            omSwagger.remove((Object)"info");
        }
        JsonList produces = omSwagger.getList("produces", true);
        JsonList consumes = omSwagger.getList("consumes", true);
        if (consumes.isEmpty()) {
            consumes.addAll(this.context.getConsumes());
        }
        if (produces.isEmpty()) {
            produces.addAll(this.context.getProduces());
        }
        LinkedHashMap tagMap = CollectionUtils.map();
        if (omSwagger.containsKey((Object)"tags")) {
            for (Object om : omSwagger.getList("tags").elements(JsonMap.class)) {
                String name = om.getString("name");
                if (name == null) {
                    throw new SwaggerException(null, "Tag definition found without name in swagger JSON.", new Object[0]);
                }
                tagMap.put(name, om);
            }
        }
        if (Utils.nn((Object)(s = this.mb.findFirstString(new String[]{"tags"})))) {
            for (Iterator<Object> m : this.parseListOrCdl(s, "Messages/tags on class {0}", this.c).elements(JsonMap.class)) {
                String string = m.getString("name");
                if (string == null) {
                    throw new SwaggerException(null, "Tag definition found without name in resource bundle on class {0}", this.c);
                }
                if (tagMap.containsKey(string)) {
                    ((JsonMap)tagMap.get(string)).putAll(m);
                    continue;
                }
                tagMap.put(string, m);
            }
        }
        JsonMap definitions = omSwagger.getMap("definitions", true);
        for (String string : definitions.keySet()) {
            this.js.addBeanDef(string, new JsonMap((Map)definitions.getMap(string)));
        }
        for (RestOpContext restOpContext : this.context.getRestOperations().getOpContexts()) {
            List<MediaType> mProduces;
            List<MediaType> mConsumes;
            JsonMap header;
            Object tag22;
            BeanSession bs = restOpContext.getBeanContext().getSession();
            Method m = restOpContext.getJavaMethod();
            MethodInfo mi = MethodInfo.of((Method)m);
            List<AnnotationInfo<?>> al = CollectionUtils.rstream((List)ap.find(mi, new AnnotationTraversal[0])).filter(RestOpAnnotation.REST_OP_GROUP).toList();
            String mn = m.getName();
            JsonMap op = BasicSwaggerProviderSession.getOperation(omSwagger, restOpContext.getPathPattern(), restOpContext.getHttpMethod().toLowerCase());
            Value _ms = Value.empty();
            al.forEach(ai -> ai.getValue(OpSwagger.class, "swagger").filter(OpSwaggerAnnotation::notEmpty).ifPresent(x -> _ms.set(x)));
            OpSwagger ms = (OpSwagger)_ms.orElseGet(() -> OpSwaggerAnnotation.create().build());
            op.append((Map)this.parseMap(ms.value(), "@OpSwagger(value) on class {0} method {1}", this.c, m));
            op.appendIf(ne, "operationId", (Object)BasicSwaggerProviderSession.firstNonEmpty(this.resolve(ms.operationId()), op.getString("operationId"), mn));
            Value _summary = Value.empty();
            al.forEach(ai -> ai.getValue(String.class, "summary").filter(StringUtils.NOT_EMPTY).ifPresent(x -> _summary.set(x)));
            op.appendIf(ne, "summary", (Object)BasicSwaggerProviderSession.firstNonEmpty(this.resolve(new String[][]{ms.summary()}), this.resolve(this.mb.findFirstString(new String[]{mn + ".summary"})), op.getString("summary"), this.resolve((String)_summary.orElse(null))));
            Value _description = Value.empty();
            al.forEach(ai -> ai.getValue(String[].class, "description").filter(x -> ((String[])x).length > 0).ifPresent(x -> _description.set(x)));
            op.appendIf(ne, "description", (Object)BasicSwaggerProviderSession.firstNonEmpty(this.resolve(new String[][]{ms.description()}), this.resolve(this.mb.findFirstString(new String[]{mn + ".description"})), op.getString("description"), this.resolve(new String[][]{(String[])_description.orElse((Object)new String[0])})));
            op.appendIf(ne, "deprecated", (Object)BasicSwaggerProviderSession.firstNonEmpty(this.resolve(ms.deprecated()), Utils.nn((Object)m.getAnnotation(Deprecated.class)) || Utils.nn(ClassInfo.of(m.getDeclaringClass()).getAnnotations(Deprecated.class).findFirst().map(AnnotationInfo::inner).orElse(null)) ? "true" : null));
            op.appendIf(nec, "tags", (Object)BasicSwaggerProviderSession.merge(this.parseListOrCdl(this.mb.findFirstString(new String[]{mn + ".tags"}), "Messages/tags on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.tags(), "@OpSwagger(tags) on class {0} method {1}", this.c, m)));
            op.appendIf(nec, "schemes", (Object)BasicSwaggerProviderSession.merge(this.parseListOrCdl(this.mb.findFirstString(new String[]{mn + ".schemes"}), "Messages/schemes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.schemes(), "@OpSwagger(schemes) on class {0} method {1}", this.c, m)));
            op.appendIf(nec, "consumes", (Object)((Collection)BasicSwaggerProviderSession.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(new String[]{mn + ".consumes"}), "Messages/consumes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.consumes(), "@OpSwagger(consumes) on class {0} method {1}", this.c, m))));
            op.appendIf(nec, "produces", (Object)((Collection)BasicSwaggerProviderSession.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(new String[]{mn + ".produces"}), "Messages/produces on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.produces(), "@OpSwagger(produces) on class {0} method {1}", this.c, m))));
            op.appendIf(nec, "parameters", (Object)BasicSwaggerProviderSession.merge(this.parseList(this.mb.findFirstString(new String[]{mn + ".parameters"}), "Messages/parameters on class {0} method {1}", this.c, m), this.parseList(ms.parameters(), "@OpSwagger(parameters) on class {0} method {1}", this.c, m)));
            op.appendIf(nem, "responses", (Object)BasicSwaggerProviderSession.merge(this.parseMap(this.mb.findFirstString(new String[]{mn + ".responses"}), "Messages/responses on class {0} method {1}", this.c, m), this.parseMap(ms.responses(), "@OpSwagger(responses) on class {0} method {1}", this.c, m)));
            op.appendIf(nem, "externalDocs", (Object)BasicSwaggerProviderSession.merge(op.getMap("externalDocs"), this.parseMap(this.mb.findFirstString(new String[]{mn + ".externalDocs"}), "Messages/externalDocs on class {0} method {1}", this.c, m), this.toMap(ms.externalDocs(), "@OpSwagger(externalDocs) on class {0} method {1}", this.c, m)));
            if (op.containsKey((Object)"tags")) {
                for (Object tag22 : op.getList("tags").elements(String.class)) {
                    if (tagMap.containsKey(tag22)) continue;
                    tagMap.put(tag22, JsonMap.of((Object[])new Object[]{"name", tag22}));
                }
            }
            JsonMap paramMap = new JsonMap();
            if (op.containsKey((Object)"parameters")) {
                for (JsonMap param : op.getList("parameters").elements(JsonMap.class)) {
                    paramMap.put(param.getString("in") + "." + ("body".equals(param.getString("in")) ? "body" : param.getString("name")), (Object)param);
                }
            }
            tag22 = mi.getParameters().iterator();
            while (tag22.hasNext()) {
                JsonMap param;
                String name;
                ParameterInfo mpi = (ParameterInfo)tag22.next();
                ClassInfo pt = mpi.getParameterType();
                Type type = pt.innerType();
                if (ap.has(Content.class, mpi, new AnnotationTraversal[0])) {
                    JsonMap param2 = paramMap.getMap(String.valueOf((Object)RestPartType.BODY) + ".body", true).append("in", (Object)RestPartType.BODY);
                    JsonMap schema = this.getSchema(param2.getMap("schema"), type, bs);
                    CollectionUtils.rstream((List)ap.find(Schema.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(schema, (Schema)x.inner()));
                    CollectionUtils.rstream((List)ap.find(Content.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(schema, ((Content)x.inner()).schema()));
                    BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.BODY, param2, schema);
                    param2.appendIf(nem, "schema", (Object)schema);
                    param2.putIfAbsent((Object)"required", (Object)true);
                    this.addBodyExamples(restOpContext, param2, false, type, this.locale);
                    continue;
                }
                if (ap.has(Query.class, mpi, new AnnotationTraversal[0])) {
                    name = QueryAnnotation.findName((ParameterInfo)mpi).orElse(null);
                    param = paramMap.getMap(String.valueOf((Object)RestPartType.QUERY) + "." + name, true).append("name", (Object)name).append("in", (Object)RestPartType.QUERY);
                    CollectionUtils.rstream((List)ap.find(Schema.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(param, (Schema)x.inner()));
                    CollectionUtils.rstream((List)ap.find(Query.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(param, ((Query)x.inner()).schema()));
                    BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.QUERY, param, this.getSchema(param.getMap("schema"), type, bs));
                    BasicSwaggerProviderSession.addParamExample(restOpContext, param, RestPartType.QUERY, type);
                    continue;
                }
                if (ap.has(FormData.class, mpi, new AnnotationTraversal[0])) {
                    name = FormDataAnnotation.findName((ParameterInfo)mpi).orElse(null);
                    param = paramMap.getMap(String.valueOf((Object)RestPartType.FORM_DATA) + "." + name, true).append("name", (Object)name).append("in", (Object)RestPartType.FORM_DATA);
                    CollectionUtils.rstream((List)ap.find(Schema.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(param, (Schema)x.inner()));
                    CollectionUtils.rstream((List)ap.find(FormData.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(param, ((FormData)x.inner()).schema()));
                    BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.FORM_DATA, param, this.getSchema(param.getMap("schema"), type, bs));
                    BasicSwaggerProviderSession.addParamExample(restOpContext, param, RestPartType.FORM_DATA, type);
                    continue;
                }
                if (ap.has(Header.class, mpi, new AnnotationTraversal[0])) {
                    name = HeaderAnnotation.findName((ParameterInfo)mpi).orElse(null);
                    param = paramMap.getMap(String.valueOf((Object)RestPartType.HEADER) + "." + name, true).append("name", (Object)name).append("in", (Object)RestPartType.HEADER);
                    CollectionUtils.rstream((List)ap.find(Schema.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(param, (Schema)x.inner()));
                    CollectionUtils.rstream((List)ap.find(Header.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(param, ((Header)x.inner()).schema()));
                    BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.HEADER, param, this.getSchema(param.getMap("schema"), type, bs));
                    BasicSwaggerProviderSession.addParamExample(restOpContext, param, RestPartType.HEADER, type);
                    continue;
                }
                if (!ap.has(Path.class, mpi, new AnnotationTraversal[0])) continue;
                name = PathAnnotation.findName((ParameterInfo)mpi).orElse(null);
                param = paramMap.getMap(String.valueOf((Object)RestPartType.PATH) + "." + name, true).append("name", (Object)name).append("in", (Object)RestPartType.PATH);
                CollectionUtils.rstream((List)ap.find(Schema.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(param, (Schema)x.inner()));
                CollectionUtils.rstream((List)ap.find(Path.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(param, ((Path)x.inner()).schema()));
                BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.PATH, param, this.getSchema(param.getMap("schema"), type, bs));
                BasicSwaggerProviderSession.addParamExample(restOpContext, param, RestPartType.PATH, type);
                param.putIfAbsent((Object)"required", (Object)true);
            }
            if (!paramMap.isEmpty()) {
                op.put("parameters", (Object)paramMap.values());
            }
            JsonMap responses = op.getMap("responses", true);
            for (ClassInfo eci : mi.getExceptionTypes()) {
                if (!eci.hasAnnotation(Response.class)) continue;
                List<Response> la = CollectionUtils.rstream((List)ap.find(Response.class, eci, new AnnotationTraversal[0])).map(AnnotationInfo::inner).toList();
                List<StatusCode> la2 = CollectionUtils.rstream((List)ap.find(StatusCode.class, eci, new AnnotationTraversal[0])).map(x -> (StatusCode)x.inner()).toList();
                Set<Integer> codes = BasicSwaggerProviderSession.getCodes(la2, 500);
                for (Response a : la) {
                    for (Integer code : codes) {
                        JsonMap om = responses.getMap(String.valueOf(code), true);
                        this.merge(om, a);
                        JsonMap schema = this.getSchema(om.getMap("schema"), m.getGenericReturnType(), bs);
                        CollectionUtils.rstream((List)ap.find(Schema.class, eci, new AnnotationTraversal[0])).forEach(x -> this.merge(schema, (Schema)x.inner()));
                        BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.RESPONSE, om, schema);
                        om.appendIf(nem, "schema", (Object)schema);
                    }
                }
                List methods = eci.getAllMethods();
                for (int i = methods.size() - 1; i >= 0; --i) {
                    MethodInfo ecmi = (MethodInfo)methods.get(i);
                    Header a = ecmi.getAnnotations(Header.class).findFirst().map(AnnotationInfo::inner).orElse(null);
                    if (a == null) {
                        a = ecmi.getReturnType().unwrap(new Class[]{Value.class, Optional.class}).getAnnotations(Header.class).findFirst().map(AnnotationInfo::inner).orElse(null);
                    }
                    if (!Utils.nn((Object)a) || BasicSwaggerProviderSession.isMulti(a)) continue;
                    String ha = a.name();
                    for (Integer code : codes) {
                        header = responses.getMap(String.valueOf(code), true).getMap("headers", true).getMap(ha, true);
                        CollectionUtils.rstream((List)ap.find(Schema.class, ecmi, new AnnotationTraversal[0])).forEach(x -> this.merge(header, (Schema)x.inner()));
                        CollectionUtils.rstream((List)ap.find(Schema.class, ecmi.getReturnType().unwrap(new Class[]{Value.class, Optional.class}), new AnnotationTraversal[0])).forEach(x -> this.merge(header, (Schema)x.inner()));
                        BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.RESPONSE_HEADER, header, this.getSchema(header.getMap("schema"), ecmi.getReturnType().unwrap(new Class[]{Value.class, Optional.class}).innerType(), bs));
                    }
                }
            }
            if (mi.hasAnnotation(Response.class) || mi.getReturnType().unwrap(new Class[]{Value.class, Optional.class}).hasAnnotation(Response.class)) {
                List<Response> la = CollectionUtils.rstream((List)ap.find(Response.class, mi, new AnnotationTraversal[0])).map(x -> (Response)x.inner()).toList();
                List<StatusCode> la2 = CollectionUtils.rstream((List)ap.find(StatusCode.class, mi, new AnnotationTraversal[0])).map(x -> (StatusCode)x.inner()).toList();
                Set<Integer> codes = BasicSwaggerProviderSession.getCodes(la2, 200);
                for (Response a : la) {
                    for (Integer code : codes) {
                        JsonMap om = responses.getMap(String.valueOf(code), true);
                        this.merge(om, a);
                        JsonMap schema = this.getSchema(om.getMap("schema"), m.getGenericReturnType(), bs);
                        CollectionUtils.rstream((List)ap.find(Schema.class, mi, new AnnotationTraversal[0])).forEach(x -> this.merge(schema, (Schema)x.inner()));
                        BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.RESPONSE, om, schema);
                        om.appendIf(nem, "schema", (Object)schema);
                        this.addBodyExamples(restOpContext, om, true, m.getGenericReturnType(), this.locale);
                    }
                }
                if (mi.getReturnType().hasAnnotation(Response.class)) {
                    List methods = mi.getReturnType().getAllMethods();
                    for (int i = methods.size() - 1; i >= 0; --i) {
                        MethodInfo ecmi = (MethodInfo)methods.get(i);
                        if (!ecmi.hasAnnotation(Header.class)) continue;
                        Header a = ecmi.getAnnotations(Header.class).findFirst().map(AnnotationInfo::inner).orElse(null);
                        String ha = a.name();
                        if (BasicSwaggerProviderSession.isMulti(a)) continue;
                        for (Integer code : codes) {
                            JsonMap header2 = responses.getMap(String.valueOf(code), true).getMap("headers", true).getMap(ha, true);
                            CollectionUtils.rstream((List)ap.find(Schema.class, ecmi, new AnnotationTraversal[0])).forEach(x -> this.merge(header2, (Schema)x.inner()));
                            CollectionUtils.rstream((List)ap.find(Schema.class, ecmi.getReturnType().unwrap(new Class[]{Value.class, Optional.class}), new AnnotationTraversal[0])).forEach(x -> this.merge(header2, (Schema)x.inner()));
                            this.merge(header2, a.schema());
                            BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.RESPONSE_HEADER, header2, this.getSchema(header2, ecmi.getReturnType().innerType(), bs));
                        }
                    }
                }
            } else if (m.getGenericReturnType() != Void.TYPE) {
                JsonMap om = responses.getMap("200", true);
                ClassInfo pt2 = ClassInfo.of((Type)m.getGenericReturnType());
                JsonMap schema = this.getSchema(om.getMap("schema"), m.getGenericReturnType(), bs);
                CollectionUtils.rstream((List)ap.find(Schema.class, pt2, new AnnotationTraversal[0])).forEach(x -> this.merge(schema, (Schema)x.inner()));
                BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.RESPONSE, om, schema);
                om.appendIf(nem, "schema", (Object)schema);
                this.addBodyExamples(restOpContext, om, true, m.getGenericReturnType(), this.locale);
            }
            for (ParameterInfo mpi : mi.getParameters()) {
                Set<Integer> codes;
                List<Header> la;
                ClassInfo pt = mpi.getParameterType();
                if (pt.is(Value.class) && ap.has(Header.class, mpi, new AnnotationTraversal[0])) {
                    la = CollectionUtils.rstream((List)ap.find(Header.class, mpi, new AnnotationTraversal[0])).map(AnnotationInfo::inner).toList();
                    List<StatusCode> la2 = CollectionUtils.rstream((List)ap.find(StatusCode.class, mpi, new AnnotationTraversal[0])).map(AnnotationInfo::inner).toList();
                    codes = BasicSwaggerProviderSession.getCodes(la2, 200);
                    String name = HeaderAnnotation.findName((ParameterInfo)mpi).orElse(null);
                    Type type = Value.unwrap((Type)mpi.getParameterType().innerType());
                    for (Header a : la) {
                        if (BasicSwaggerProviderSession.isMulti(a)) continue;
                        for (Integer code : codes) {
                            header = responses.getMap(String.valueOf(code), true).getMap("headers", true).getMap(name, true);
                            CollectionUtils.rstream((List)ap.find(Schema.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(header, (Schema)x.inner()));
                            this.merge(header, a.schema());
                            BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.RESPONSE_HEADER, header, this.getSchema(header, type, bs));
                        }
                    }
                    continue;
                }
                if (!ap.has(Response.class, mpi, new AnnotationTraversal[0])) continue;
                la = CollectionUtils.rstream((List)ap.find(Response.class, mpi, new AnnotationTraversal[0])).map(AnnotationInfo::inner).toList();
                List<StatusCode> la2 = CollectionUtils.rstream((List)ap.find(StatusCode.class, mpi, new AnnotationTraversal[0])).map(AnnotationInfo::inner).toList();
                codes = BasicSwaggerProviderSession.getCodes(la2, 200);
                Type type = Value.unwrap((Type)mpi.getParameterType().innerType());
                for (Header a : la) {
                    for (Integer code : codes) {
                        JsonMap om = responses.getMap(String.valueOf(code), true);
                        this.merge(om, (Response)a);
                        JsonMap schema = this.getSchema(om.getMap("schema"), type, bs);
                        CollectionUtils.rstream((List)ap.find(Schema.class, mpi, new AnnotationTraversal[0])).forEach(x -> this.merge(schema, (Schema)x.inner()));
                        la.forEach(x -> this.merge(schema, x.schema()));
                        BasicSwaggerProviderSession.pushupSchemaFields(RestPartType.RESPONSE, om, schema);
                        om.appendIf(nem, "schema", (Object)schema);
                    }
                }
            }
            for (Map.Entry e : responses.entrySet()) {
                String key = (String)e.getKey();
                JsonMap val = responses.getMap(key);
                if (!StringUtils.isDecimal((String)key)) continue;
                val.appendIfAbsentIf(ne, "description", (Object)RestUtils.getHttpResponseText(Integer.parseInt(key)));
            }
            if (responses.isEmpty()) {
                op.remove((Object)"responses");
            } else {
                op.put("responses", new TreeMap(responses));
            }
            if (!op.containsKey((Object)"consumes") && !(mConsumes = restOpContext.getSupportedContentTypes()).equals(consumes)) {
                op.put("consumes", mConsumes);
            }
            if (op.containsKey((Object)"produces") || (mProduces = restOpContext.getSupportedAcceptTypes()).equals(produces)) continue;
            op.put("produces", mProduces);
        }
        if (Utils.nn((Object)this.js.getBeanDefs())) {
            for (Map.Entry entry : this.js.getBeanDefs().entrySet()) {
                definitions.put((String)entry.getKey(), (Object)BasicSwaggerProviderSession.fixSwaggerExtensions((JsonMap)entry.getValue()));
            }
        }
        if (definitions.isEmpty()) {
            omSwagger.remove((Object)"definitions");
        }
        if (!tagMap.isEmpty()) {
            omSwagger.put("tags", tagMap.values());
        }
        if (consumes.isEmpty()) {
            omSwagger.remove((Object)"consumes");
        }
        if (produces.isEmpty()) {
            omSwagger.remove((Object)"produces");
        }
        try {
            String swaggerJson = Json5Serializer.DEFAULT_READABLE.toString((Object)omSwagger);
            return (Swagger)this.jp.parse(swaggerJson, Swagger.class);
        }
        catch (Exception e) {
            throw new ServletException("Error detected in swagger.", (Throwable)e);
        }
    }

    private void addBodyExamples(RestOpContext sm, JsonMap piri, boolean response, Type type, Locale locale) throws Exception {
        JsonMap schema;
        String sex = piri.getString("example");
        if (sex == null && Utils.nn((Object)(schema = this.resolveRef(piri.getMap("schema"))))) {
            sex = schema.getString("example", schema.getString("example"));
        }
        if (StringUtils.isEmpty((String)sex)) {
            return;
        }
        Object example = null;
        if (StringUtils.isProbablyJson((String)sex)) {
            example = this.jp.parse(sex, type, new Type[0]);
        } else {
            ClassMeta cm = this.js.getClassMeta(type, new Type[0]);
            if (cm.hasStringMutater()) {
                example = cm.getStringMutater().mutate((Object)sex);
            }
        }
        String examplesKey = "examples";
        JsonMap examples = piri.getMap(examplesKey);
        if (examples == null) {
            examples = new JsonMap();
        }
        List mediaTypes = response ? sm.getSerializers().getSupportedMediaTypes() : sm.getParsers().getSupportedMediaTypes();
        for (MediaType mt : mediaTypes) {
            Serializer s2;
            if (mt == MediaType.HTML || !Utils.nn((Object)(s2 = sm.getSerializers().getSerializer(mt)))) continue;
            try {
                String eVal = s2.createSession().locale(locale).mediaType(mt).apply(WriterSerializerSession.Builder.class, x -> x.useWhitespace(Boolean.valueOf(true))).build().serializeToString(example);
                examples.put(s2.getPrimaryMediaType().toString(), (Object)eVal);
            }
            catch (Exception e) {
                System.err.println("Could not serialize to media type [" + String.valueOf(mt) + "]: " + ThrowableUtils.lm((Throwable)e));
            }
        }
        if (!examples.isEmpty()) {
            piri.put(examplesKey, (Object)examples);
        }
    }

    private static void addParamExample(RestOpContext sm, JsonMap piri, RestPartType in, Type type) throws Exception {
        Object s = piri.getString("example");
        if (StringUtils.isEmpty((String)s)) {
            return;
        }
        JsonMap examples = piri.getMap("examples");
        if (examples == null) {
            examples = new JsonMap();
        }
        String paramName = piri.getString("name");
        if (in == RestPartType.QUERY) {
            s = "?" + StringUtils.urlEncodeLax((String)paramName) + "=" + StringUtils.urlEncodeLax((String)s);
        } else if (in == RestPartType.FORM_DATA) {
            s = paramName + "=" + (String)s;
        } else if (in == RestPartType.HEADER) {
            s = paramName + ": " + (String)s;
        } else if (in == RestPartType.PATH) {
            s = sm.getPathPattern().replace("{" + paramName + "}", StringUtils.urlEncodeLax((String)s));
        }
        examples.put("example", s);
        if (!examples.isEmpty()) {
            piri.put("examples", (Object)examples);
        }
    }

    @SafeVarargs
    private static final <T> T firstNonEmpty(T ... t) {
        for (T oo : t) {
            if (!Utils.ne(oo)) continue;
            return oo;
        }
        return null;
    }

    private static JsonMap fixSwaggerExtensions(JsonMap om) {
        Predicate<Object> nn = Utils::nn;
        om.appendIf(nn, "discriminator", om.remove((Object)"x-discriminator")).appendIf(nn, "readOnly", om.remove((Object)"x-readOnly")).appendIf(nn, "xml", om.remove((Object)"x-xml")).appendIf(nn, "externalDocs", om.remove((Object)"x-externalDocs")).appendIf(nn, "example", om.remove((Object)"x-example"));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private static JsonMap getOperation(JsonMap om, String path, String httpMethod) {
        if (!om.containsKey((Object)"paths")) {
            om.put("paths", (Object)new JsonMap());
        }
        if (!(om = om.getMap("paths")).containsKey((Object)path)) {
            om.put(path, (Object)new JsonMap());
        }
        if (!(om = om.getMap(path)).containsKey((Object)httpMethod)) {
            om.put(httpMethod, (Object)new JsonMap());
        }
        return om.getMap(httpMethod);
    }

    private JsonMap getSchema(JsonMap schema, Type type, BeanSession bs) throws Exception {
        if (type == Swagger.class) {
            return JsonMap.create();
        }
        schema = BasicSwaggerProviderSession.newMap(schema);
        ClassMeta cm = bs.getClassMeta(type, new Type[0]);
        if (schema.getBoolean("ignore", Boolean.valueOf(false)).booleanValue()) {
            return null;
        }
        if (schema.containsKey((Object)"type") || schema.containsKey((Object)"$ref")) {
            return schema;
        }
        JsonMap om = BasicSwaggerProviderSession.fixSwaggerExtensions(schema.append((Map)this.js.getSchema(cm)));
        return om;
    }

    private static boolean isMulti(Header h) {
        return "*".equals(h.name()) || "*".equals(h.value());
    }

    private static JsonList merge(JsonList ... lists) {
        JsonList l = lists[0];
        for (int i = 1; i < lists.length; ++i) {
            if (!Utils.nn((Object)lists[i])) continue;
            if (l == null) {
                l = new JsonList();
            }
            l.addAll((Collection)lists[i]);
        }
        return l;
    }

    private static JsonMap merge(JsonMap ... maps) {
        JsonMap m = maps[0];
        for (int i = 1; i < maps.length; ++i) {
            if (!Utils.nn((Object)maps[i])) continue;
            if (m == null) {
                m = new JsonMap();
            }
            m.putAll((Map)maps[i]);
        }
        return m;
    }

    private JsonMap merge(JsonMap om, ExternalDocs a) {
        if (ExternalDocsAnnotation.empty((ExternalDocs)a)) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        Predicate<String> ne = Utils::ne;
        return om.appendIf(ne, "description", (Object)this.resolve(new String[][]{a.description()})).appendIf(ne, "url", (Object)a.url());
    }

    private JsonMap merge(JsonMap om, Header[] a) {
        if (a.length == 0) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        for (Header aa : a) {
            String name = StringUtils.firstNonEmpty((String[])new String[]{aa.name(), aa.value()});
            if (StringUtils.isEmpty((String)name)) {
                throw ThrowableUtils.illegalArg((String)"@Header used without name or value.", (Object[])new Object[0]);
            }
            this.merge(om.getMap(name, true), aa.schema());
        }
        return om;
    }

    private JsonMap merge(JsonMap om, Items a) throws ParseException {
        if (ItemsAnnotation.empty((Items)a)) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        Predicate<String> ne = Utils::ne;
        Predicate<Collection> nec = Utils::ne;
        Predicate<Map> nem = Utils::ne;
        Predicate<Boolean> nf = Utils::isTrue;
        Predicate<Long> nm1 = Utils::nm1;
        return om.appendFirst(ne, "collectionFormat", (Object[])new String[]{a.collectionFormat(), a.cf()}).appendIf(ne, "default", (Object)BasicSwaggerProviderSession.joinnl(a.default_(), a.df())).appendFirst(nec, "enum", (Object[])new Collection[]{BasicSwaggerProviderSession.toSet(a.enum_()), BasicSwaggerProviderSession.toSet(a.e())}).appendFirst(ne, "format", (Object[])new String[]{a.format(), a.f()}).appendIf(nf, "exclusiveMaximum", (Object)(a.exclusiveMaximum() || a.emax() ? 1 : 0)).appendIf(nf, "exclusiveMinimum", (Object)(a.exclusiveMinimum() || a.emin() ? 1 : 0)).appendIf(nem, "items", (Object)this.merge(om.getMap("items"), a.items())).appendFirst(ne, "maximum", (Object[])new String[]{a.maximum(), a.max()}).appendFirst(nm1, "maxItems", (Object[])new Long[]{a.maxItems(), a.maxi()}).appendFirst(nm1, "maxLength", (Object[])new Long[]{a.maxLength(), a.maxl()}).appendFirst(ne, "minimum", (Object[])new String[]{a.minimum(), a.min()}).appendFirst(nm1, "minItems", (Object[])new Long[]{a.minItems(), a.mini()}).appendFirst(nm1, "minLength", (Object[])new Long[]{a.minLength(), a.minl()}).appendFirst(ne, "multipleOf", (Object[])new String[]{a.multipleOf(), a.mo()}).appendFirst(ne, "pattern", (Object[])new String[]{a.pattern(), a.p()}).appendIf(nf, "uniqueItems", (Object)(a.uniqueItems() || a.ui() ? 1 : 0)).appendFirst(ne, "type", (Object[])new String[]{a.type(), a.t()}).appendIf(ne, "$ref", (Object)a.$ref());
    }

    private JsonMap merge(JsonMap om, Response a) throws ParseException {
        if (ResponseAnnotation.empty((Response)a)) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        Predicate<Map> nem = Utils::ne;
        if (!SchemaAnnotation.empty((Schema)a.schema())) {
            this.merge(om, a.schema());
        }
        return om.appendIf(nem, "examples", (Object)this.parseMap(a.examples())).appendIf(nem, "headers", (Object)this.merge(om.getMap("headers"), a.headers())).appendIf(nem, "schema", (Object)this.merge(om.getMap("schema"), a.schema()));
    }

    private JsonMap merge(JsonMap om, Schema a) {
        try {
            if (SchemaAnnotation.empty((Schema)a)) {
                return om;
            }
            om = BasicSwaggerProviderSession.newMap(om);
            Predicate<String> ne = Utils::ne;
            Predicate<Collection> nec = Utils::ne;
            Predicate<Map> nem = Utils::ne;
            Predicate<Boolean> nf = Utils::isTrue;
            Predicate<Long> nm1 = Utils::nm1;
            return om.appendIf(nem, "additionalProperties", (Object)this.toJsonMap(a.additionalProperties())).appendIf(ne, "allOf", (Object)BasicSwaggerProviderSession.joinnl(new String[][]{a.allOf()})).appendFirst(ne, "collectionFormat", (Object[])new String[]{a.collectionFormat(), a.cf()}).appendIf(ne, "default", (Object)BasicSwaggerProviderSession.joinnl(a.default_(), a.df())).appendIf(ne, "discriminator", (Object)a.discriminator()).appendIf(ne, "description", (Object)this.resolve(a.description(), a.d())).appendFirst(nec, "enum", (Object[])new Collection[]{BasicSwaggerProviderSession.toSet(a.enum_()), BasicSwaggerProviderSession.toSet(a.e())}).appendIf(nf, "exclusiveMaximum", (Object)(a.exclusiveMaximum() || a.emax() ? 1 : 0)).appendIf(nf, "exclusiveMinimum", (Object)(a.exclusiveMinimum() || a.emin() ? 1 : 0)).appendIf(nem, "externalDocs", (Object)this.merge(om.getMap("externalDocs"), a.externalDocs())).appendFirst(ne, "format", (Object[])new String[]{a.format(), a.f()}).appendIf(ne, "ignore", (Object)(a.ignore() ? "true" : null)).appendIf(nem, "items", (Object)this.merge(om.getMap("items"), a.items())).appendFirst(ne, "maximum", (Object[])new String[]{a.maximum(), a.max()}).appendFirst(nm1, "maxItems", (Object[])new Long[]{a.maxItems(), a.maxi()}).appendFirst(nm1, "maxLength", (Object[])new Long[]{a.maxLength(), a.maxl()}).appendFirst(nm1, "maxProperties", (Object[])new Long[]{a.maxProperties(), a.maxp()}).appendFirst(ne, "minimum", (Object[])new String[]{a.minimum(), a.min()}).appendFirst(nm1, "minItems", (Object[])new Long[]{a.minItems(), a.mini()}).appendFirst(nm1, "minLength", (Object[])new Long[]{a.minLength(), a.minl()}).appendFirst(nm1, "minProperties", (Object[])new Long[]{a.minProperties(), a.minp()}).appendFirst(ne, "multipleOf", (Object[])new String[]{a.multipleOf(), a.mo()}).appendFirst(ne, "pattern", (Object[])new String[]{a.pattern(), a.p()}).appendIf(nem, "properties", (Object)this.toJsonMap(a.properties())).appendIf(nf, "readOnly", (Object)(a.readOnly() || a.ro() ? 1 : 0)).appendIf(nf, "required", (Object)(a.required() || a.r() ? 1 : 0)).appendIf(ne, "title", (Object)a.title()).appendFirst(ne, "type", (Object[])new String[]{a.type(), a.t()}).appendIf(nf, "uniqueItems", (Object)(a.uniqueItems() || a.ui() ? 1 : 0)).appendIf(ne, "xml", (Object)BasicSwaggerProviderSession.joinnl(new String[][]{a.xml()})).appendIf(ne, "$ref", (Object)a.$ref());
        }
        catch (ParseException e) {
            throw ThrowableUtils.illegalArg((Throwable)e);
        }
    }

    private JsonMap merge(JsonMap om, SubItems a) throws ParseException {
        if (SubItemsAnnotation.empty((SubItems)a)) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        Predicate<String> ne = Utils::ne;
        Predicate<Collection> nec = Utils::ne;
        Predicate<Map> nem = Utils::ne;
        Predicate<Boolean> nf = Utils::isTrue;
        Predicate<Long> nm1 = Utils::nm1;
        return om.appendFirst(ne, "collectionFormat", (Object[])new String[]{a.collectionFormat(), a.cf()}).appendIf(ne, "default", (Object)BasicSwaggerProviderSession.joinnl(a.default_(), a.df())).appendFirst(nec, "enum", (Object[])new Collection[]{BasicSwaggerProviderSession.toSet(a.enum_()), BasicSwaggerProviderSession.toSet(a.e())}).appendIf(nf, "exclusiveMaximum", (Object)(a.exclusiveMaximum() || a.emax() ? 1 : 0)).appendIf(nf, "exclusiveMinimum", (Object)(a.exclusiveMinimum() || a.emin() ? 1 : 0)).appendFirst(ne, "format", (Object[])new String[]{a.format(), a.f()}).appendIf(nem, "items", (Object)this.toJsonMap(a.items())).appendFirst(ne, "maximum", (Object[])new String[]{a.maximum(), a.max()}).appendFirst(nm1, "maxItems", (Object[])new Long[]{a.maxItems(), a.maxi()}).appendFirst(nm1, "maxLength", (Object[])new Long[]{a.maxLength(), a.maxl()}).appendFirst(ne, "minimum", (Object[])new String[]{a.minimum(), a.min()}).appendFirst(nm1, "minItems", (Object[])new Long[]{a.minItems(), a.mini()}).appendFirst(nm1, "minLength", (Object[])new Long[]{a.minLength(), a.minl()}).appendFirst(ne, "multipleOf", (Object[])new String[]{a.multipleOf(), a.mo()}).appendFirst(ne, "pattern", (Object[])new String[]{a.pattern(), a.p()}).appendFirst(ne, "type", (Object[])new String[]{a.type(), a.t()}).appendIf(nf, "uniqueItems", (Object)(a.uniqueItems() || a.ui() ? 1 : 0)).appendIf(ne, "$ref", (Object)a.$ref());
    }

    private JsonList parseList(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            Object s;
            if (o == null) {
                return null;
            }
            Object object = s = o instanceof String[] ? BasicSwaggerProviderSession.joinnl(new String[][]{(String[])o}) : o.toString();
            if (((String)s).isEmpty()) {
                return null;
            }
            if (!StringUtils.isProbablyJsonArray((Object)(s = this.resolve((String)s)), (boolean)true)) {
                s = "[" + (String)s + "]";
            }
            return JsonList.ofJson((CharSequence)s);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private JsonList parseListOrCdl(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? BasicSwaggerProviderSession.joinnl(new String[][]{(String[])o}) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            s = this.resolve(s);
            return JsonList.ofJsonOrCdl((String)s);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private JsonMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = BasicSwaggerProviderSession.joinnl(new String[][]{(String[])o});
        }
        if (o instanceof String) {
            Object o2 = (String)o;
            if (((String)o2).isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase((String)(o2 = this.resolve((String)o2)))) {
                return JsonMap.of((Object[])new Object[]{"ignore", true});
            }
            if (!StringUtils.isProbablyJsonObject((Object)o2, (boolean)true)) {
                o2 = "{" + (String)o2 + "}";
            }
            return JsonMap.ofJson((CharSequence)o2);
        }
        if (o instanceof JsonMap) {
            JsonMap o2 = (JsonMap)o;
            return o2;
        }
        throw new SwaggerException(null, "Unexpected data type ''{0}''.  Expected JsonMap or String.", Utils.cn((Object)o));
    }

    private JsonMap parseMap(String o, String location, Object ... args) throws ParseException {
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private JsonMap parseMap(String[] o, String location, Object ... args) throws ParseException {
        if (o.length == 0) {
            return JsonMap.EMPTY_MAP;
        }
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private static JsonMap pushupSchemaFields(RestPartType type, JsonMap param, JsonMap schema) {
        Predicate<Object> ne = Utils::ne;
        if (Utils.nn((Object)schema) && !schema.isEmpty()) {
            if (type == RestPartType.BODY || type == RestPartType.RESPONSE) {
                param.appendIf(ne, "description", schema.remove((Object)"description"));
            } else {
                param.appendIfAbsentIf(ne, "collectionFormat", schema.remove((Object)"collectionFormat")).appendIfAbsentIf(ne, "default", schema.remove((Object)"default")).appendIfAbsentIf(ne, "description", schema.remove((Object)"description")).appendIfAbsentIf(ne, "enum", schema.remove((Object)"enum")).appendIfAbsentIf(ne, "example", schema.remove((Object)"example")).appendIfAbsentIf(ne, "exclusiveMaximum", schema.remove((Object)"exclusiveMaximum")).appendIfAbsentIf(ne, "exclusiveMinimum", schema.remove((Object)"exclusiveMinimum")).appendIfAbsentIf(ne, "format", schema.remove((Object)"format")).appendIfAbsentIf(ne, "items", schema.remove((Object)"items")).appendIfAbsentIf(ne, "maximum", schema.remove((Object)"maximum")).appendIfAbsentIf(ne, "maxItems", schema.remove((Object)"maxItems")).appendIfAbsentIf(ne, "maxLength", schema.remove((Object)"maxLength")).appendIfAbsentIf(ne, "minimum", schema.remove((Object)"minimum")).appendIfAbsentIf(ne, "minItems", schema.remove((Object)"minItems")).appendIfAbsentIf(ne, "minLength", schema.remove((Object)"minLength")).appendIfAbsentIf(ne, "multipleOf", schema.remove((Object)"multipleOf")).appendIfAbsentIf(ne, "pattern", schema.remove((Object)"pattern")).appendIfAbsentIf(ne, "required", schema.remove((Object)"required")).appendIfAbsentIf(ne, "type", schema.remove((Object)"type")).appendIfAbsentIf(ne, "uniqueItems", schema.remove((Object)"uniqueItems"));
                if ("object".equals(param.getString("type")) && !schema.isEmpty()) {
                    param.put("schema", (Object)schema);
                }
            }
        }
        return param;
    }

    private JsonList resolve(JsonList om) throws ParseException {
        JsonList ol2 = new JsonList();
        for (Object val : om) {
            if (val instanceof JsonMap) {
                JsonMap val2 = (JsonMap)val;
                val = this.resolve(val2);
            } else if (val instanceof JsonList) {
                JsonList val3 = (JsonList)val;
                val = this.resolve(val3);
            } else if (val instanceof String) {
                String val4 = (String)val;
                val = this.resolve(val4);
            }
            ol2.add(val);
        }
        return ol2;
    }

    private JsonMap resolve(JsonMap om) throws ParseException {
        JsonMap om2 = null;
        if (om.containsKey((Object)"_value")) {
            om = om.modifiable();
            om2 = this.parseMap(om.remove((Object)"_value"));
        } else {
            om2 = new JsonMap();
        }
        for (Map.Entry e : om.entrySet()) {
            Object val = e.getValue();
            if (val instanceof JsonMap) {
                JsonMap val2 = (JsonMap)val;
                val = this.resolve(val2);
            } else if (val instanceof JsonList) {
                JsonList val3 = (JsonList)val;
                val = this.resolve(val3);
            } else if (val instanceof String) {
                String val4 = (String)val;
                val = this.resolve(val4);
            }
            om2.put((String)e.getKey(), val);
        }
        return om2;
    }

    private String resolve(String s) {
        if (s == null) {
            return null;
        }
        return this.vr.resolve(s.trim());
    }

    private String resolve(String[] ... s) {
        for (String[] ss : s) {
            if (ss.length == 0) continue;
            return this.resolve(BasicSwaggerProviderSession.joinnl(new String[][]{ss}));
        }
        return null;
    }

    private JsonMap resolveRef(JsonMap m) {
        String ref;
        if (m == null) {
            return null;
        }
        if (m.containsKey((Object)"$ref") && Utils.nn((Object)this.js.getBeanDefs()) && (ref = m.getString("$ref")).startsWith("#/definitions/")) {
            return (JsonMap)this.js.getBeanDefs().get(ref.substring(14));
        }
        return m;
    }

    private JsonMap toJsonMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        Object s = BasicSwaggerProviderSession.joinnl(new String[][]{ss});
        if (((String)s).isEmpty()) {
            return null;
        }
        if (!StringUtils.isProbablyJsonObject((Object)s, (boolean)true)) {
            s = "{" + (String)s + "}";
        }
        s = this.resolve((String)s);
        return JsonMap.ofJson((CharSequence)s);
    }

    private JsonList toList(Tag[] aa, String location, Object ... locationArgs) {
        if (aa.length == 0) {
            return null;
        }
        JsonList ol = new JsonList();
        for (Tag a : aa) {
            ol.add((Object)this.toMap(a, location, locationArgs));
        }
        return BasicSwaggerProviderSession.nullIfEmpty(ol);
    }

    private JsonMap toMap(Contact a, String location, Object ... locationArgs) {
        if (ContactAnnotation.empty((Contact)a)) {
            return null;
        }
        Predicate<String> ne = Utils::ne;
        JsonMap om = JsonMap.create().appendIf(ne, "name", (Object)this.resolve(a.name())).appendIf(ne, "url", (Object)this.resolve(a.url())).appendIf(ne, "email", (Object)this.resolve(a.email()));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private JsonMap toMap(ExternalDocs a, String location, Object ... locationArgs) {
        if (ExternalDocsAnnotation.empty((ExternalDocs)a)) {
            return null;
        }
        Predicate<String> ne = Utils::ne;
        JsonMap om = JsonMap.create().appendIf(ne, "description", (Object)this.resolve(BasicSwaggerProviderSession.joinnl(new String[][]{a.description()}))).appendIf(ne, "url", (Object)this.resolve(a.url()));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private JsonMap toMap(License a, String location, Object ... locationArgs) {
        if (LicenseAnnotation.empty((License)a)) {
            return null;
        }
        Predicate<String> ne = Utils::ne;
        JsonMap om = JsonMap.create().appendIf(ne, "name", (Object)this.resolve(a.name())).appendIf(ne, "url", (Object)this.resolve(a.url()));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private JsonMap toMap(Tag a, String location, Object ... locationArgs) {
        JsonMap om = JsonMap.create();
        Predicate<String> ne = Utils::ne;
        Predicate<Map> nem = Utils::ne;
        om.appendIf(ne, "name", (Object)this.resolve(a.name())).appendIf(ne, "description", (Object)this.resolve(BasicSwaggerProviderSession.joinnl(new String[][]{a.description()}))).appendIf(nem, "externalDocs", (Object)BasicSwaggerProviderSession.merge(om.getMap("externalDocs"), this.toMap(a.externalDocs(), location, locationArgs)));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private static Set<String> toSet(String[] ss) {
        if (ss.length == 0) {
            return null;
        }
        LinkedHashSet set = CollectionUtils.set((Object[])new String[0]);
        for (String s : ss) {
            StringUtils.split((String)s, x -> set.add(x));
        }
        return set.isEmpty() ? null : set;
    }
}

