/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap;

import java.util.Collection;
import java.util.Set;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.bag.mutable.SynchronizedBag;
import org.eclipse.collections.impl.map.mutable.SynchronizedMutableMap;
import org.eclipse.collections.impl.multimap.SynchronizedMultimapSerializationProxy;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.utility.LazyIterate;

public abstract class AbstractSynchronizedMultimap<K, V>
implements MutableMultimap<K, V> {
    protected final MutableMultimap<K, V> delegate;
    private final Object lock;

    protected AbstractSynchronizedMultimap(MutableMultimap<K, V> multimap, Object newLock) {
        if (multimap == null) {
            throw new IllegalArgumentException("Cannot create a AbstractSynchronizedMultimap on a null multimap");
        }
        this.delegate = multimap;
        this.lock = newLock == null ? this : newLock;
    }

    protected AbstractSynchronizedMultimap(MutableMultimap<K, V> multimap) {
        this(multimap, null);
    }

    protected MutableMultimap<K, V> getDelegate() {
        return this.delegate;
    }

    protected Object getLock() {
        return this.lock;
    }

    protected Object writeReplace() {
        return new SynchronizedMultimapSerializationProxy<K, V>(this.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Pair<? extends K, ? extends V> keyValuePair) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().add(keyValuePair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().remove(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMultimap<K, V> withKeyMultiValues(K key, V ... values) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().withKeyMultiValues(key, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putAllPairs(Pair<? extends K, ? extends V> ... pairs) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().putAllPairs(pairs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putAllPairs(Iterable<? extends Pair<? extends K, ? extends V>> pairs) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().putAllPairs(pairs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().putAll(key, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <KK extends K, VV extends V> boolean putAll(Multimap<KK, VV> multimap) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().putAll(multimap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachValue(Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEachValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEachKey(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEachKeyValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachKeyMultiValues(Procedure2<? super K, ? super RichIterable<V>> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEachKeyMultiValues(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeDistinct() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeyAndValue(Object key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsKeyAndValue(key, value);
        }
    }

    @Override
    public RichIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIterable<K> keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of((Set)((Object)this.getDelegate().keySet()), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bag<K> keyBag() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedBag.of(this.getDelegate().keyBag().toBag(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<RichIterable<V>> multiValuesView() {
        Object object = this.lock;
        synchronized (object) {
            return LazyIterate.adapt(this.getDelegate().multiValuesView());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<V> valuesView() {
        Object object = this.lock;
        synchronized (object) {
            return LazyIterate.adapt(this.getDelegate().valuesView());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<Pair<K, RichIterable<V>>> keyMultiValuePairsView() {
        Object object = this.lock;
        synchronized (object) {
            return LazyIterate.adapt(this.getDelegate().keyMultiValuePairsView());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<Pair<K, V>> keyValuePairsView() {
        Object object = this.lock;
        synchronized (object) {
            return LazyIterate.adapt(this.getDelegate().keyValuePairsView());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, RichIterable<V>> toMap() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableMap.of(this.getDelegate().toMap(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Collection<V>> MutableMap<K, R> toMap(Function0<R> collectionFactory) {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableMap.of(this.getDelegate().toMap(collectionFactory), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableMultimap<K, V>> R selectKeysValues(Predicate2<? super K, ? super V> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().selectKeysValues(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableMultimap<K, V>> R rejectKeysValues(Predicate2<? super K, ? super V> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().rejectKeysValues(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableMultimap<K, V>> R selectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().selectKeysMultiValues(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableMultimap<K, V>> R rejectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().rejectKeysMultiValues(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K2, V2, R extends MutableMultimap<K2, V2>> R collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectKeysValues(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K2, V2, R extends MutableMultimap<K2, V2>> R collectKeyMultiValues(Function<? super K, ? extends K2> keyFunction, Function<? super V, ? extends V2> valueFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectKeyMultiValues(keyFunction, valueFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V2, R extends MutableMultimap<K, V2>> R collectValues(Function<? super V, ? extends V2> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectValues(function, target);
        }
    }
}

