/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.planner.DataOrganizationSpecification;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TableFunctionNode
extends MultiChildProcessNode {
    private final String name;
    private final TableFunctionHandle tableFunctionHandle;
    private final List<Symbol> properOutputs;
    private final List<TableArgumentProperties> tableArgumentProperties;

    public TableFunctionNode(PlanNodeId id, String name, TableFunctionHandle tableFunctionHandle, List<Symbol> properOutputs, List<PlanNode> children, List<TableArgumentProperties> tableArgumentProperties) {
        super(id, children);
        this.name = Objects.requireNonNull(name, "name is null");
        this.tableFunctionHandle = tableFunctionHandle;
        this.properOutputs = ImmutableList.copyOf(properOutputs);
        this.tableArgumentProperties = ImmutableList.copyOf(tableArgumentProperties);
    }

    public TableFunctionNode(PlanNodeId id, String name, TableFunctionHandle tableFunctionHandle, List<Symbol> properOutputs, List<TableArgumentProperties> tableArgumentProperties) {
        super(id);
        this.name = Objects.requireNonNull(name, "name is null");
        this.tableFunctionHandle = tableFunctionHandle;
        this.properOutputs = ImmutableList.copyOf(properOutputs);
        this.tableArgumentProperties = ImmutableList.copyOf(tableArgumentProperties);
    }

    public String getName() {
        return this.name;
    }

    public TableFunctionHandle getTableFunctionHandle() {
        return this.tableFunctionHandle;
    }

    public List<Symbol> getProperOutputs() {
        return this.properOutputs;
    }

    public List<TableArgumentProperties> getTableArgumentProperties() {
        return this.tableArgumentProperties;
    }

    @Override
    public PlanNode clone() {
        return new TableFunctionNode(this.id, this.name, this.tableFunctionHandle, this.properOutputs, this.tableArgumentProperties);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder symbols = ImmutableList.builder();
        symbols.addAll(this.properOutputs);
        this.tableArgumentProperties.stream().map(TableArgumentProperties::getPassThroughSpecification).map(PassThroughSpecification::getColumns).flatMap(Collection::stream).map(PassThroughColumn::getSymbol).forEach(arg_0 -> ((ImmutableList.Builder)symbols).add(arg_0));
        return symbols.build();
    }

    @Override
    public List<String> getOutputColumnNames() {
        ImmutableList.Builder symbols = ImmutableList.builder();
        symbols.addAll((Iterable)this.properOutputs.stream().map(Symbol::getName).collect(Collectors.toList()));
        this.tableArgumentProperties.stream().map(TableArgumentProperties::getPassThroughSpecification).map(PassThroughSpecification::getColumns).flatMap(Collection::stream).map(PassThroughColumn::getSymbol).map(Symbol::getName).forEach(arg_0 -> ((ImmutableList.Builder)symbols).add(arg_0));
        return symbols.build();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newSources) {
        Preconditions.checkArgument((this.children.size() == newSources.size() ? 1 : 0) != 0, (Object)"wrong number of new children");
        return new TableFunctionNode(this.getPlanNodeId(), this.name, this.tableFunctionHandle, this.properOutputs, newSources, this.tableArgumentProperties);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_FUNCTION_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)byteBuffer);
        byte[] bytes = this.tableFunctionHandle.serialize();
        ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((ByteBuffer)ByteBuffer.wrap(bytes), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.properOutputs.size(), (ByteBuffer)byteBuffer);
        this.properOutputs.forEach(symbol -> Symbol.serialize(symbol, byteBuffer));
        ReadWriteIOUtils.write((int)this.tableArgumentProperties.size(), (ByteBuffer)byteBuffer);
        this.tableArgumentProperties.forEach(properties -> {
            ReadWriteIOUtils.write((String)properties.getArgumentName(), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((Boolean)properties.isRowSemantics(), (ByteBuffer)byteBuffer);
            properties.getPassThroughSpecification().serialize(byteBuffer);
            ReadWriteIOUtils.write((int)properties.getRequiredColumns().size(), (ByteBuffer)byteBuffer);
            properties.getRequiredColumns().forEach(symbol -> Symbol.serialize(symbol, byteBuffer));
            ReadWriteIOUtils.write((Boolean)properties.getDataOrganizationSpecification().isPresent(), (ByteBuffer)byteBuffer);
            properties.getDataOrganizationSpecification().ifPresent(specification -> specification.serialize(byteBuffer));
            ReadWriteIOUtils.write((Boolean)properties.isRequireRecordSnapshot(), (ByteBuffer)byteBuffer);
        });
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_FUNCTION_NODE.serialize(stream);
        ReadWriteIOUtils.write((String)this.name, (OutputStream)stream);
        byte[] bytes = this.tableFunctionHandle.serialize();
        ReadWriteIOUtils.write((int)bytes.length, (OutputStream)stream);
        ReadWriteIOUtils.write((ByteBuffer)ByteBuffer.wrap(bytes), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.properOutputs.size(), (OutputStream)stream);
        for (Symbol symbol : this.properOutputs) {
            Symbol.serialize(symbol, stream);
        }
        ReadWriteIOUtils.write((int)this.tableArgumentProperties.size(), (OutputStream)stream);
        for (TableArgumentProperties properties : this.tableArgumentProperties) {
            ReadWriteIOUtils.write((String)properties.getArgumentName(), (OutputStream)stream);
            ReadWriteIOUtils.write((Boolean)properties.isRowSemantics(), (OutputStream)stream);
            properties.getPassThroughSpecification().serialize(stream);
            ReadWriteIOUtils.write((int)properties.getRequiredColumns().size(), (OutputStream)stream);
            for (Symbol symbol : properties.getRequiredColumns()) {
                Symbol.serialize(symbol, stream);
            }
            ReadWriteIOUtils.write((Boolean)properties.getDataOrganizationSpecification().isPresent(), (OutputStream)stream);
            if (properties.getDataOrganizationSpecification().isPresent()) {
                properties.getDataOrganizationSpecification().get().serialize(stream);
            }
            ReadWriteIOUtils.write((Boolean)properties.isRequireRecordSnapshot(), (OutputStream)stream);
        }
    }

    public static TableFunctionNode deserialize(ByteBuffer byteBuffer) {
        String name = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        byte[] bytes = ReadWriteIOUtils.readBytes((ByteBuffer)byteBuffer, (int)size);
        TableFunctionHandle tableFunctionHandle = new TableMetadataImpl().getTableFunction(name).createTableFunctionHandle();
        tableFunctionHandle.deserialize(bytes);
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ImmutableList.Builder properOutputs = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            properOutputs.add((Object)Symbol.deserialize(byteBuffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ImmutableList.Builder tableArgumentProperties = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            String argumentName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            boolean rowSemantics = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
            PassThroughSpecification passThroughSpecification = PassThroughSpecification.deserialize(byteBuffer);
            int requiredColumnsSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            ImmutableList.Builder requiredColumns = ImmutableList.builder();
            for (int j = 0; j < requiredColumnsSize; ++j) {
                requiredColumns.add((Object)Symbol.deserialize(byteBuffer));
            }
            Optional<DataOrganizationSpecification> dataOrganizationSpecification = Optional.empty();
            if (ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer)) {
                dataOrganizationSpecification = Optional.of(DataOrganizationSpecification.deserialize(byteBuffer));
            }
            boolean requireRecordSnapshot = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
            tableArgumentProperties.add((Object)new TableArgumentProperties(argumentName, rowSemantics, passThroughSpecification, (List<Symbol>)requiredColumns.build(), dataOrganizationSpecification, requireRecordSnapshot));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new TableFunctionNode(planNodeId, name, tableFunctionHandle, (List<Symbol>)properOutputs.build(), (List<TableArgumentProperties>)tableArgumentProperties.build());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableFunction(this, context);
    }

    public static class TableArgumentProperties {
        private final String argumentName;
        private final boolean rowSemantics;
        private final PassThroughSpecification passThroughSpecification;
        private final List<Symbol> requiredColumns;
        private final Optional<DataOrganizationSpecification> dataOrganizationSpecification;
        private final boolean requireRecordSnapshot;

        public TableArgumentProperties(String argumentName, boolean rowSemantics, PassThroughSpecification passThroughSpecification, List<Symbol> requiredColumns, Optional<DataOrganizationSpecification> dataOrganizationSpecification, boolean requireRecordSnapshot) {
            this.argumentName = Objects.requireNonNull(argumentName, "argumentName is null");
            this.rowSemantics = rowSemantics;
            this.passThroughSpecification = Objects.requireNonNull(passThroughSpecification, "passThroughSpecification is null");
            this.requiredColumns = ImmutableList.copyOf(requiredColumns);
            this.dataOrganizationSpecification = Objects.requireNonNull(dataOrganizationSpecification, "specification is null");
            this.requireRecordSnapshot = requireRecordSnapshot;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public List<Symbol> getRequiredColumns() {
            return this.requiredColumns;
        }

        public boolean isRowSemantics() {
            return this.rowSemantics;
        }

        public PassThroughSpecification getPassThroughSpecification() {
            return this.passThroughSpecification;
        }

        public Optional<DataOrganizationSpecification> getDataOrganizationSpecification() {
            return this.dataOrganizationSpecification;
        }

        public boolean isRequireRecordSnapshot() {
            return this.requireRecordSnapshot;
        }
    }

    public static class PassThroughSpecification {
        private final boolean declaredAsPassThrough;
        private final List<PassThroughColumn> columns;

        public PassThroughSpecification(boolean declaredAsPassThrough, List<PassThroughColumn> columns) {
            if (!declaredAsPassThrough && !columns.stream().allMatch(PassThroughColumn::isPartitioningColumn)) {
                throw new IllegalArgumentException("non-partitioning pass-through column for non-pass-through source of a table function");
            }
            this.columns = ImmutableList.copyOf(columns);
            this.declaredAsPassThrough = declaredAsPassThrough;
        }

        public boolean isDeclaredAsPassThrough() {
            return this.declaredAsPassThrough;
        }

        public List<PassThroughColumn> getColumns() {
            return this.columns;
        }

        public void serialize(DataOutputStream stream) throws IOException {
            ReadWriteIOUtils.write((Boolean)this.declaredAsPassThrough, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.columns.size(), (OutputStream)stream);
            for (PassThroughColumn column : this.columns) {
                ReadWriteIOUtils.write((Boolean)column.isPartitioningColumn, (OutputStream)stream);
                Symbol.serialize(column.getSymbol(), stream);
            }
        }

        public void serialize(ByteBuffer buffer) {
            ReadWriteIOUtils.write((Boolean)this.declaredAsPassThrough, (ByteBuffer)buffer);
            ReadWriteIOUtils.write((int)this.columns.size(), (ByteBuffer)buffer);
            for (PassThroughColumn column : this.columns) {
                ReadWriteIOUtils.write((Boolean)column.isPartitioningColumn, (ByteBuffer)buffer);
                Symbol.serialize(column.getSymbol(), buffer);
            }
        }

        public static PassThroughSpecification deserialize(ByteBuffer byteBuffer) {
            boolean declaredAsPassThrough = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
            int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            ImmutableList.Builder columns = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                boolean isPartitioningColumn = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
                Symbol symbol = Symbol.deserialize(byteBuffer);
                columns.add((Object)new PassThroughColumn(symbol, isPartitioningColumn));
            }
            return new PassThroughSpecification(declaredAsPassThrough, (List<PassThroughColumn>)columns.build());
        }
    }

    public static class PassThroughColumn {
        private final Symbol symbol;
        private final boolean isPartitioningColumn;

        public PassThroughColumn(Symbol symbol, boolean isPartitioningColumn) {
            this.symbol = Objects.requireNonNull(symbol, "symbol is null");
            this.isPartitioningColumn = isPartitioningColumn;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public boolean isPartitioningColumn() {
            return this.isPartitioningColumn;
        }
    }
}

