/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import org.apache.tsfile.encoding.encoder.RLBE;

public class DoubleRLBE
extends RLBE {
    private final double[] diffValue;
    private final long[] lengRLE;
    private double previousValue;

    public DoubleRLBE() {
        this.diffValue = new double[this.blockSize + 1];
        this.lengRLE = new long[this.blockSize + 1];
        this.reset();
    }

    protected void reset() {
        this.writeIndex = -1;
        this.LengthCode = new int[this.blockSize + 1];
        for (int i = 0; i < this.blockSize; ++i) {
            this.diffValue[i] = 0.0;
            this.LengthCode[i] = 0;
            this.byteBuffer = 0;
            this.numberLeftInBuffer = 0;
            this.lengRLE[i] = 0L;
        }
    }

    private int calBinarylength(long val) {
        int i;
        if (val == 0L) {
            return 1;
        }
        for (i = 64; (1L << i - 1 & val) == 0L && i > 0; --i) {
        }
        return i;
    }

    private int calBinarylength(double v) {
        int i;
        long val = Double.doubleToRawLongBits(v);
        if (val == 0L) {
            return 1;
        }
        for (i = 64; (1L << i - 1 & val) == 0L && i > 0; --i) {
        }
        return i;
    }

    public void encodeValue(double value, ByteArrayOutputStream out) {
        if (this.writeIndex == -1) {
            this.diffValue[++this.writeIndex] = value;
            this.LengthCode[this.writeIndex] = this.calBinarylength(value);
            this.previousValue = value;
            return;
        }
        this.diffValue[++this.writeIndex] = value - this.previousValue;
        this.LengthCode[this.writeIndex] = this.calBinarylength(this.diffValue[this.writeIndex]);
        this.previousValue = value;
        if (this.writeIndex == this.blockSize - 1) {
            this.flush(out);
        }
    }

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        this.encodeValue(value, out);
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        this.flushBlock(out);
    }

    protected long calcFibonacci(long val) {
        long[] fib = new long[this.blockSize * 2 + 1];
        fib[0] = 1L;
        fib[1] = 1L;
        int i = 2;
        while (fib[i - 1] <= val) {
            fib[i] = fib[i - 1] + fib[i - 2];
            ++i;
        }
        --i;
        long valfib = 0L;
        while (val > 0L) {
            while (fib[i] > val && i >= 1) {
                --i;
            }
            valfib |= (long)(1 << i - 1);
            val -= fib[i];
        }
        return valfib;
    }

    private void rleonlengthcode() {
        int i = 0;
        while (i <= this.writeIndex) {
            int j = i;
            int temprlecal = 0;
            while (this.LengthCode[j] == this.LengthCode[i] && j <= this.writeIndex) {
                ++j;
                ++temprlecal;
            }
            this.lengRLE[i] = temprlecal;
            i = j;
        }
    }

    protected void flushBlock(ByteArrayOutputStream out) {
        if (this.writeIndex == -1) {
            return;
        }
        this.writewriteIndex(out);
        this.rleonlengthcode();
        for (int i = 0; i <= this.writeIndex; ++i) {
            if (this.lengRLE[i] <= 0L) continue;
            this.flushSegment(i, out);
        }
        this.clearBuffer(out);
        this.reset();
    }

    private void flushSegment(int i, ByteArrayOutputStream out) {
        int j;
        for (int j2 = 6; j2 >= 0; --j2) {
            if ((this.LengthCode[i] & 1 << j2) > 0) {
                this.writeBit(true, out);
                continue;
            }
            this.writeBit(false, out);
        }
        long fib = this.calcFibonacci(this.lengRLE[i]);
        int fiblen = this.calBinarylength(fib);
        for (j = 0; j < fiblen; ++j) {
            if ((fib & (long)(1 << j)) > 0L) {
                this.writeBit(true, out);
                continue;
            }
            this.writeBit(false, out);
        }
        this.writeBit(true, out);
        j = i;
        do {
            int tempDifflen = this.calBinarylength(this.diffValue[j]);
            long tempDiff = Double.doubleToRawLongBits(this.diffValue[j]);
            for (int k = tempDifflen - 1; k >= 0; --k) {
                if ((tempDiff & 1L << k) > 0L) {
                    this.writeBit(true, out);
                    continue;
                }
                this.writeBit(false, out);
            }
        } while (this.lengRLE[++j] == 0L && j <= this.writeIndex);
    }

    @Override
    public int getOneItemMaxSize() {
        return 32;
    }

    @Override
    public long getMaxByteSize() {
        return 20L * (long)this.blockSize * 2L;
    }

    protected void writeBit(boolean b, ByteArrayOutputStream out) {
        this.byteBuffer = (byte)(this.byteBuffer << 1);
        if (b) {
            this.byteBuffer = (byte)(this.byteBuffer | 1);
        }
        ++this.numberLeftInBuffer;
        if (this.numberLeftInBuffer == 8) {
            this.clearBuffer(out);
        }
    }

    protected void clearBuffer(ByteArrayOutputStream out) {
        if (this.numberLeftInBuffer == 0) {
            return;
        }
        if (this.numberLeftInBuffer > 0) {
            this.byteBuffer = (byte)(this.byteBuffer << 8 - this.numberLeftInBuffer);
        }
        out.write(this.byteBuffer);
        this.numberLeftInBuffer = 0;
        this.byteBuffer = 0;
    }

    private void writewriteIndex(ByteArrayOutputStream out) {
        for (int i = 31; i >= 0; --i) {
            if ((this.writeIndex + 1 & 1 << i) > 0) {
                this.writeBit(true, out);
                continue;
            }
            this.writeBit(false, out);
        }
    }
}

