/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.storageengine.load.config.LoadTsFileConfigurator;

public final class ActiveLoadPathHelper {
    private static final String SEGMENT_SEPARATOR = "-";
    private static final List<String> KEY_ORDER = Collections.unmodifiableList(Arrays.asList("database-level", "convert-on-type-mismatch", "tablet-conversion-threshold", "verify", "pipe-generated"));

    private ActiveLoadPathHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, String> buildAttributes(Integer databaseLevel, Boolean convertOnTypeMismatch, Boolean verify, Long tabletConversionThresholdBytes, Boolean pipeGenerated) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (Objects.nonNull(databaseLevel)) {
            attributes.put("database-level", databaseLevel.toString());
        }
        if (Objects.nonNull(convertOnTypeMismatch)) {
            attributes.put("convert-on-type-mismatch", Boolean.toString(convertOnTypeMismatch));
        }
        if (Objects.nonNull(tabletConversionThresholdBytes)) {
            attributes.put("tablet-conversion-threshold", tabletConversionThresholdBytes.toString());
        }
        if (Objects.nonNull(verify)) {
            attributes.put("verify", Boolean.toString(verify));
        }
        if (Objects.nonNull(pipeGenerated) && pipeGenerated.booleanValue()) {
            attributes.put("pipe-generated", Boolean.TRUE.toString());
        }
        return attributes;
    }

    public static File resolveTargetDir(File baseDir, Map<String, String> attributes) {
        File current = baseDir;
        for (String key : KEY_ORDER) {
            String value = attributes.get(key);
            if (value == null) continue;
            current = new File(current, ActiveLoadPathHelper.formatSegment(key, value));
        }
        return current;
    }

    public static Map<String, String> parseAttributes(File file, File pendingDir) {
        if (file == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        block0: for (File current = file.getParentFile(); current != null; current = current.getParentFile()) {
            String dirName = current.getName();
            if (pendingDir != null && current.equals(pendingDir)) break;
            for (String key : KEY_ORDER) {
                String prefix = key + SEGMENT_SEPARATOR;
                if (!dirName.startsWith(prefix)) continue;
                ActiveLoadPathHelper.extractAndValidateAttributeValue(key, dirName, prefix.length()).ifPresent(value -> attributes.putIfAbsent(key, (String)value));
                continue block0;
            }
        }
        return attributes;
    }

    public static File findPendingDirectory(File file) {
        if (file == null) {
            return null;
        }
        String[] dirs = IoTDBDescriptor.getInstance().getConfig().getLoadActiveListeningDirs();
        for (File current = file; current != null; current = current.getParentFile()) {
            for (String dir : dirs) {
                if (!current.isDirectory() || !current.getAbsolutePath().equals(dir)) continue;
                return current;
            }
        }
        return null;
    }

    public static void applyAttributesToStatement(Map<String, String> attributes, LoadTsFileStatement statement, boolean defaultVerify) {
        Optional.ofNullable(attributes.get("database-level")).ifPresent(level -> {
            try {
                statement.setDatabaseLevel(Integer.parseInt(level));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        Optional.ofNullable(attributes.get("convert-on-type-mismatch")).ifPresent(value -> statement.setConvertOnTypeMismatch(Boolean.parseBoolean(value)));
        Optional.ofNullable(attributes.get("tablet-conversion-threshold")).ifPresent(threshold -> {
            try {
                statement.setTabletConversionThresholdBytes(Long.parseLong(threshold));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        if (attributes.containsKey("verify")) {
            statement.setVerifySchema(Boolean.parseBoolean(attributes.get("verify")));
        } else {
            statement.setVerifySchema(defaultVerify);
        }
        if (attributes.containsKey("pipe-generated") && Boolean.parseBoolean(attributes.get("pipe-generated"))) {
            statement.markIsGeneratedByPipe();
        }
    }

    private static String formatSegment(String key, String value) {
        return key + SEGMENT_SEPARATOR + ActiveLoadPathHelper.encodeValue(value);
    }

    private static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private static Optional<String> extractAndValidateAttributeValue(String key, String dirName, int prefixLength) {
        if (dirName.length() <= prefixLength) {
            return Optional.empty();
        }
        String encodedValue = dirName.substring(prefixLength);
        String decodedValue = ActiveLoadPathHelper.decodeValue(encodedValue);
        try {
            ActiveLoadPathHelper.validateAttributeValue(key, decodedValue);
            return Optional.of(decodedValue);
        }
        catch (SemanticException e) {
            return Optional.empty();
        }
    }

    private static void validateAttributeValue(String key, String value) {
        switch (key) {
            case "database-level": {
                LoadTsFileConfigurator.validateDatabaseLevelParam(value);
                break;
            }
            case "convert-on-type-mismatch": {
                LoadTsFileConfigurator.validateConvertOnTypeMismatchParam(value);
                break;
            }
            case "tablet-conversion-threshold": {
                ActiveLoadPathHelper.validateTabletConversionThreshold(value);
                break;
            }
            case "verify": {
                LoadTsFileConfigurator.validateVerifyParam(value);
                break;
            }
            default: {
                LoadTsFileConfigurator.validateParameters(key, value);
            }
        }
    }

    private static void validateTabletConversionThreshold(String value) {
        try {
            long threshold = Long.parseLong(value);
            if (threshold < 0L) {
                throw new SemanticException("Tablet conversion threshold must be a non-negative long value.");
            }
        }
        catch (NumberFormatException e) {
            throw new SemanticException(String.format("Tablet conversion threshold '%s' is not a valid long value.", value));
        }
    }

    private static String decodeValue(String value) {
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }
}

