/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.logging.ClientLogger;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ResponseConstructorsCache {
    private static final String THREE_PARAM_ERROR = "Failed to deserialize 3-parameter response.";
    private static final String FOUR_PARAM_ERROR = "Failed to deserialize 4-parameter response.";
    private static final String FIVE_PARAM_ERROR = "Failed to deserialize 5-parameter response.";
    private static final String INVALID_PARAM_COUNT = "Response constructor with expected parameters not found.";
    private static final Map<Class<?>, ReflectiveInvoker> CACHE = new ConcurrentHashMap();
    private static final ClientLogger LOGGER = new ClientLogger(ResponseConstructorsCache.class);

    public ReflectiveInvoker get(Class<? extends Response<?>> responseClass) {
        return CACHE.computeIfAbsent(responseClass, ResponseConstructorsCache::locateResponseConstructor);
    }

    private static ReflectiveInvoker locateResponseConstructor(Class<?> responseClass) {
        Constructor<?>[] constructors = responseClass.getDeclaredConstructors();
        Arrays.sort(constructors, Comparator.comparing(Constructor::getParameterCount, (a, b) -> b - a));
        for (Constructor<?> constructor : constructors) {
            int paramCount = constructor.getParameterCount();
            if (paramCount < 3 || paramCount > 5) continue;
            try {
                return ReflectionUtils.getConstructorInvoker(responseClass, constructor);
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw LOGGER.logExceptionAsError((RuntimeException)ex);
                }
                throw LOGGER.logExceptionAsError(new RuntimeException(ex));
            }
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Cannot find suitable constructor for class " + responseClass));
    }

    public Response<?> invoke(ReflectiveInvoker reflectiveInvoker, HttpResponseDecoder.HttpDecodedResponse decodedResponse, Object bodyAsObject) {
        HttpResponse httpResponse = decodedResponse.getSourceResponse();
        HttpRequest httpRequest = httpResponse.getRequest();
        int responseStatusCode = httpResponse.getStatusCode();
        HttpHeaders responseHeaders = httpResponse.getHeaders();
        int paramCount = reflectiveInvoker.getParameterCount();
        switch (paramCount) {
            case 3: {
                return ResponseConstructorsCache.constructResponse(reflectiveInvoker, THREE_PARAM_ERROR, httpRequest, responseStatusCode, responseHeaders);
            }
            case 4: {
                return ResponseConstructorsCache.constructResponse(reflectiveInvoker, FOUR_PARAM_ERROR, httpRequest, responseStatusCode, responseHeaders, bodyAsObject);
            }
            case 5: {
                return ResponseConstructorsCache.constructResponse(reflectiveInvoker, FIVE_PARAM_ERROR, httpRequest, responseStatusCode, responseHeaders, bodyAsObject, decodedResponse.getDecodedHeaders());
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException(INVALID_PARAM_COUNT));
    }

    private static Response<?> constructResponse(ReflectiveInvoker reflectiveInvoker, String exceptionMessage, Object ... params) {
        try {
            return (Response)reflectiveInvoker.invokeStatic(params);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)exception);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException(exceptionMessage, exception));
        }
    }
}

