/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.api;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.api.SpiAccess;
import jakarta.enterprise.util.TypeLiteral;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

@Experimental(value="second attempt at providing programmatic API")
public interface Guard {
    public static Builder create() {
        return SpiAccess.get().newGuardBuilder();
    }

    public <T> T call(Callable<T> var1, Class<T> var2) throws Exception;

    public <T> T call(Callable<T> var1, TypeLiteral<T> var2) throws Exception;

    public <T> T get(Supplier<T> var1, Class<T> var2);

    public <T> T get(Supplier<T> var1, TypeLiteral<T> var2);

    default public <T> Callable<T> adaptCallable(Callable<T> action, Class<T> type) {
        return () -> this.call(action, type);
    }

    default public <T> Callable<T> adaptCallable(Callable<T> action, TypeLiteral<T> type) {
        return () -> this.call(action, type);
    }

    default public <T> Supplier<T> adaptSupplier(Supplier<T> action, Class<T> type) {
        return () -> this.get(action, type);
    }

    default public <T> Supplier<T> adaptSupplier(Supplier<T> action, TypeLiteral<T> type) {
        return () -> this.get(action, type);
    }

    public static interface Builder {
        public Builder withDescription(String var1);

        public BulkheadBuilder withBulkhead();

        public CircuitBreakerBuilder withCircuitBreaker();

        public RateLimitBuilder withRateLimit();

        public RetryBuilder withRetry();

        public TimeoutBuilder withTimeout();

        public Builder withThreadOffload(boolean var1);

        public Builder withThreadOffloadExecutor(Executor var1);

        public Guard build();

        default public Builder with(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        public static interface TimeoutBuilder {
            public TimeoutBuilder duration(long var1, ChronoUnit var3);

            public TimeoutBuilder onTimeout(Runnable var1);

            public TimeoutBuilder onFinished(Runnable var1);

            public Builder done();

            default public TimeoutBuilder with(Consumer<TimeoutBuilder> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface RetryBuilder {
            public RetryBuilder maxRetries(int var1);

            public RetryBuilder delay(long var1, ChronoUnit var3);

            public RetryBuilder maxDuration(long var1, ChronoUnit var3);

            public RetryBuilder jitter(long var1, ChronoUnit var3);

            public RetryBuilder retryOn(Collection<Class<? extends Throwable>> var1);

            public RetryBuilder retryOn(Class<? extends Throwable> var1);

            public RetryBuilder abortOn(Collection<Class<? extends Throwable>> var1);

            public RetryBuilder abortOn(Class<? extends Throwable> var1);

            public RetryBuilder whenResult(Predicate<Object> var1);

            public RetryBuilder whenException(Predicate<Throwable> var1);

            public RetryBuilder beforeRetry(Runnable var1);

            public RetryBuilder beforeRetry(Consumer<Throwable> var1);

            public ExponentialBackoffBuilder withExponentialBackoff();

            public FibonacciBackoffBuilder withFibonacciBackoff();

            public CustomBackoffBuilder withCustomBackoff();

            public RetryBuilder onRetry(Runnable var1);

            public RetryBuilder onSuccess(Runnable var1);

            public RetryBuilder onFailure(Runnable var1);

            public Builder done();

            default public RetryBuilder with(Consumer<RetryBuilder> consumer) {
                consumer.accept(this);
                return this;
            }

            public static interface CustomBackoffBuilder {
                public CustomBackoffBuilder strategy(Supplier<CustomBackoffStrategy> var1);

                public RetryBuilder done();

                default public CustomBackoffBuilder with(Consumer<CustomBackoffBuilder> consumer) {
                    consumer.accept(this);
                    return this;
                }
            }

            public static interface FibonacciBackoffBuilder {
                public FibonacciBackoffBuilder maxDelay(long var1, ChronoUnit var3);

                public RetryBuilder done();

                default public FibonacciBackoffBuilder with(Consumer<FibonacciBackoffBuilder> consumer) {
                    consumer.accept(this);
                    return this;
                }
            }

            public static interface ExponentialBackoffBuilder {
                public ExponentialBackoffBuilder factor(int var1);

                public ExponentialBackoffBuilder maxDelay(long var1, ChronoUnit var3);

                public RetryBuilder done();

                default public ExponentialBackoffBuilder with(Consumer<ExponentialBackoffBuilder> consumer) {
                    consumer.accept(this);
                    return this;
                }
            }
        }

        public static interface RateLimitBuilder {
            public RateLimitBuilder limit(int var1);

            public RateLimitBuilder window(long var1, ChronoUnit var3);

            public RateLimitBuilder minSpacing(long var1, ChronoUnit var3);

            public RateLimitBuilder type(RateLimitType var1);

            public RateLimitBuilder onPermitted(Runnable var1);

            public RateLimitBuilder onRejected(Runnable var1);

            public Builder done();

            default public RateLimitBuilder with(Consumer<RateLimitBuilder> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface CircuitBreakerBuilder {
            public CircuitBreakerBuilder failOn(Collection<Class<? extends Throwable>> var1);

            public CircuitBreakerBuilder failOn(Class<? extends Throwable> var1);

            public CircuitBreakerBuilder skipOn(Collection<Class<? extends Throwable>> var1);

            public CircuitBreakerBuilder skipOn(Class<? extends Throwable> var1);

            public CircuitBreakerBuilder when(Predicate<Throwable> var1);

            public CircuitBreakerBuilder delay(long var1, ChronoUnit var3);

            public CircuitBreakerBuilder requestVolumeThreshold(int var1);

            public CircuitBreakerBuilder failureRatio(double var1);

            public CircuitBreakerBuilder successThreshold(int var1);

            public CircuitBreakerBuilder name(String var1);

            public CircuitBreakerBuilder onStateChange(Consumer<CircuitBreakerState> var1);

            public CircuitBreakerBuilder onSuccess(Runnable var1);

            public CircuitBreakerBuilder onFailure(Runnable var1);

            public CircuitBreakerBuilder onPrevented(Runnable var1);

            public Builder done();

            default public CircuitBreakerBuilder with(Consumer<CircuitBreakerBuilder> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface BulkheadBuilder {
            public BulkheadBuilder limit(int var1);

            public BulkheadBuilder queueSize(int var1);

            public BulkheadBuilder enableSynchronousQueueing();

            public BulkheadBuilder onAccepted(Runnable var1);

            public BulkheadBuilder onRejected(Runnable var1);

            public BulkheadBuilder onFinished(Runnable var1);

            public Builder done();

            default public BulkheadBuilder with(Consumer<BulkheadBuilder> consumer) {
                consumer.accept(this);
                return this;
            }
        }
    }
}

