/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.admintool;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.apache.polaris.admintool.BaseCommand;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import picocli.CommandLine;

@CommandLine.Command(name="purge", mixinStandardHelpOptions=true, description={"Purge realms and all associated entities."})
public class PurgeCommand
extends BaseCommand {
    @CommandLine.Option(names={"-r", "--realm"}, paramLabel="<realm>", required=true, description={"The name of a realm to purge."})
    List<String> realms;

    @Override
    public Integer call() {
        try {
            Map result = this.metaStoreManagerFactory.purgeRealms(this.realms);
            List<String> failed = result.entrySet().stream().filter(e -> !((BaseResult)e.getValue()).isSuccess()).map(Map.Entry::getKey).toList();
            if (failed.isEmpty()) {
                this.spec.commandLine().getOut().println("Purge completed successfully.");
                return 0;
            }
            PrintWriter out = this.spec.commandLine().getOut();
            failed.forEach(r -> out.printf("Realm %s is not bootstrapped, could not load root principal. Please run Bootstrap command.%n", r));
            this.spec.commandLine().getErr().printf("Purge encountered errors during operation.", new Object[0]);
            return 4;
        }
        catch (Exception e2) {
            this.spec.commandLine().getErr().println("Purge encountered errors during operation.");
            return 4;
        }
    }
}

