/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.policy.content.maintenance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.Set;
import org.apache.polaris.core.policy.content.PolicyContentUtil;
import org.apache.polaris.core.policy.content.maintenance.BaseMaintenancePolicyContent;
import org.apache.polaris.core.policy.validator.InvalidPolicyException;

public class SnapshotExpiryPolicyContent
extends BaseMaintenancePolicyContent {
    private static final String DEFAULT_POLICY_SCHEMA_VERSION = "2025-02-03";
    private static final Set<String> POLICY_SCHEMA_VERSIONS = Set.of("2025-02-03");

    @JsonCreator
    public SnapshotExpiryPolicyContent(@JsonProperty(value="enable", required=true) boolean enable) {
        super(enable);
    }

    public static SnapshotExpiryPolicyContent fromString(String content) {
        SnapshotExpiryPolicyContent policy;
        if (Strings.isNullOrEmpty((String)content)) {
            throw new InvalidPolicyException("Policy is empty");
        }
        try {
            policy = (SnapshotExpiryPolicyContent)PolicyContentUtil.MAPPER.readValue(content, SnapshotExpiryPolicyContent.class);
        }
        catch (Exception e) {
            throw new InvalidPolicyException(e);
        }
        SnapshotExpiryPolicyContent.validateVersion(content, policy, DEFAULT_POLICY_SCHEMA_VERSION, POLICY_SCHEMA_VERSIONS);
        return policy;
    }
}

