/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.polaris.service.auth.PolarisCredential;
import org.immutables.value.Generated;

@Generated(from="PolarisCredential", generator="Immutables")
public final class ImmutablePolarisCredential
implements PolarisCredential {
    @Nullable
    private final Long principalId;
    @Nullable
    private final String principalName;
    private final ImmutableSet<String> principalRoles;
    private transient int hashCode;

    private ImmutablePolarisCredential(@Nullable Long principalId, @Nullable String principalName, ImmutableSet<String> principalRoles) {
        this.principalId = principalId;
        this.principalName = principalName;
        this.principalRoles = principalRoles;
    }

    @Override
    @Nullable
    public Long getPrincipalId() {
        return this.principalId;
    }

    @Override
    @Nullable
    public String getPrincipalName() {
        return this.principalName;
    }

    public ImmutableSet<String> getPrincipalRoles() {
        return this.principalRoles;
    }

    public final ImmutablePolarisCredential withPrincipalId(@Nullable Long value) {
        if (Objects.equals(this.principalId, value)) {
            return this;
        }
        return new ImmutablePolarisCredential(value, this.principalName, this.principalRoles);
    }

    public final ImmutablePolarisCredential withPrincipalName(@Nullable String value) {
        if (Objects.equals(this.principalName, value)) {
            return this;
        }
        return new ImmutablePolarisCredential(this.principalId, value, this.principalRoles);
    }

    public final ImmutablePolarisCredential withPrincipalRoles(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutablePolarisCredential(this.principalId, this.principalName, (ImmutableSet<String>)newValue);
    }

    public final ImmutablePolarisCredential withPrincipalRoles(Iterable<String> elements) {
        if (this.principalRoles == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutablePolarisCredential(this.principalId, this.principalName, (ImmutableSet<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePolarisCredential && this.equalsByValue((ImmutablePolarisCredential)another);
    }

    private boolean equalsByValue(ImmutablePolarisCredential another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.principalId, another.principalId) && Objects.equals(this.principalName, another.principalName) && this.principalRoles.equals(another.principalRoles);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.principalId);
        h += (h << 5) + Objects.hashCode(this.principalName);
        h += (h << 5) + this.principalRoles.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PolarisCredential").omitNullValues().add("principalId", (Object)this.principalId).add("principalName", (Object)this.principalName).add("principalRoles", this.principalRoles).toString();
    }

    public static ImmutablePolarisCredential copyOf(PolarisCredential instance) {
        if (instance instanceof ImmutablePolarisCredential) {
            return (ImmutablePolarisCredential)instance;
        }
        return ImmutablePolarisCredential.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutablePolarisCredential.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PolarisCredential", generator="Immutables")
    public static final class Builder {
        private Long principalId;
        private String principalName;
        private ImmutableSet.Builder<String> principalRoles = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PolarisCredential instance) {
            String principalNameValue;
            Objects.requireNonNull(instance, "instance");
            Long principalIdValue = instance.getPrincipalId();
            if (principalIdValue != null) {
                this.principalId(principalIdValue);
            }
            if ((principalNameValue = instance.getPrincipalName()) != null) {
                this.principalName(principalNameValue);
            }
            this.addAllPrincipalRoles(instance.getPrincipalRoles());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder principalId(@Nullable Long principalId) {
            this.principalId = principalId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder principalName(@Nullable String principalName) {
            this.principalName = principalName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPrincipalRole(String element) {
            this.principalRoles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPrincipalRoles(String ... elements) {
            this.principalRoles.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder principalRoles(Iterable<String> elements) {
            this.principalRoles = ImmutableSet.builder();
            return this.addAllPrincipalRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPrincipalRoles(Iterable<String> elements) {
            this.principalRoles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.principalId = null;
            this.principalName = null;
            this.principalRoles = ImmutableSet.builder();
            return this;
        }

        public ImmutablePolarisCredential build() {
            return new ImmutablePolarisCredential(this.principalId, this.principalName, (ImmutableSet<String>)this.principalRoles.build());
        }
    }
}

