/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.NamespacePrivilege;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NamespaceGrant
extends GrantResource {
    @NotNull
    private final List<String> namespace;
    @NotNull
    @Valid
    private final NamespacePrivilege privilege;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="namespace", required=true)
    public List<String> getNamespace() {
        return this.namespace;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="privilege", required=true)
    public NamespacePrivilege getPrivilege() {
        return this.privilege;
    }

    @JsonCreator
    public NamespaceGrant(@JsonProperty(value="namespace", required=true) List<String> namespace, @JsonProperty(value="privilege", required=true) NamespacePrivilege privilege, @JsonProperty(value="type", required=true) GrantResource.TypeEnum type) {
        super(type);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
        this.privilege = privilege;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(List<String> namespace, NamespacePrivilege privilege, GrantResource.TypeEnum type) {
        return new Builder(namespace, privilege, type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceGrant namespaceGrant = (NamespaceGrant)o;
        return super.equals(o) && Objects.equals(this.namespace, namespaceGrant.namespace) && Objects.equals((Object)this.privilege, (Object)namespaceGrant.privilege);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.namespace, super.hashCode(), this.privilege});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NamespaceGrant {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    privilege: ").append(this.toIndentedString((Object)this.privilege)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private List<String> namespace;
        private NamespacePrivilege privilege;
        private GrantResource.TypeEnum type;

        private Builder() {
        }

        private Builder(List<String> namespace, NamespacePrivilege privilege, GrantResource.TypeEnum type) {
            this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
            this.privilege = privilege;
            this.type = type;
        }

        public Builder setNamespace(List<String> namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setPrivilege(NamespacePrivilege privilege) {
            this.privilege = privilege;
            return this;
        }

        public Builder setType(GrantResource.TypeEnum type) {
            this.type = type;
            return this;
        }

        public NamespaceGrant build() {
            NamespaceGrant inst = new NamespaceGrant(this.namespace, this.privilege, this.type);
            return inst;
        }
    }
}

