/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.util.SerializableSupplier;

public class SerializationUtil {
    private SerializationUtil() {
    }

    public static byte[] serializeToBytes(Object obj) {
        return SerializationUtil.serializeToBytes(obj, conf -> new SerializableConfiguration((Configuration)conf)::get);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serializeToBytes(Object obj, Function<Configuration, SerializableSupplier<Configuration>> confSerializer) {
        if (obj instanceof HadoopConfigurable) {
            ((HadoopConfigurable)obj).serializeConfWith(confSerializer);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to serialize object", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserializeFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                object = ois.readObject();
            }
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to deserialize object", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not read object ", e);
        }
    }

    public static String serializeToBase64(Object obj) {
        byte[] bytes = SerializationUtil.serializeToBytes(obj);
        return new String(Base64.getMimeEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    public static <T> T deserializeFromBase64(String base64) {
        if (base64 == null) {
            return null;
        }
        byte[] bytes = Base64.getMimeDecoder().decode(base64.getBytes(StandardCharsets.UTF_8));
        return SerializationUtil.deserializeFromBytes(bytes);
    }
}

