/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.rest.RESTResponse;

public class ListTablesResponse
implements RESTResponse {
    private List<TableIdentifier> identifiers;
    private String nextPageToken;

    public ListTablesResponse() {
    }

    private ListTablesResponse(List<TableIdentifier> identifiers, String nextPageToken) {
        this.identifiers = identifiers;
        this.nextPageToken = nextPageToken;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.identifiers != null ? 1 : 0) != 0, (Object)"Invalid identifier list: null");
    }

    public List<TableIdentifier> identifiers() {
        return this.identifiers != null ? this.identifiers : ImmutableList.of();
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifiers", this.identifiers).add("next-page-token", (Object)this.nextPageToken()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<TableIdentifier> identifiers = ImmutableList.builder();
        private String nextPageToken;

        private Builder() {
        }

        public Builder add(TableIdentifier toAdd) {
            Preconditions.checkNotNull((Object)toAdd, (Object)"Invalid table identifier: null");
            this.identifiers.add((Object)toAdd);
            return this;
        }

        public Builder addAll(Collection<TableIdentifier> toAdd) {
            Preconditions.checkNotNull(toAdd, (Object)"Invalid table identifier list: null");
            Preconditions.checkArgument((!toAdd.contains(null) ? 1 : 0) != 0, (Object)"Invalid table identifier: null");
            this.identifiers.addAll(toAdd);
            return this;
        }

        public Builder nextPageToken(String pageToken) {
            this.nextPageToken = pageToken;
            return this;
        }

        public ListTablesResponse build() {
            return new ListTablesResponse((List<TableIdentifier>)this.identifiers.build(), this.nextPageToken);
        }
    }
}

