/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.policy.ExponentialBackoffOptions;
import com.azure.core.http.policy.FixedDelayOptions;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.policy.RetryPolicyType;
import java.time.Duration;
import java.util.Objects;

public final class RequestRetryOptions {
    private static final ClientLogger LOGGER = new ClientLogger(RequestRetryOptions.class);
    private final int maxTries;
    private final Duration tryTimeout;
    private final Duration retryDelay;
    private final Duration maxRetryDelay;
    private final RetryPolicyType retryPolicyType;
    private final String secondaryHost;

    public RequestRetryOptions() {
        this(RetryPolicyType.EXPONENTIAL, null, (Integer)null, null, null, null);
    }

    public RequestRetryOptions(RetryPolicyType retryPolicyType, Integer maxTries, Integer tryTimeoutInSeconds, Long retryDelayInMs, Long maxRetryDelayInMs, String secondaryHost) {
        this(retryPolicyType, maxTries, tryTimeoutInSeconds == null ? null : Duration.ofSeconds(tryTimeoutInSeconds.intValue()), retryDelayInMs == null ? null : Duration.ofMillis(retryDelayInMs), maxRetryDelayInMs == null ? null : Duration.ofMillis(maxRetryDelayInMs), secondaryHost);
    }

    public RequestRetryOptions(RetryPolicyType retryPolicyType, Integer maxTries, Duration tryTimeout, Duration retryDelay, Duration maxRetryDelay, String secondaryHost) {
        RetryPolicyType retryPolicyType2 = this.retryPolicyType = retryPolicyType == null ? RetryPolicyType.EXPONENTIAL : retryPolicyType;
        if (maxTries != null) {
            StorageImplUtils.assertInBounds("maxRetries", maxTries.intValue(), 1L, Integer.MAX_VALUE);
            this.maxTries = maxTries;
        } else {
            this.maxTries = 4;
        }
        if (tryTimeout != null) {
            StorageImplUtils.assertInBounds("'tryTimeout' in seconds", tryTimeout.getSeconds(), 1L, Integer.MAX_VALUE);
            this.tryTimeout = tryTimeout;
        } else {
            this.tryTimeout = Duration.ofSeconds(Integer.MAX_VALUE);
        }
        if (retryDelay == null && maxRetryDelay != null || retryDelay != null && maxRetryDelay == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both retryDelay and maxRetryDelay must be null or neither can be null"));
        }
        if (retryDelay != null) {
            StorageImplUtils.assertInBounds("'maxRetryDelay' in milliseconds", maxRetryDelay.toMillis(), 1L, Long.MAX_VALUE);
            StorageImplUtils.assertInBounds("'retryDelay' in milliseconds", retryDelay.toMillis(), 1L, maxRetryDelay.toMillis());
            this.maxRetryDelay = maxRetryDelay;
            this.retryDelay = retryDelay;
        } else {
            switch (this.retryPolicyType) {
                case EXPONENTIAL: {
                    this.retryDelay = Duration.ofSeconds(4L);
                    break;
                }
                case FIXED: {
                    this.retryDelay = Duration.ofSeconds(30L);
                    break;
                }
                default: {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid 'RetryPolicyType'."));
                }
            }
            this.maxRetryDelay = Duration.ofSeconds(120L);
        }
        this.secondaryHost = secondaryHost;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    @Deprecated
    public int getTryTimeout() {
        return (int)this.tryTimeout.getSeconds();
    }

    public Duration getTryTimeoutDuration() {
        return this.tryTimeout;
    }

    public String getSecondaryHost() {
        return this.secondaryHost;
    }

    @Deprecated
    public long getRetryDelayInMs() {
        return this.retryDelay.toMillis();
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    @Deprecated
    public long getMaxRetryDelayInMs() {
        return this.maxRetryDelay.toMillis();
    }

    public Duration getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    long calculateDelayInMs(int tryCount) {
        long delay;
        switch (this.retryPolicyType) {
            case EXPONENTIAL: {
                delay = (this.powOfTwo(tryCount - 1) - 1L) * this.retryDelay.toMillis();
                break;
            }
            case FIXED: {
                delay = tryCount > 1 ? this.retryDelay.toMillis() : 0L;
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid retry policy type."));
            }
        }
        return Math.min(delay, this.maxRetryDelay.toMillis());
    }

    private long powOfTwo(int exponent) {
        long result = 1L;
        for (int i = 0; i < exponent; ++i) {
            result *= 2L;
        }
        return result;
    }

    public static RequestRetryOptions fromRetryOptions(RetryOptions retryOptions, Duration tryTimeout, String secondaryHost) {
        Duration retryDelay;
        RetryPolicyType policyType;
        Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        Integer maxTries = null;
        Duration maxRetryDelay = null;
        FixedDelayOptions fixedDelayOptions = retryOptions.getFixedDelayOptions();
        ExponentialBackoffOptions exponentialBackoffOptions = retryOptions.getExponentialBackoffOptions();
        if (fixedDelayOptions != null) {
            policyType = RetryPolicyType.FIXED;
            maxTries = fixedDelayOptions.getMaxRetries() + 1;
            retryDelay = fixedDelayOptions.getDelay();
            maxRetryDelay = fixedDelayOptions.getDelay();
        } else if (exponentialBackoffOptions != null) {
            policyType = RetryPolicyType.EXPONENTIAL;
            if (exponentialBackoffOptions.getMaxRetries() != null) {
                maxTries = exponentialBackoffOptions.getMaxRetries() + 1;
            }
            retryDelay = exponentialBackoffOptions.getBaseDelay();
            maxRetryDelay = exponentialBackoffOptions.getMaxDelay();
        } else {
            throw new IllegalArgumentException("Unsupported RetryPolicyType");
        }
        return new RequestRetryOptions(policyType, maxTries, tryTimeout, retryDelay, maxRetryDelay, secondaryHost);
    }
}

