/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.polaris.core.config.ProductionReadinessCheck;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.extension.persistence.impl.eclipselink.EclipseLinkConfiguration;
import org.apache.polaris.extension.persistence.impl.eclipselink.EclipseLinkPolarisMetaStoreManagerFactory;
import org.apache.polaris.extension.persistence.impl.eclipselink.PolarisEclipseLinkPersistenceUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class EclipseLinkProductionReadinessChecks {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipseLinkProductionReadinessChecks.class);

    @Produces
    public ProductionReadinessCheck checkEclipseLink(MetaStoreManagerFactory metaStoreManagerFactory, EclipseLinkConfiguration eclipseLinkConfiguration) {
        if (!(metaStoreManagerFactory instanceof EclipseLinkPolarisMetaStoreManagerFactory)) {
            return ProductionReadinessCheck.OK;
        }
        try {
            String confFile = eclipseLinkConfiguration.configurationFile().map(Path::toString).orElse(null);
            String persistenceUnitName = confFile != null ? eclipseLinkConfiguration.persistenceUnit() : null;
            PolarisEclipseLinkPersistenceUnit unit = PolarisEclipseLinkPersistenceUnit.locatePersistenceUnit(confFile, persistenceUnitName);
            Map<String, String> properties = unit.loadProperties();
            String jdbcUrl = properties.get("jakarta.persistence.jdbc.url");
            if (jdbcUrl != null && jdbcUrl.startsWith("jdbc:h2")) {
                return ProductionReadinessCheck.of((ProductionReadinessCheck.Error[])new ProductionReadinessCheck.Error[]{ProductionReadinessCheck.Error.of((String)"The current persistence unit (jdbc:h2) is intended for tests only.", (String)"polaris.persistence.eclipselink.configuration-file")});
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to check JDBC URL", (Throwable)e);
        }
        return ProductionReadinessCheck.OK;
    }
}

