/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.RequestCacheControl;
import org.apache.hc.client5.http.cache.ResponseCacheControl;
import org.apache.hc.client5.http.impl.cache.CacheSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CacheControlHeaderParser {
    public static final CacheControlHeaderParser INSTANCE = new CacheControlHeaderParser();
    private static final Logger LOG = LoggerFactory.getLogger(CacheControlHeaderParser.class);
    private static final char EQUAL_CHAR = '=';
    private static final Tokenizer.Delimiter TOKEN_DELIMS = Tokenizer.delimiters((char)'=', (char)',');
    private static final Tokenizer.Delimiter VALUE_DELIMS = Tokenizer.delimiters((char)'=', (char)',');
    private final Tokenizer tokenParser = Tokenizer.INSTANCE;

    protected CacheControlHeaderParser() {
    }

    public void parse(Iterator<Header> headerIterator, BiConsumer<String, String> consumer) {
        while (headerIterator.hasNext()) {
            Tokenizer.Cursor cursor;
            CharArrayBuffer buffer;
            Header header = headerIterator.next();
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                cursor = new Tokenizer.Cursor(((FormattedHeader)header).getValuePos(), buffer.length());
            } else {
                String s = header.getValue();
                if (s == null) continue;
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                cursor = new Tokenizer.Cursor(0, buffer.length());
            }
            while (!cursor.atEnd()) {
                String name = this.tokenParser.parseToken((CharSequence)buffer, cursor, TOKEN_DELIMS);
                String value = null;
                if (!cursor.atEnd()) {
                    char valueDelim = buffer.charAt(cursor.getPos());
                    cursor.updatePos(cursor.getPos() + 1);
                    if (valueDelim == '=') {
                        value = this.tokenParser.parseValue((CharSequence)buffer, cursor, VALUE_DELIMS);
                        if (!cursor.atEnd()) {
                            cursor.updatePos(cursor.getPos() + 1);
                        }
                    }
                }
                consumer.accept(name, value);
            }
        }
    }

    public final ResponseCacheControl parseResponse(Iterator<Header> headerIterator) {
        Args.notNull(headerIterator, (String)"headerIterator");
        ResponseCacheControl.Builder builder = ResponseCacheControl.builder();
        this.parse(headerIterator, (name, value) -> {
            if (name.equalsIgnoreCase("s-maxage")) {
                builder.setSharedMaxAge(CacheControlHeaderParser.parseSeconds(name, value));
            } else if (name.equalsIgnoreCase("max-age")) {
                builder.setMaxAge(CacheControlHeaderParser.parseSeconds(name, value));
            } else if (name.equalsIgnoreCase("must-revalidate")) {
                builder.setMustRevalidate(true);
            } else if (name.equalsIgnoreCase("no-cache")) {
                builder.setNoCache(true);
                if (value != null) {
                    ParserCursor valCursor = new ParserCursor(0, value.length());
                    HashSet<String> noCacheFields = new HashSet<String>();
                    while (!valCursor.atEnd()) {
                        String token = this.tokenParser.parseToken((CharSequence)value, (Tokenizer.Cursor)valCursor, VALUE_DELIMS);
                        if (!TextUtils.isBlank((CharSequence)token)) {
                            noCacheFields.add(token);
                        }
                        if (valCursor.atEnd()) continue;
                        valCursor.updatePos(valCursor.getPos() + 1);
                    }
                    builder.setNoCacheFields(noCacheFields);
                }
            } else if (name.equalsIgnoreCase("no-store")) {
                builder.setNoStore(true);
            } else if (name.equalsIgnoreCase("private")) {
                builder.setCachePrivate(true);
            } else if (name.equalsIgnoreCase("proxy-revalidate")) {
                builder.setProxyRevalidate(true);
            } else if (name.equalsIgnoreCase("public")) {
                builder.setCachePublic(true);
            } else if (name.equalsIgnoreCase("stale-while-revalidate")) {
                builder.setStaleWhileRevalidate(CacheControlHeaderParser.parseSeconds(name, value));
            } else if (name.equalsIgnoreCase("stale-if-error")) {
                builder.setStaleIfError(CacheControlHeaderParser.parseSeconds(name, value));
            } else if (name.equalsIgnoreCase("must-understand")) {
                builder.setMustUnderstand(true);
            } else if (name.equalsIgnoreCase("immutable")) {
                builder.setImmutable(true);
            }
        });
        return builder.build();
    }

    public final ResponseCacheControl parse(HttpResponse response) {
        return this.parseResponse(response.headerIterator("Cache-Control"));
    }

    public final ResponseCacheControl parse(HttpCacheEntry cacheEntry) {
        return this.parseResponse(cacheEntry.headerIterator("Cache-Control"));
    }

    public final RequestCacheControl parseRequest(Iterator<Header> headerIterator) {
        Args.notNull(headerIterator, (String)"headerIterator");
        RequestCacheControl.Builder builder = RequestCacheControl.builder();
        this.parse(headerIterator, (name, value) -> {
            if (name.equalsIgnoreCase("max-age")) {
                builder.setMaxAge(CacheControlHeaderParser.parseSeconds(name, value));
            } else if (name.equalsIgnoreCase("max-stale")) {
                builder.setMaxStale(CacheControlHeaderParser.parseSeconds(name, value));
            } else if (name.equalsIgnoreCase("min-fresh")) {
                builder.setMinFresh(CacheControlHeaderParser.parseSeconds(name, value));
            } else if (name.equalsIgnoreCase("no-store")) {
                builder.setNoStore(true);
            } else if (name.equalsIgnoreCase("no-cache")) {
                builder.setNoCache(true);
            } else if (name.equalsIgnoreCase("only-if-cached")) {
                builder.setOnlyIfCached(true);
            } else if (name.equalsIgnoreCase("stale-if-error")) {
                builder.setStaleIfError(CacheControlHeaderParser.parseSeconds(name, value));
            }
        });
        return builder.build();
    }

    public final RequestCacheControl parse(HttpRequest request) {
        return this.parseRequest(request.headerIterator("Cache-Control"));
    }

    private static long parseSeconds(String name, String value) {
        long delta = CacheSupport.deltaSeconds(value);
        if (delta == -1L && LOG.isDebugEnabled()) {
            LOG.debug("Directive {} is malformed: {}", (Object)name, (Object)value);
        }
        return delta;
    }
}

