/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.async;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.WWWFormCodec;
import org.apache.hc.core5.util.Asserts;

public class AsyncRandomHandler
implements AsyncServerExchangeHandler {
    private final AtomicReference<AsyncEntityProducer> entityProducerRef = new AtomicReference();

    public void releaseResources() {
        AsyncEntityProducer producer = this.entityProducerRef.getAndSet(null);
        if (producer != null) {
            producer.releaseResources();
        }
    }

    public void handleRequest(HttpRequest request, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext context) throws HttpException, IOException {
        long n;
        String path;
        int slash;
        URI uri;
        String method = request.getMethod();
        if (!("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method))) {
            throw new MethodNotSupportedException(method + " not supported by " + this.getClass().getName());
        }
        try {
            uri = request.getUri();
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), (Throwable)ex);
        }
        String query = uri.getQuery();
        int delayMs = 0;
        boolean drip = false;
        if (query != null) {
            List params = WWWFormCodec.parse((CharSequence)query, (Charset)StandardCharsets.UTF_8);
            for (NameValuePair param : params) {
                String name = param.getName();
                String value = param.getValue();
                if ("delay".equals(name)) {
                    delayMs = Integer.parseInt(value);
                    continue;
                }
                if (!"drip".equals(name)) continue;
                drip = "1".equals(value);
            }
        }
        if ((slash = (path = uri.getPath()).lastIndexOf(47)) != -1) {
            String payload = path.substring(slash + 1);
            if (!payload.isEmpty()) {
                try {
                    n = Long.parseLong(payload);
                }
                catch (NumberFormatException ex) {
                    throw new ProtocolException("Invalid request path: " + path);
                }
            } else {
                n = 1 + (int)(Math.random() * 79.0);
            }
        } else {
            throw new ProtocolException("Invalid request path: " + path);
        }
        BasicHttpResponse response = new BasicHttpResponse(200);
        RandomBinAsyncEntityProducer entityProducer = new RandomBinAsyncEntityProducer(n, delayMs, drip);
        this.entityProducerRef.set((AsyncEntityProducer)entityProducer);
        responseChannel.sendResponse((HttpResponse)response, (EntityDetails)entityProducer, context);
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        capacityChannel.update(Integer.MAX_VALUE);
    }

    public void consume(ByteBuffer src) throws IOException {
    }

    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
    }

    public int available() {
        AsyncEntityProducer producer = this.entityProducerRef.get();
        Asserts.notNull((Object)producer, (String)"Entity producer");
        return producer.available();
    }

    public void produce(DataStreamChannel channel) throws IOException {
        AsyncEntityProducer producer = this.entityProducerRef.get();
        Asserts.notNull((Object)producer, (String)"Entity producer");
        producer.produce(channel);
    }

    public void failed(Exception cause) {
        this.releaseResources();
    }

    public static class RandomBinAsyncEntityProducer
    extends AbstractBinAsyncEntityProducer {
        private static final byte[] RANGE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes(StandardCharsets.US_ASCII);
        private final long length;
        private long remaining;
        private final ByteBuffer buffer;
        private final int delayMs;
        private final boolean drip;
        private volatile long deadline;

        public RandomBinAsyncEntityProducer(long len) {
            this(len, 0, false);
        }

        public RandomBinAsyncEntityProducer(long len, int delayMs, boolean drip) {
            super(512, ContentType.DEFAULT_TEXT);
            this.length = len;
            this.remaining = len;
            this.buffer = ByteBuffer.allocate(1024);
            this.delayMs = delayMs;
            this.deadline = System.currentTimeMillis() + (long)(drip ? 0 : delayMs);
            this.drip = drip;
        }

        public void releaseResources() {
            this.remaining = this.length;
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return this.length;
        }

        public int availableData() {
            return Integer.MAX_VALUE;
        }

        protected void produceData(StreamChannel<ByteBuffer> channel) throws IOException {
            if (System.currentTimeMillis() < this.deadline) {
                return;
            }
            int chunk = Math.min((int)(this.remaining < Integer.MAX_VALUE ? this.remaining : Integer.MAX_VALUE), this.buffer.remaining());
            for (int i = 0; i < chunk; ++i) {
                byte b = RANGE[(int)(Math.random() * (double)RANGE.length)];
                this.buffer.put(b);
            }
            this.remaining -= (long)chunk;
            this.buffer.flip();
            channel.write((Buffer)this.buffer);
            this.buffer.compact();
            if (this.remaining <= 0L && this.buffer.position() == 0) {
                channel.endStream();
            } else if (this.drip) {
                this.deadline = System.currentTimeMillis() + (long)this.delayMs;
            }
        }

        public void failed(Exception cause) {
        }
    }
}

