/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.ArrayDecoding;
import com.xugu.cloudjdbc.ArrayEncoding;
import com.xugu.cloudjdbc.Blob;
import com.xugu.cloudjdbc.Clob;
import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Field;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.RowData;
import com.xugu.cloudjdbc.Statement;
import com.xugu.util.ByteConverter;
import com.xugu.util.ResourceLock;
import com.xugu.util.internal.Nullness;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Array
implements java.sql.Array {
    protected @Nullable Connection connection;
    private final int typeId;
    protected @Nullable String fieldString;
    protected @Nullable ArrayDecoding.DBArrayList arrayList;
    protected @Nullable byte[] fieldBytes;
    private final ResourceLock lock = new ResourceLock();

    private Array(Connection connection, int typeId) throws SQLException {
        this.connection = connection;
        this.typeId = typeId;
    }

    public Array(Connection connection, int typeId, @Nullable String fieldString) throws SQLException {
        this(connection, typeId);
        this.fieldString = fieldString;
    }

    public Array(Connection connection, int typeId, @Nullable byte[] fieldBytes) throws SQLException {
        this(connection, typeId);
        this.fieldBytes = fieldBytes;
    }

    private Connection getConnection() {
        return Nullness.castNonNull(this.connection);
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArrayImpl(1L, 0, null);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArrayImpl(index, count, null);
    }

    public Object getArrayImpl(Map<String, Class<?>> map) throws SQLException {
        return this.getArrayImpl(1L, 0, map);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArrayImpl(map);
    }

    @Override
    public Object getArray(long index, int count, @Nullable Map<String, Class<?>> map) throws SQLException {
        return this.getArrayImpl(index, count, map);
    }

    public @Nullable Object getArrayImpl(long index, int count, @Nullable Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw new SQLException("getArrayImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new SQLException("The array index is out of range: {0}");
        }
        if (this.fieldBytes != null) {
            return this.readBinaryArray(this.fieldBytes, (int)index, count);
        }
        if (this.fieldString == null) {
            return null;
        }
        ArrayDecoding.DBArrayList arrayList = this.buildArrayList(this.fieldString);
        if (count == 0) {
            count = arrayList.size();
        }
        if (index - 1L + (long)count > (long)arrayList.size()) {
            throw new SQLException("The array index is out of range: {0}, number of elements: {1}.");
        }
        return this.buildArray(arrayList, (int)index, count);
    }

    private Object readBinaryArray(byte[] fieldBytes, int index, int count) throws SQLException {
        return ArrayDecoding.readBinaryArray(index, count, fieldBytes, this.getConnection());
    }

    private int calcRemainingDataLength(byte[] fieldBytes, int[] dims, int pos, int elementOid, int thisDimension) {
        if (thisDimension == dims.length - 1) {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                int len = ByteConverter.int4(fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
        } else {
            pos = this.calcRemainingDataLength(fieldBytes, dims, elementOid, pos, thisDimension + 1);
        }
        return pos;
    }

    private ArrayDecoding.DBArrayList buildArrayList(String fieldString) {
        ArrayDecoding.DBArrayList var4;
        try (ResourceLock ignore = this.lock.obtain();){
            if (this.arrayList == null) {
                this.arrayList = ArrayDecoding.buildArrayList(fieldString, ',');
            }
            var4 = this.arrayList;
        }
        return var4;
    }

    private Object buildArray(ArrayDecoding.DBArrayList input, int index, int count) throws SQLException {
        Connection connection = this.getConnection();
        return ArrayDecoding.readStringArray(index, count, this.typeId, input, connection);
    }

    @Override
    public int getBaseType() throws SQLException {
        return 2003;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return "Array";
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.getResultSetImpl(1L, 0, null);
    }

    @Override
    public java.sql.ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSetImpl(index, count, null);
    }

    @Override
    public java.sql.ResultSet getResultSet(@Nullable Map<String, Class<?>> map) throws SQLException {
        return this.getResultSetImpl(map);
    }

    @Override
    public java.sql.ResultSet getResultSet(long index, int count, @Nullable Map<String, Class<?>> map) throws SQLException {
        return this.getResultSetImpl(index, count, map);
    }

    public java.sql.ResultSet getResultSetImpl(@Nullable Map<String, Class<?>> map) throws SQLException {
        return this.getResultSetImpl(1L, 0, map);
    }

    public java.sql.ResultSet getResultSetImpl(long index, int count, @Nullable Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw new SQLException("getResultSetImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new SQLException("The array index is out of range: {0}");
        }
        ArrayDecoding.DBArrayList arrayList = this.buildArrayList(Nullness.castNonNull(this.fieldString));
        if (count == 0) {
            count = arrayList.size();
        }
        if (--index + (long)count > (long)arrayList.size()) {
            throw new SQLException("The array index is out of range: {0}, number of elements: {1}.");
        }
        if (arrayList.dimensionsCount <= 1) {
            Field[] fields = new Field[2];
            int fieldPrecisionScale = -1;
            String catalog = this.connection.getCatalog();
            fields[0] = new Field("index", 30, fieldPrecisionScale, 0, catalog);
            fields[1] = new Field("value", this.typeId - 10000, fieldPrecisionScale, 0, catalog);
            Vector<byte[][]> vector = new Vector<byte[][]>();
            RowData rowData = new RowData(vector);
            for (int i = 0; i < count; ++i) {
                byte[][] rowBytes = new byte[2][];
                int offset = (int)index + i;
                String v = (String)arrayList.get(offset);
                try {
                    rowBytes[0] = Integer.toString(offset + 1).getBytes(this.connection.getCharSet());
                    rowBytes[1] = v == null ? null : this.stringToBytes(v, this.typeId - 10000);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                vector.add(rowBytes);
            }
            Statement statement = (Statement)this.connection.createStatement();
            ResultSet conResultSet = new ResultSet(this.connection, statement, this.connection.getCatalog(), fields, rowData, null);
            conResultSet.addRowCount();
            conResultSet.setRsIsOver(true);
            return conResultSet;
        }
        Field[] fields = new Field[2];
        int fieldPrecisionScale = -1;
        String catalog = this.connection.getCatalog();
        fields[0] = new Field("index", 30, fieldPrecisionScale, 0, catalog);
        fields[1] = new Field("value", this.typeId, fieldPrecisionScale, 0, catalog);
        Vector<byte[][]> vector = new Vector<byte[][]>();
        RowData rowData = new RowData(vector);
        for (int i = 0; i < count; ++i) {
            byte[][] rowBytes = new byte[2][];
            int offset = (int)index + i;
            Object v = arrayList.get(offset);
            try {
                rowBytes[0] = Integer.toString(offset + 1).getBytes(this.connection.getCharSet());
                rowBytes[1] = v == null ? null : this.toString((ArrayDecoding.DBArrayList)v).getBytes(this.connection.getCharSet());
            }
            catch (UnsupportedEncodingException var17) {
                throw new RuntimeException(var17);
            }
            vector.add(rowBytes);
        }
        Statement statement = (Statement)this.connection.createStatement();
        ResultSet conResultSet = new ResultSet(this.connection, statement, this.connection.getCatalog(), fields, rowData, null);
        conResultSet.addRowCount();
        conResultSet.setRsIsOver(true);
        return conResultSet;
    }

    private byte[] stringToBytes(String v, int baseTypeId) throws SQLException, IOException {
        byte[] byteArray;
        switch (baseTypeId) {
            case 3: {
                byte[] byteArray2 = new byte[1];
                short tinyintValue = Short.parseShort(v);
                byteArray2[0] = (byte)(tinyintValue & 0xFF);
                return byteArray2;
            }
            case 4: {
                byte[] byteArray3 = new byte[2];
                short shortValue = Short.parseShort(v);
                for (int i = 0; i < byteArray3.length; ++i) {
                    byteArray3[1 - i] = (byte)(shortValue >>> 8 * i & 0xFF);
                }
                return byteArray3;
            }
            case 5: {
                byte[] byteArray4 = new byte[4];
                int intValue = Integer.parseInt(v);
                for (int i = 0; i < byteArray4.length; ++i) {
                    byteArray4[3 - i] = (byte)(intValue >>> 8 * i & 0xFF);
                }
                return byteArray4;
            }
            case 8: {
                float floatValue = Float.parseFloat(v);
                ByteBuffer floatBuffer = ByteBuffer.allocate(4);
                floatBuffer.putFloat(floatValue);
                byteArray = floatBuffer.array();
                break;
            }
            case 9: {
                double doubleValue = Double.parseDouble(v);
                ByteBuffer doubleBuffer = ByteBuffer.allocate(8);
                doubleBuffer.putDouble(doubleValue);
                byteArray = doubleBuffer.array();
                break;
            }
            case 6: {
                byte[] byteArray5 = new byte[8];
                long longValue = Long.parseLong(v);
                for (int i = 0; i < 8; ++i) {
                    byteArray5[i] = (byte)(longValue >>> 56 - 8 * i & 0xFFL);
                }
                return byteArray5;
            }
            case 34: {
                int len;
                Blob b = new Blob(v.getBytes());
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                InputStream bs = b.getBinaryStream();
                byte[] temp = new byte[4096];
                while ((len = bs.read(temp)) != -1) {
                    bytesOut.write(temp, 0, len);
                }
                bytesOut.close();
                byteArray = bytesOut.toByteArray();
                break;
            }
            case 32: {
                Clob clob = new Clob(v);
                Reader reader = clob.getCharacterStream();
                char[] c = new char[4096];
                int cLen = 0;
                StringBuffer buf = new StringBuffer();
                while ((cLen = reader.read(c)) != -1) {
                    buf.append(c, 0, cLen);
                }
                byteArray = buf.toString().getBytes(this.connection.getCharSet());
                break;
            }
            case 10: {
                String[] dateStr = v.split("[- :.]");
                int dy = 0;
                int dYear = Integer.parseInt(dateStr[0]);
                if (dateStr[dateStr.length - 1].equalsIgnoreCase("bc")) {
                    dYear = 1 - dYear;
                }
                dy = 110000 + dYear;
                int[] dmd = new int[]{Integer.parseInt(dateStr[1]), Integer.parseInt(dateStr[2])};
                int dd = 0;
                boolean isR = --dy % 400 == 0 || dy % 4 == 0 && dy % 100 != 0;
                int[][] dCount = isR ? Connection.day2md_rn : Connection.day2md;
                for (int i = 0; i < 365; ++i) {
                    if (dCount[i][0] != dmd[0] || dCount[i][1] != dmd[1]) continue;
                    dd = i;
                    break;
                }
                if (dmd[0] == 1 && dmd[1] <= 10) {
                    dd = isR ? 366 + dd : 365 + dd;
                } else {
                    ++dy;
                }
                int dy400 = (dy - 1) / 400;
                int dy100 = (dy - 1) / 100;
                int dy4 = (dy - 1) / 4;
                int dTimestamp = dy * 365 + dy4 - dy100 + dy400;
                dTimestamp += dd;
                dTimestamp -= 40896202;
                byteArray = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    byteArray[i] = (byte)(dTimestamp >> (3 - i) * 8 & 0xFF);
                }
                break;
            }
            case 13: {
                int i;
                String[] dateTimeStr = v.split("[- :.]");
                int dty = 0;
                int dtYear = Integer.parseInt(dateTimeStr[0]);
                if (dateTimeStr[dateTimeStr.length - 1].equalsIgnoreCase("bc")) {
                    dtYear = 1 - dtYear;
                }
                dty = 110000 + dtYear;
                int[] dtmd = new int[]{Integer.parseInt(dateTimeStr[1]), Integer.parseInt(dateTimeStr[2])};
                int dtd = 0;
                boolean isR = --dty % 400 == 0 || dty % 4 == 0 && dty % 100 != 0;
                int[][] dtCount = isR ? Connection.day2md_rn : Connection.day2md;
                for (int i2 = 0; i2 < 365; ++i2) {
                    if (dtCount[i2][0] != dtmd[0] || dtCount[i2][1] != dtmd[1]) continue;
                    dtd = i2;
                    break;
                }
                if (dtmd[0] == 1 && dtmd[1] <= 10) {
                    dtd = isR ? 366 + dtd : 365 + dtd;
                } else {
                    ++dty;
                }
                int dty400 = (dty - 1) / 400;
                int dty100 = (dty - 1) / 100;
                int dty4 = (dty - 1) / 4;
                long dtTimestamp = (long)dty * 365L + (long)dty4 - (long)dty100 + (long)dty400;
                dtTimestamp += (long)dtd;
                dtTimestamp *= 86400L;
                int dth = Integer.parseInt(dateTimeStr[3]) * 3600;
                int dtm = Integer.parseInt(dateTimeStr[4]) * 60;
                int dts = Integer.parseInt(dateTimeStr[5]);
                int s = dth + dtm + dts;
                dtTimestamp += (long)s;
                dtTimestamp *= 1000000L;
                dtTimestamp -= 3533431852800000000L;
                dtTimestamp /= 1000L;
                if (dateTimeStr.length >= 7 && !dateTimeStr[6].equalsIgnoreCase("bc")) {
                    int len = dateTimeStr[6].length();
                    if (len < 3) {
                        for (i = 0; i < 3 - len; ++i) {
                            dateTimeStr[6] = dateTimeStr[6] + 0;
                        }
                    }
                    dtTimestamp += Long.parseLong(dateTimeStr[6]);
                }
                byteArray = new byte[8];
                for (i = 7; i >= 0; --i) {
                    byteArray[i] = (byte)(dtTimestamp >> (8 - i - 1) * 8 & 0xFFL);
                }
                break;
            }
            case 11: {
                String[] time = v.split(":");
                long timestamp = (long)Integer.parseInt(time[0]) * 3600L + (long)Integer.parseInt(time[1]) * 60L + (long)Integer.parseInt(time[2]);
                byteArray = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    byteArray[i] = (byte)(timestamp * 1000L >> (3 - i) * 8 & 0xFFL);
                }
                break;
            }
            case 14: {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssXXX");
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(v, formatter);
                long timestamp = zonedDateTime.toInstant().toEpochMilli() * 1000L;
                byteArray = new byte[10];
                for (int i = 7; i >= 0; --i) {
                    byteArray[i] = (byte)(timestamp >> (8 - i - 1) * 8 & 0xFFL);
                }
                String[] dateTimeTZ = v.split("[-|+:]");
                int intZone = Integer.parseInt(dateTimeTZ[dateTimeTZ.length - 2]) * 60 + Integer.parseInt(dateTimeTZ[dateTimeTZ.length - 1]);
                if (!v.contains("+")) {
                    intZone = -intZone;
                }
                for (int i = 0; i < 2; ++i) {
                    byteArray[8 + i] = (byte)(intZone >> (1 - i) * 8 & 0xFF);
                }
                break;
            }
            case 12: {
                int i;
                String[] timeTZ = v.split("[-|+:]");
                int intZone = Integer.parseInt(timeTZ[timeTZ.length - 2]) * 60 + Integer.parseInt(timeTZ[timeTZ.length - 1]);
                if (!v.contains("+")) {
                    intZone = -intZone;
                }
                long timestamp = (long)Integer.parseInt(timeTZ[0]) * 3600L + (long)Integer.parseInt(timeTZ[1]) * 60L + (long)Integer.parseInt(timeTZ[2]) - (long)intZone * 60L;
                byteArray = new byte[6];
                for (i = 0; i < 4; ++i) {
                    byteArray[i] = (byte)(timestamp * 1000L >> (3 - i) * 8 & 0xFFL);
                }
                for (i = 0; i < 2; ++i) {
                    byteArray[4 + i] = (byte)(intZone >> (1 - i) * 8 & 0xFF);
                }
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: {
                long INValue = Long.parseLong(v);
                byteArray = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    byteArray[i] = (byte)(INValue >> (3 - i) * 8 & 0xFFL);
                }
                break;
            }
            case 27: {
                long ISValue = (long)(Double.parseDouble(v) * 1000000.0);
                byteArray = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    byteArray[i] = (byte)(ISValue >> (7 - i) * 8 & 0xFFL);
                }
                break;
            }
            case 16: {
                String[] Y2M = v.split("-");
                byteArray = new byte[4];
                int Y2MValue = Integer.parseInt(Y2M[0]) * 12 + Integer.parseInt(Y2M[1]);
                for (int i = 0; i < byteArray.length; ++i) {
                    byteArray[3 - i] = (byte)(Y2MValue >>> 8 * i & 0xFF);
                }
                break;
            }
            case 19: {
                String[] D2H = v.split(" ");
                byteArray = new byte[4];
                int D2HValue = Integer.parseInt(D2H[0]) * 24 + Integer.parseInt(D2H[1]);
                for (int i = 0; i < byteArray.length; ++i) {
                    byteArray[3 - i] = (byte)(D2HValue >>> 8 * i & 0xFF);
                }
                break;
            }
            case 21: {
                String[] D2M = v.split("[ |:]");
                int D2MValue = Integer.parseInt(D2M[0]) * 24 * 60 + Integer.parseInt(D2M[1]) * 60 + Integer.parseInt(D2M[2]);
                byteArray = new byte[4];
                for (int i = 0; i < byteArray.length; ++i) {
                    byteArray[3 - i] = (byte)(D2MValue >>> 8 * i & 0xFF);
                }
                break;
            }
            case 24: {
                int i;
                String[] D2S = v.split("[ |:.]");
                long D2SValue = Long.parseLong(D2S[0]) * 24L * 60L * 60L * 1000000L + Long.parseLong(D2S[1]) * 60L * 60L * 1000000L + Long.parseLong(D2S[2]) * 60L * 1000000L + Long.parseLong(D2S[3]) * 1000000L;
                if (D2S.length == 5) {
                    int len = D2S[4].length();
                    if (len < 6) {
                        for (i = 0; i < 6 - len; ++i) {
                            D2S[4] = D2S[4] + 0;
                        }
                    }
                    D2SValue += Long.parseLong(D2S[4]);
                }
                byteArray = new byte[8];
                for (i = 7; i >= 0; --i) {
                    byteArray[i] = (byte)(D2SValue >> (8 - i - 1) * 8 & 0xFFL);
                }
                break;
            }
            case 22: {
                String[] H2M = v.split(":");
                int H2MValue = Integer.parseInt(H2M[0]) * 60 + Integer.parseInt(H2M[1]);
                byteArray = new byte[4];
                for (int i = 0; i < byteArray.length; ++i) {
                    byteArray[3 - i] = (byte)(H2MValue >>> 8 * i & 0xFF);
                }
                break;
            }
            case 25: {
                int i;
                String[] H2S = v.split("[:|.]");
                long H2SValue = Long.parseLong(H2S[0]) * 60L * 60L * 1000000L + Long.parseLong(H2S[1]) * 60L * 1000000L + Long.parseLong(H2S[2]) * 1000000L;
                if (H2S.length == 4) {
                    int len = H2S[3].length();
                    if (len < 6) {
                        for (i = 0; i < 6 - len; ++i) {
                            H2S[3] = H2S[3] + 0;
                        }
                    }
                    H2SValue += Long.parseLong(H2S[3]);
                }
                byteArray = new byte[8];
                for (i = 7; i >= 0; --i) {
                    byteArray[i] = (byte)(H2SValue >> (8 - i - 1) * 8 & 0xFFL);
                }
                break;
            }
            case 26: {
                int i;
                String[] M2S = v.split("[:|.]");
                long M2SValue = Long.parseLong(M2S[0]) * 60L * 1000000L + Long.parseLong(M2S[1]) * 1000000L;
                if (M2S.length == 3) {
                    int len = M2S[2].length();
                    if (len < 6) {
                        for (i = 0; i < 6 - len; ++i) {
                            M2S[2] = M2S[2] + 0;
                        }
                    }
                    M2SValue += Long.parseLong(M2S[2]);
                }
                byteArray = new byte[8];
                for (i = 7; i >= 0; --i) {
                    byteArray[i] = (byte)(M2SValue >> (8 - i - 1) * 8 & 0xFFL);
                }
                break;
            }
            case 2: {
                byteArray = new byte[]{(byte)("true".equalsIgnoreCase(v) ? 84 : 70)};
                break;
            }
            case 7: 
            case 30: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 64: 
            case 65: {
                byteArray = v.getBytes(this.connection.getCharSet());
                break;
            }
            default: {
                throw new SQLException("\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u7c7b\u578b");
            }
        }
        return byteArray;
    }

    public @Nullable String toString() {
        if (this.fieldString == null && this.fieldBytes != null) {
            try {
                Object array = this.readBinaryArray(this.fieldBytes, 1, 0);
                ArrayEncoding.ArrayEncoder<Object> arraySupport = ArrayEncoding.getArrayEncoder(array);
                assert (arraySupport != null);
                this.fieldString = arraySupport.toArrayString(',', array);
            }
            catch (SQLException var3) {
                this.fieldString = "NULL";
            }
        }
        return this.fieldString;
    }

    private String toString(ArrayDecoding.DBArrayList list) {
        if (list == null) {
            return "NULL";
        }
        StringBuilder b = new StringBuilder().append('{');
        char delim = ',';
        for (int i = 0; i < list.size(); ++i) {
            Object v = list.get(i);
            if (i > 0) {
                b.append(delim);
            }
            if (v == null) {
                b.append("NULL");
                continue;
            }
            if (v instanceof ArrayDecoding.DBArrayList) {
                b.append(this.toString((ArrayDecoding.DBArrayList)v));
                continue;
            }
            Array.escapeArrayElement(b, (String)v);
        }
        b.append('}');
        return b.toString();
    }

    public static void escapeArrayElement(StringBuilder b, String s) {
        b.append('\"');
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == '\"' || c == '\\') {
                b.append('\\');
            }
            b.append(c);
        }
        b.append('\"');
    }

    public boolean isBinary() {
        return this.fieldBytes != null;
    }

    public @Nullable byte[] toBytes() {
        return this.fieldBytes;
    }

    @Override
    public void free() throws SQLException {
        this.connection = null;
        this.fieldString = null;
        this.fieldBytes = null;
        this.arrayList = null;
    }
}

