/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.uri;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.snmp4j.CertifiedTarget;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.uri.SnmpUriCallback;
import org.snmp4j.uri.SnmpUriResponse;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;
import org.snmp4j.util.TreeUtils;

public class SnmpURI<A extends Address> {
    private Session snmp;
    private USM usm;
    private Target<A> defaultTarget;
    private int version = 3;
    private int securityModel = 3;
    private long timeout = 5000L;
    private int retries = 1;
    private String defaultUserInfo = "public";
    private PDUFactory pduFactory = new DefaultPDUFactory();

    public SnmpURI(Session snmp) throws IOException {
        this.snmp = snmp;
        if (snmp instanceof Snmp) {
            this.usm = ((Snmp)snmp).getUSM();
        }
    }

    public SnmpURI(Session snmp, Target<A> defaultTarget) throws IOException {
        this.snmp = snmp;
        this.defaultTarget = defaultTarget;
        if (snmp instanceof Snmp) {
            this.usm = ((Snmp)snmp).getUSM();
        }
    }

    public PDUFactory getPduFactory() {
        return this.pduFactory;
    }

    public void setPduFactory(PDUFactory pduFactory) {
        this.pduFactory = pduFactory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getSecurityModel() {
        return this.securityModel;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setSecurityModel(int securityModel) {
        this.securityModel = securityModel;
    }

    public void setSnmp(Session snmp) {
        this.snmp = snmp;
    }

    public USM getUsm() {
        return this.usm;
    }

    public void setUsm(USM usm) {
        this.usm = usm;
    }

    public String getDefaultUserInfo() {
        return this.defaultUserInfo;
    }

    public void setDefaultUserInfo(String defaultUserInfo) {
        this.defaultUserInfo = defaultUserInfo;
    }

    public void browse(URI url, SnmpUriCallback callback, Object userObject) throws UnknownHostException {
        Request request = this.createSnmpRequest(url);
        PDU pdu = request.getPdu();
        switch (request.getType()) {
            case GET: {
                pdu.setType(-96);
                pdu.addAll(VariableBinding.createFromOIDs(request.getOIDs()));
                this.sendSnmpRequest(request, pdu, url, callback, userObject);
                break;
            }
            case NEXT: {
                pdu.setType(-95);
                pdu.addAll(VariableBinding.createFromOIDs(request.getOIDs()));
                this.sendSnmpRequest(request, pdu, url, callback, userObject);
                break;
            }
            case SUBTREE: {
                TreeUtils treeUtils = new TreeUtils(this.snmp, this.pduFactory);
                AsyncTreeListener treeListener = new AsyncTreeListener(url, callback);
                treeUtils.walk(request.getTarget(), request.getOIDs(), userObject, treeListener);
            }
        }
    }

    public SnmpUriResponse browse(URI url) throws UnknownHostException {
        SnmpUriResponse response = new SnmpUriResponse(5);
        Request request = this.createSnmpRequest(url);
        PDU pdu = request.getPdu();
        switch (request.getType()) {
            case GET: {
                pdu.setType(-96);
                pdu.addAll(VariableBinding.createFromOIDs(request.getOIDs()));
                response = this.sendSnmpRequest(request, pdu);
                break;
            }
            case NEXT: {
                pdu.setType(-95);
                pdu.addAll(VariableBinding.createFromOIDs(request.getOIDs()));
                response = this.sendSnmpRequest(request, pdu);
                break;
            }
            case SUBTREE: {
                TreeUtils treeUtils = new TreeUtils(this.snmp, this.pduFactory);
                List<TreeEvent> treeEventList = treeUtils.walk(request.getTarget(), request.getOIDs());
                ArrayList<VariableBinding[]> vbs = new ArrayList<VariableBinding[]>(treeEventList.size());
                int errorStatus = 0;
                for (TreeEvent treeEvent : treeEventList) {
                    vbs.add(treeEvent.getVariableBindings());
                    errorStatus = treeEvent.getStatus();
                }
                response = new SnmpUriResponse(vbs, errorStatus);
            }
        }
        return response;
    }

    public SnmpUriResponse updateByValue(URI url, List<Variable> values) throws UnknownHostException {
        Request request = this.createSnmpRequest(url);
        PDU pdu = request.getPdu();
        pdu.setType(-93);
        OID[] oids = request.getOIDs();
        for (int i = 0; i < oids.length && i < values.size(); ++i) {
            pdu.add(new VariableBinding(oids[i], values.get(i)));
        }
        SnmpUriResponse response = this.sendSnmpRequest(request, pdu);
        return response;
    }

    public SnmpUriResponse updateByBinding(URI url, List<VariableBinding> values) throws UnknownHostException {
        return this.sendByBinding(url, values, -93);
    }

    public SnmpUriResponse sendByBinding(URI url, List<VariableBinding> values, int pduType) throws UnknownHostException {
        Request request = this.createSnmpRequest(url);
        PDU pdu = request.getPdu();
        pdu.setType(pduType);
        for (VariableBinding vb : values) {
            pdu.add(vb);
        }
        SnmpUriResponse response = this.sendSnmpRequest(request, pdu);
        return response;
    }

    private SnmpUriResponse sendSnmpRequest(Request request, PDU pdu) {
        SnmpUriResponse response = new SnmpUriResponse(5);
        try {
            PDU responsePDU;
            ResponseEvent<?> responseEvent = this.snmp.send(pdu, request.getTarget());
            response = responseEvent != null ? ((responsePDU = responseEvent.getResponse()) != null ? (responsePDU.getErrorStatus() != 0 ? new SnmpUriResponse(responsePDU.getErrorStatus()) : new SnmpUriResponse(Collections.singletonList(responsePDU.getVariableBindings().toArray(new VariableBinding[responsePDU.size()])))) : new SnmpUriResponse(SnmpUriResponse.Type.TIMEOUT)) : new SnmpUriResponse(SnmpUriResponse.Type.FINAL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    private void sendSnmpRequest(Request request, PDU pdu, URI url, SnmpUriCallback callback, Object userObject) {
        AsyncResponseListener listener = new AsyncResponseListener(url, callback);
        try {
            this.snmp.send(pdu, request.getTarget(), userObject, listener);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Request createSnmpRequest(URI url) throws UnknownHostException {
        List<Object> oids;
        PDU pdu;
        String userInfo;
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = 161;
        }
        if ((userInfo = url.getUserInfo()) == null) {
            userInfo = this.defaultUserInfo;
        }
        String path = url.getPath();
        String[] segments = path.split("/");
        String contextInfo = "";
        String contextName = "";
        OctetString contextEngineID = null;
        String oidPart = null;
        if (segments.length > 1) {
            contextInfo = segments[0];
            oidPart = segments[1];
            String[] contextInfos = contextInfo.split(";");
            if (contextInfos.length > 1) {
                contextEngineID = OctetString.fromHexStringPairs(contextInfos[1]);
            }
            contextName = contextInfos[0];
        } else if (segments.length == 1) {
            oidPart = segments[0];
        }
        Target<Object> t = host != null ? this.createTarget(host, port, new OctetString(userInfo)) : this.defaultTarget;
        if (host != null) {
            if (t instanceof CertifiedTarget) {
                // empty if block
            }
        } else {
            t = this.defaultTarget;
        }
        if ((pdu = this.pduFactory.createPDU(t)) instanceof ScopedPDU) {
            if (contextEngineID != null) {
                ((ScopedPDU)pdu).setContextEngineID(contextEngineID);
            }
            if (contextName != null) {
                ((ScopedPDU)pdu).setContextName(new OctetString(contextName));
            }
        }
        SnmpUriType type = SnmpUriType.GET;
        if (oidPart != null && oidPart.endsWith(".*")) {
            type = SnmpUriType.SUBTREE;
            oidPart = oidPart.substring(0, oidPart.length() - 2);
        } else if (oidPart != null && oidPart.endsWith("+")) {
            type = SnmpUriType.NEXT;
            oidPart = oidPart.substring(0, oidPart.length() - 1);
        }
        if (oidPart != null && oidPart.contains("(")) {
            String[] oidStrings = oidPart.split("[\\(,\\),\\,]");
            oids = new ArrayList(oidStrings.length);
            for (String oidString : oidStrings) {
                OID o;
                if (oidString.length() <= 0 || !(o = new OID(oidString)).isValid()) continue;
                oids.add(o);
            }
        } else {
            oids = oidPart != null ? Collections.singletonList(new OID(oidPart)) : Collections.emptyList();
        }
        return new Request(t, pdu, oids.toArray(new OID[oids.size()]), type);
    }

    private Target<?> createTarget(String host, int port, OctetString userInfo) throws UnknownHostException {
        if (userInfo == null || userInfo.length() == 0) {
            return this.defaultTarget;
        }
        if (this.version == 3) {
            if (this.securityModel == 3 && this.usm != null) {
                UsmUserEntry user = this.usm.getUser(null, userInfo);
                UserTarget<UdpAddress> target = new UserTarget<UdpAddress>();
                if (user != null) {
                    if (user.getAuthenticationKey() != null) {
                        if (user.getPrivacyKey() != null) {
                            target.setSecurityLevel(3);
                        } else {
                            target.setSecurityLevel(2);
                        }
                    } else {
                        target.setSecurityLevel(1);
                    }
                }
                target.setVersion(this.version);
                target.setSecurityName(userInfo);
                target.setSecurityModel(this.securityModel);
                target.setTimeout(this.timeout);
                target.setRetries(this.retries);
                target.setAddress(new UdpAddress(InetAddress.getByName(host), port));
                return target;
            }
            if (this.securityModel == 4) {
                CertifiedTarget<TlsAddress> target = new CertifiedTarget<TlsAddress>(userInfo);
                target.setVersion(this.version);
                target.setSecurityModel(this.securityModel);
                target.setTimeout(this.timeout);
                target.setRetries(this.retries);
                target.setAddress(new TlsAddress(InetAddress.getByName(host), port));
                return target;
            }
        } else {
            CommunityTarget<UdpAddress> target = new CommunityTarget<UdpAddress>();
            target.setCommunity(userInfo);
            target.setVersion(this.version);
            target.setSecurityModel(this.securityModel);
            target.setTimeout(this.timeout);
            target.setRetries(this.retries);
            target.setAddress(new UdpAddress(InetAddress.getByName(host), port));
            return target;
        }
        return null;
    }

    private class AsyncTreeListener
    implements TreeListener {
        private volatile boolean finished = false;
        private URI url;
        private SnmpUriCallback callback;

        public AsyncTreeListener(URI url, SnmpUriCallback callback) {
            this.url = url;
            this.callback = callback;
        }

        @Override
        public boolean next(TreeEvent event) {
            if (!this.finished) {
                SnmpUriResponse response = this.createResponse(event);
                this.finished |= this.callback.onResponse(response, this.url, event.getUserObject());
            }
            return !this.finished;
        }

        private SnmpUriResponse createResponse(TreeEvent event) {
            SnmpUriResponse response = new SnmpUriResponse(SnmpUriResponse.Type.TIMEOUT);
            if (event.getStatus() == 0) {
                VariableBinding[] vbs = event.getVariableBindings();
                int errorStatus = event.getStatus();
                response = new SnmpUriResponse(Collections.singletonList(vbs), errorStatus);
                if (errorStatus == 0) {
                    response.setResponseType(SnmpUriResponse.Type.NEXT);
                }
            } else if (event.getStatus() == -4) {
                response = new SnmpUriResponse(SnmpUriResponse.Type.IO_ERROR, event.getException().getMessage());
            } else if (event.getStatus() == -3) {
                response = new SnmpUriResponse(SnmpUriResponse.Type.SECURITY_ERROR, event.getReportPDU().size() > 0 ? event.getReportPDU().get(0).toString() : "<empty report PDU>");
            } else if (event.getStatus() == -2) {
                response = new SnmpUriResponse(SnmpUriResponse.Type.LEXICOGRAPHIC_ORDER_ERROR);
            }
            return response;
        }

        @Override
        public void finished(TreeEvent event) {
            if (!this.finished) {
                SnmpUriResponse response = this.createResponse(event);
                if (response.getResponseType() == SnmpUriResponse.Type.NEXT) {
                    response.setResponseType(SnmpUriResponse.Type.FINAL);
                }
                this.callback.onResponse(response, this.url, event.getUserObject());
                this.finished = true;
            }
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    private class Request {
        private Target<?> target;
        private PDU pdu;
        private OID[] oids;
        SnmpUriType type = SnmpUriType.GET;

        private Request(Target<?> target, PDU pdu, OID[] oids) {
            this.target = target;
            this.pdu = pdu;
            this.oids = oids;
        }

        private Request(Target<?> target, PDU pdu, OID[] oids, SnmpUriType type) {
            this(target, pdu, oids);
            this.type = type;
        }

        public Target<?> getTarget() {
            return this.target;
        }

        public PDU getPdu() {
            return this.pdu;
        }

        public OID[] getOIDs() {
            return this.oids;
        }

        public SnmpUriType getType() {
            return this.type;
        }
    }

    private class AsyncResponseListener
    implements ResponseListener {
        private SnmpUriCallback callback;
        private URI url;

        private AsyncResponseListener(URI url, SnmpUriCallback callback) {
            this.url = url;
            this.callback = callback;
        }

        @Override
        public <A extends Address> void onResponse(ResponseEvent<A> event) {
            SnmpUriResponse response = new SnmpUriResponse(SnmpUriResponse.Type.TIMEOUT);
            PDU responsePDU = event.getResponse();
            if (responsePDU != null) {
                response = responsePDU.getErrorStatus() != 0 ? new SnmpUriResponse(responsePDU.getErrorStatus()) : new SnmpUriResponse(Collections.singletonList(responsePDU.getVariableBindings().toArray(new VariableBinding[responsePDU.size()])));
            }
            this.callback.onResponse(response, this.url, event.getUserObject());
        }
    }

    public static enum SnmpUriType {
        GET,
        NEXT,
        SUBTREE;

    }
}

