/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.DecimalColumnVector;
import org.apache.paimon.data.columnar.Dictionary;
import org.apache.paimon.data.columnar.IntColumnVector;
import org.apache.paimon.data.columnar.LongColumnVector;
import org.apache.paimon.data.columnar.heap.ElementCountable;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.data.columnar.writable.WritableLongVector;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.utils.Preconditions;

public class ParquetDecimalVector
implements DecimalColumnVector,
WritableLongVector,
WritableIntVector,
WritableBytesVector,
ElementCountable {
    private final WritableColumnVector vector;

    public ParquetDecimalVector(WritableColumnVector vector) {
        this.vector = vector;
    }

    public Decimal getDecimal(int i, int precision, int scale) {
        if (ParquetSchemaConverter.is32BitDecimal(precision) && this.vector instanceof IntColumnVector) {
            return Decimal.fromUnscaledLong((long)((IntColumnVector)this.vector).getInt(i), (int)precision, (int)scale);
        }
        if (ParquetSchemaConverter.is64BitDecimal(precision) && this.vector instanceof LongColumnVector) {
            return Decimal.fromUnscaledLong((long)((LongColumnVector)this.vector).getLong(i), (int)precision, (int)scale);
        }
        Preconditions.checkArgument((boolean)(this.vector instanceof BytesColumnVector), (String)"Reading decimal type occur unsupported vector type: %s", (Object[])new Object[]{this.vector.getClass()});
        return Decimal.fromUnscaledBytes((byte[])((BytesColumnVector)this.vector).getBytes(i).getBytes(), (int)precision, (int)scale);
    }

    public ColumnVector getVector() {
        return this.vector;
    }

    public boolean isNullAt(int i) {
        return this.vector.isNullAt(i);
    }

    public int getCapacity() {
        return this.vector.getCapacity();
    }

    public void reset() {
        this.vector.reset();
    }

    public void setNullAt(int rowId) {
        this.vector.setNullAt(rowId);
    }

    public void setNulls(int rowId, int count) {
        this.vector.setNulls(rowId, count);
    }

    public void fillWithNulls() {
        this.vector.fillWithNulls();
    }

    public void setDictionary(Dictionary dictionary) {
        this.vector.setDictionary(dictionary);
    }

    public boolean hasDictionary() {
        return this.vector.hasDictionary();
    }

    public WritableIntVector reserveDictionaryIds(int capacity) {
        return this.vector.reserveDictionaryIds(capacity);
    }

    public WritableIntVector getDictionaryIds() {
        return this.vector.getDictionaryIds();
    }

    public void setAllNull() {
        this.vector.setAllNull();
    }

    public boolean isAllNull() {
        return this.vector.isAllNull();
    }

    public void reserve(int capacity) {
        this.vector.reserve(capacity);
    }

    public int getElementsAppended() {
        return this.vector.getElementsAppended();
    }

    public void addElementsAppended(int num) {
        this.vector.addElementsAppended(num);
    }

    public BytesColumnVector.Bytes getBytes(int i) {
        if (this.vector instanceof WritableBytesVector) {
            return ((WritableBytesVector)this.vector).getBytes(i);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    public void putByteArray(int rowId, byte[] value, int offset, int length) {
        if (this.vector instanceof WritableBytesVector) {
            ((WritableBytesVector)this.vector).putByteArray(rowId, value, offset, length);
        }
    }

    public void fill(byte[] value) {
        if (this.vector instanceof WritableBytesVector) {
            ((WritableBytesVector)this.vector).fill(value);
        }
    }

    public int getInt(int i) {
        if (this.vector instanceof WritableIntVector) {
            return ((WritableIntVector)this.vector).getInt(i);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    public void setInt(int rowId, int value) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setInt(rowId, value);
        }
    }

    public void setIntsFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setIntsFromBinary(rowId, count, src, srcIndex);
        }
    }

    public void setInts(int rowId, int count, int value) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setInts(rowId, count, value);
        }
    }

    public void setInts(int rowId, int count, int[] src, int srcIndex) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setInts(rowId, count, src, srcIndex);
        }
    }

    public void fill(int value) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).fill(value);
        }
    }

    public void appendInt(int v) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).appendInt(v);
        }
    }

    public void appendInts(int count, int v) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).appendInts(count, v);
        }
    }

    public long getLong(int i) {
        if (this.vector instanceof WritableLongVector) {
            return ((WritableLongVector)this.vector).getLong(i);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    public void setLong(int rowId, long value) {
        if (this.vector instanceof WritableLongVector) {
            ((WritableLongVector)this.vector).setLong(rowId, value);
        }
    }

    public void setLongsFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (this.vector instanceof WritableLongVector) {
            ((WritableLongVector)this.vector).setLongsFromBinary(rowId, count, src, srcIndex);
        }
    }

    public void fill(long value) {
        if (this.vector instanceof WritableLongVector) {
            ((WritableLongVector)this.vector).fill(value);
        }
    }
}

