/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.server;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class OpenLineage {

    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted"})
    public static final class JobFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public JobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this._deleted = null;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Boolean get_deleted() {
            return this._deleted;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder(value={"eventTime", "producer", "schemaURL", "job", "inputs", "outputs"})
    public static final class JobEvent
    implements BaseEvent {
        private final ZonedDateTime eventTime;
        private final URI producer;
        private final URI schemaURL;
        private final Job job;
        private final List<InputDataset> inputs;
        private final List<OutputDataset> outputs;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public JobEvent(@JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="producer") URI producer, @JsonProperty(value="schemaURL") URI schemaURL, @JsonProperty(value="job") Job job, @JsonProperty(value="inputs") List<InputDataset> inputs, @JsonProperty(value="outputs") List<OutputDataset> outputs) {
            this.eventTime = eventTime;
            this.producer = producer;
            this.schemaURL = schemaURL;
            this.job = job;
            this.inputs = inputs;
            this.outputs = outputs;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        @Override
        public URI getProducer() {
            return this.producer;
        }

        @Override
        public URI getSchemaURL() {
            return this.schemaURL;
        }

        public Job getJob() {
            return this.job;
        }

        public List<InputDataset> getInputs() {
            return this.inputs;
        }

        public List<OutputDataset> getOutputs() {
            return this.outputs;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder(value={"_producer", "_schemaURL"})
    public static final class InputDatasetFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public InputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder(value={"namespace", "name", "facets"})
    public static final class Job {
        private final String namespace;
        private final String name;
        private final JobFacets facets;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public Job(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") JobFacets facets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public JobFacets getFacets() {
            return this.facets;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder(value={"namespace", "name", "facets", "inputFacets"})
    public static final class InputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final InputDatasetInputFacets inputFacets;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public InputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="inputFacets") InputDatasetInputFacets inputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.inputFacets = inputFacets;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public InputDatasetInputFacets getInputFacets() {
            return this.inputFacets;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static interface BaseFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonPropertyOrder(value={"namespace", "name", "facets", "outputFacets"})
    public static final class OutputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final OutputDatasetOutputFacets outputFacets;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public OutputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="outputFacets") OutputDatasetOutputFacets outputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.outputFacets = outputFacets;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public OutputDatasetOutputFacets getOutputFacets() {
            return this.outputFacets;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder(value={"_producer", "_schemaURL"})
    public static final class RunFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public RunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder
    public static final class OutputDatasetOutputFacets {
        @JsonAnySetter
        private final Map<String, OutputDatasetFacet> additionalProperties = new LinkedHashMap<String, OutputDatasetFacet>();

        @JsonCreator
        public OutputDatasetOutputFacets() {
        }

        @JsonAnyGetter
        public Map<String, OutputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static interface Dataset {
        public String getNamespace();

        public String getName();

        public DatasetFacets getFacets();

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonPropertyOrder(value={"runId", "facets"})
    public static final class Run {
        private final UUID runId;
        private final RunFacets facets;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public Run(@JsonProperty(value="runId") UUID runId, @JsonProperty(value="facets") RunFacets facets) {
            this.runId = runId;
            this.facets = facets;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public UUID getRunId() {
            return this.runId;
        }

        public RunFacets getFacets() {
            return this.facets;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder
    public static final class DatasetFacets {
        @JsonAnySetter
        private final Map<String, DatasetFacet> additionalProperties = new LinkedHashMap<String, DatasetFacet>();

        @JsonCreator
        public DatasetFacets() {
        }

        @JsonAnyGetter
        public Map<String, DatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder(value={"namespace", "name", "facets"})
    public static final class StaticDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public StaticDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder(value={"eventTime", "producer", "schemaURL", "dataset"})
    public static final class DatasetEvent
    implements BaseEvent {
        private final ZonedDateTime eventTime;
        private final URI producer;
        private final URI schemaURL;
        private final StaticDataset dataset;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DatasetEvent(@JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="producer") URI producer, @JsonProperty(value="schemaURL") URI schemaURL, @JsonProperty(value="dataset") StaticDataset dataset) {
            this.eventTime = eventTime;
            this.producer = producer;
            this.schemaURL = schemaURL;
            this.dataset = dataset;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        @Override
        public URI getProducer() {
            return this.producer;
        }

        @Override
        public URI getSchemaURL() {
            return this.schemaURL;
        }

        public StaticDataset getDataset() {
            return this.dataset;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder(value={"_producer", "_schemaURL"})
    public static final class OutputDatasetFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public OutputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted"})
    public static final class DatasetFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this._deleted = null;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Boolean get_deleted() {
            return this._deleted;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder
    public static final class InputDatasetInputFacets {
        @JsonAnySetter
        private final Map<String, InputDatasetFacet> additionalProperties = new LinkedHashMap<String, InputDatasetFacet>();

        @JsonCreator
        public InputDatasetInputFacets() {
        }

        @JsonAnyGetter
        public Map<String, InputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonPropertyOrder
    public static final class JobFacets {
        @JsonAnySetter
        private final Map<String, JobFacet> additionalProperties = new LinkedHashMap<String, JobFacet>();

        @JsonCreator
        public JobFacets() {
        }

        @JsonAnyGetter
        public Map<String, JobFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static interface BaseEvent {
        public ZonedDateTime getEventTime();

        public URI getProducer();

        public URI getSchemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonPropertyOrder(value={"eventTime", "producer", "schemaURL", "eventType", "run", "job", "inputs", "outputs"})
    public static final class RunEvent
    implements BaseEvent {
        private final ZonedDateTime eventTime;
        private final URI producer;
        private final URI schemaURL;
        private final EventType eventType;
        private final Run run;
        private final Job job;
        private final List<InputDataset> inputs;
        private final List<OutputDataset> outputs;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public RunEvent(@JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="producer") URI producer, @JsonProperty(value="schemaURL") URI schemaURL, @JsonProperty(value="eventType") EventType eventType, @JsonProperty(value="run") Run run, @JsonProperty(value="job") Job job, @JsonProperty(value="inputs") List<InputDataset> inputs, @JsonProperty(value="outputs") List<OutputDataset> outputs) {
            this.eventTime = eventTime;
            this.producer = producer;
            this.schemaURL = schemaURL;
            this.eventType = eventType;
            this.run = run;
            this.job = job;
            this.inputs = inputs;
            this.outputs = outputs;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        @Override
        public URI getProducer() {
            return this.producer;
        }

        @Override
        public URI getSchemaURL() {
            return this.schemaURL;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public Run getRun() {
            return this.run;
        }

        public Job getJob() {
            return this.job;
        }

        public List<InputDataset> getInputs() {
            return this.inputs;
        }

        public List<OutputDataset> getOutputs() {
            return this.outputs;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }

        public static enum EventType {
            START,
            RUNNING,
            COMPLETE,
            ABORT,
            FAIL,
            OTHER;

        }
    }

    @JsonPropertyOrder
    public static final class RunFacets {
        @JsonAnySetter
        private final Map<String, RunFacet> additionalProperties = new LinkedHashMap<String, RunFacet>();

        @JsonCreator
        public RunFacets() {
        }

        @JsonAnyGetter
        public Map<String, RunFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static interface Builder<T> {
        public T build();
    }
}

