/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.LongConsumer;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.shade.org.roaringbitmap.RoaringBitmap;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RoaringBitmap32;

public class OptimizedRoaringBitmap64 {
    public static final long MAX_VALUE = OptimizedRoaringBitmap64.toPosition(0x7FFFFFFE, Integer.MIN_VALUE);
    private static final RoaringBitmap[] EMPTY_BITMAP_ARRAY = new RoaringBitmap[0];
    private static final long BITMAP_COUNT_SIZE_BYTES = 8L;
    private static final long BITMAP_KEY_SIZE_BYTES = 4L;
    private RoaringBitmap[] bitmaps;

    public OptimizedRoaringBitmap64() {
        this.bitmaps = EMPTY_BITMAP_ARRAY;
    }

    private OptimizedRoaringBitmap64(RoaringBitmap[] bitmaps) {
        this.bitmaps = bitmaps;
    }

    public static OptimizedRoaringBitmap64 fromRoaringBitmap32(RoaringBitmap32 roaringBitmap32) {
        RoaringBitmap roaringBitmap = roaringBitmap32.clone().get();
        return new OptimizedRoaringBitmap64(new RoaringBitmap[]{roaringBitmap});
    }

    public void add(long pos) {
        OptimizedRoaringBitmap64.validatePosition(pos);
        int key = OptimizedRoaringBitmap64.key(pos);
        int pos32Bits = OptimizedRoaringBitmap64.pos32Bits(pos);
        this.allocateBitmapsIfNeeded(key + 1);
        this.bitmaps[key].add(pos32Bits);
    }

    public void addRange(long posStartInclusive, long posEndExclusive) {
        for (long pos = posStartInclusive; pos < posEndExclusive; ++pos) {
            this.add(pos);
        }
    }

    public void or(OptimizedRoaringBitmap64 that) {
        this.allocateBitmapsIfNeeded(that.bitmaps.length);
        for (int key = 0; key < that.bitmaps.length; ++key) {
            this.bitmaps[key].or(that.bitmaps[key]);
        }
    }

    public boolean contains(long pos) {
        OptimizedRoaringBitmap64.validatePosition(pos);
        int key = OptimizedRoaringBitmap64.key(pos);
        int pos32Bits = OptimizedRoaringBitmap64.pos32Bits(pos);
        return key < this.bitmaps.length && this.bitmaps[key].contains(pos32Bits);
    }

    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public long cardinality() {
        long cardinality = 0L;
        for (RoaringBitmap bitmap : this.bitmaps) {
            cardinality += bitmap.getLongCardinality();
        }
        return cardinality;
    }

    public boolean runLengthEncode() {
        boolean changed = false;
        for (RoaringBitmap bitmap : this.bitmaps) {
            changed |= bitmap.runOptimize();
        }
        return changed;
    }

    public void forEach(LongConsumer consumer) {
        for (int key = 0; key < this.bitmaps.length; ++key) {
            OptimizedRoaringBitmap64.forEach(key, this.bitmaps[key], consumer);
        }
    }

    @VisibleForTesting
    int allocatedBitmapCount() {
        return this.bitmaps.length;
    }

    private void allocateBitmapsIfNeeded(int requiredLength) {
        if (this.bitmaps.length < requiredLength) {
            if (this.bitmaps.length == 0 && requiredLength == 1) {
                this.bitmaps = new RoaringBitmap[]{new RoaringBitmap()};
            } else {
                RoaringBitmap[] newBitmaps = new RoaringBitmap[requiredLength];
                System.arraycopy(this.bitmaps, 0, newBitmaps, 0, this.bitmaps.length);
                for (int key = this.bitmaps.length; key < requiredLength; ++key) {
                    newBitmaps[key] = new RoaringBitmap();
                }
                this.bitmaps = newBitmaps;
            }
        }
    }

    public long serializedSizeInBytes() {
        long size = 8L;
        for (RoaringBitmap bitmap : this.bitmaps) {
            size += 4L + (long)bitmap.serializedSizeInBytes();
        }
        return size;
    }

    public void serialize(ByteBuffer buffer) {
        OptimizedRoaringBitmap64.validateByteOrder(buffer);
        buffer.putLong(this.bitmaps.length);
        for (int key = 0; key < this.bitmaps.length; ++key) {
            buffer.putInt(key);
            this.bitmaps[key].serialize(buffer);
        }
    }

    public static OptimizedRoaringBitmap64 deserialize(ByteBuffer buffer) {
        int remainingBitmapCount;
        OptimizedRoaringBitmap64.validateByteOrder(buffer);
        ArrayList bitmaps = Lists.newArrayListWithExpectedSize((int)remainingBitmapCount);
        int lastKey = -1;
        for (remainingBitmapCount = OptimizedRoaringBitmap64.readBitmapCount(buffer); remainingBitmapCount > 0; --remainingBitmapCount) {
            int key = OptimizedRoaringBitmap64.readKey(buffer, lastKey);
            while (lastKey < key - 1) {
                bitmaps.add(new RoaringBitmap());
                ++lastKey;
            }
            RoaringBitmap bitmap = OptimizedRoaringBitmap64.readBitmap(buffer);
            bitmaps.add(bitmap);
            lastKey = key;
        }
        return new OptimizedRoaringBitmap64(bitmaps.toArray(EMPTY_BITMAP_ARRAY));
    }

    private static void validateByteOrder(ByteBuffer buffer) {
        Preconditions.checkArgument((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0, (Object)"Roaring bitmap serialization requires little-endian byte order");
    }

    private static int readBitmapCount(ByteBuffer buffer) {
        long bitmapCount = buffer.getLong();
        Preconditions.checkArgument((bitmapCount >= 0L && bitmapCount <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Invalid bitmap count: %s", (Object[])new Object[]{bitmapCount});
        return (int)bitmapCount;
    }

    private static int readKey(ByteBuffer buffer, int lastKey) {
        int key = buffer.getInt();
        Preconditions.checkArgument((key >= 0 ? 1 : 0) != 0, (String)"Invalid unsigned key: %s", (Object[])new Object[]{key});
        Preconditions.checkArgument((key <= 0x7FFFFFFE ? 1 : 0) != 0, (String)"Key is too large: %s", (Object[])new Object[]{key});
        Preconditions.checkArgument((key > lastKey ? 1 : 0) != 0, (Object)"Keys must be sorted in ascending order");
        return key;
    }

    private static RoaringBitmap readBitmap(ByteBuffer buffer) {
        try {
            RoaringBitmap bitmap = new RoaringBitmap();
            bitmap.deserialize(buffer);
            buffer.position(buffer.position() + bitmap.serializedSizeInBytes());
            return bitmap;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int key(long pos) {
        return (int)(pos >> 32);
    }

    private static int pos32Bits(long pos) {
        return (int)pos;
    }

    private static long toPosition(int key, int pos32Bits) {
        return (long)key << 32 | (long)pos32Bits & 0xFFFFFFFFL;
    }

    private static void forEach(int key, RoaringBitmap bitmap, LongConsumer consumer) {
        bitmap.forEach((int pos32Bits) -> consumer.accept(OptimizedRoaringBitmap64.toPosition(key, pos32Bits)));
    }

    private static void validatePosition(long pos) {
        Preconditions.checkArgument((pos >= 0L && pos <= MAX_VALUE ? 1 : 0) != 0, (String)"OptimizedRoaringBitmap64 supports positions that are >= 0 and <= %s: %s", (Object[])new Object[]{MAX_VALUE, pos});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizedRoaringBitmap64 that = (OptimizedRoaringBitmap64)o;
        return Arrays.equals(this.bitmaps, that.bitmaps);
    }
}

