/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import com.google.common.base.Throwables;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.gravitino.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PrincipalUtils.class);

    private PrincipalUtils() {
    }

    public static <T> T doAs(Principal principal, PrivilegedExceptionAction<T> action) throws Exception {
        try {
            Subject subject = new Subject();
            subject.getPrincipals().add(principal);
            return Subject.doAs(subject, action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            Throwables.propagateIfPossible((Throwable)cause, Exception.class);
            throw new RuntimeException("doAs method occurs an unexpected exception", pae);
        }
        catch (Error t) {
            LOG.warn("doAs method occurs an unexpected error", (Throwable)t);
            throw new RuntimeException("doAs method occurs an unexpected exception", t);
        }
    }

    public static Principal getCurrentPrincipal() {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        if (subject == null || subject.getPrincipals(UserPrincipal.class).isEmpty()) {
            return new UserPrincipal("anonymous");
        }
        return subject.getPrincipals(UserPrincipal.class).iterator().next();
    }

    public static String getCurrentUserName() {
        return PrincipalUtils.getCurrentPrincipal().getName();
    }
}

