/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.StringDigestUtil;

public class HashingNameMapper
implements NameMapper {
    private static final String CONFIG_PROP_DEPTH = "aether.syncContext.named.hashing.depth";
    private final NameMapper delegate;

    public HashingNameMapper(NameMapper delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public boolean isFileSystemFriendly() {
        return true;
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        int depth = ConfigUtils.getInteger(session, 2, CONFIG_PROP_DEPTH);
        if (depth < 0 || depth > 4) {
            throw new IllegalArgumentException("allowed depth value is between 0 and 4 (inclusive)");
        }
        return this.delegate.nameLocks(session, artifacts, metadatas).stream().map(n -> this.hashName((String)n, depth)).collect(Collectors.toList());
    }

    private String hashName(String name, int depth) {
        String hashedName = StringDigestUtil.sha1(name);
        if (depth == 0) {
            return hashedName;
        }
        StringBuilder prefix = new StringBuilder("");
        for (int i2 = 0; i2 < hashedName.length() && i2 / 2 < depth; i2 += 2) {
            prefix.append(hashedName, i2, i2 + 2).append("/");
        }
        return prefix.append(hashedName).toString();
    }
}

