/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.shaded.guava33.com.google.common.collect.ImmutableList;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableLogicalUnnestRule;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.functions.table.UnnestRowsFunctionBase;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.immutables.value.Value;

@Value.Enclosing
public class LogicalUnnestRule
extends RelRule<LogicalUnnestRuleConfig> {
    public static final LogicalUnnestRule INSTANCE = LogicalUnnestRuleConfig.DEFAULT.toRule();

    public LogicalUnnestRule(LogicalUnnestRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalCorrelate join = (LogicalCorrelate)call.rel(0);
        RelNode right = this.getRel(join.getRight());
        if (right instanceof LogicalFilter) {
            LogicalFilter logicalFilter = (LogicalFilter)right;
            RelNode relNode = this.getRel(logicalFilter.getInput());
            if (relNode instanceof Uncollect) {
                return true;
            }
            if (relNode instanceof LogicalProject) {
                LogicalProject logicalProject = (LogicalProject)relNode;
                relNode = this.getRel(logicalProject.getInput());
                return relNode instanceof Uncollect;
            }
        } else {
            if (right instanceof LogicalProject) {
                LogicalProject logicalProject = (LogicalProject)right;
                RelNode relNode = this.getRel(logicalProject.getInput());
                return relNode instanceof Uncollect;
            }
            return right instanceof Uncollect;
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
        RelNode outer = this.getRel(correlate.getLeft());
        RelNode array = this.getRel(correlate.getRight());
        RelNode tableFunctionScan = this.convert(array, correlate);
        RelNode newCorrelate = correlate.copy(correlate.getTraitSet(), (List)ImmutableList.of((Object)outer, (Object)tableFunctionScan));
        call.transformTo(newCorrelate);
    }

    private RelNode convert(RelNode relNode, LogicalCorrelate correlate) {
        if (relNode instanceof HepRelVertex) {
            HepRelVertex hepRelVertex = (HepRelVertex)relNode;
            relNode = this.convert(this.getRel(hepRelVertex), correlate);
        }
        if (relNode instanceof LogicalProject) {
            LogicalProject logicalProject = (LogicalProject)relNode;
            return logicalProject.copy(logicalProject.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)this.convert(this.getRel(logicalProject.getInput()), correlate)));
        }
        if (relNode instanceof LogicalFilter) {
            LogicalFilter logicalFilter = (LogicalFilter)relNode;
            return logicalFilter.copy(logicalFilter.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)this.convert(this.getRel(logicalFilter.getInput()), correlate)));
        }
        if (relNode instanceof Uncollect) {
            Uncollect uncollect = (Uncollect)relNode;
            RelOptCluster cluster = correlate.getCluster();
            FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(cluster);
            RelDataType relDataType = (RelDataType)((Map.Entry)uncollect.getInput().getRowType().getFieldList().get(0)).getValue();
            LogicalType logicalType = FlinkTypeFactory.toLogicalType(relDataType);
            BridgingSqlFunction sqlFunction = BridgingSqlFunction.of(cluster, uncollect.withOrdinality ? BuiltInFunctionDefinitions.INTERNAL_UNNEST_ROWS_WITH_ORDINALITY : BuiltInFunctionDefinitions.INTERNAL_UNNEST_ROWS);
            RexNode rexCall = cluster.getRexBuilder().makeCall(typeFactory.createFieldTypeFromLogicalType((LogicalType)LogicalTypeUtils.toRowType((LogicalType)UnnestRowsFunctionBase.getUnnestedType((LogicalType)logicalType, (boolean)uncollect.withOrdinality))), sqlFunction, ((LogicalProject)this.getRel(uncollect.getInput())).getProjects());
            return new LogicalTableFunctionScan(cluster, correlate.getTraitSet(), Collections.emptyList(), rexCall, null, rexCall.getType(), null);
        }
        throw new IllegalArgumentException("Unexpected input: " + String.valueOf(relNode));
    }

    private RelNode getRel(RelNode rel) {
        if (rel instanceof HepRelVertex) {
            return ((HepRelVertex)rel).getCurrentRel();
        }
        return rel;
    }

    @Value.Immutable(singleton=false)
    public static interface LogicalUnnestRuleConfig
    extends RelRule.Config {
        public static final LogicalUnnestRuleConfig DEFAULT = ImmutableLogicalUnnestRule.LogicalUnnestRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalCorrelate.class).anyInputs()).withDescription("LogicalUnnestRule");

        @Override
        default public LogicalUnnestRule toRule() {
            return new LogicalUnnestRule(this);
        }
    }
}

