/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ShuffleJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ShuffleJsonSerializer;

@Internal
@JsonIgnoreProperties(ignoreUnknown=true)
final class JsonPlanEdge {
    static final String FIELD_NAME_SOURCE = "source";
    static final String FIELD_NAME_TARGET = "target";
    static final String FIELD_NAME_SHUFFLE = "shuffle";
    static final String FIELD_NAME_SHUFFLE_MODE = "shuffleMode";
    @JsonProperty(value="source")
    private final int sourceId;
    @JsonProperty(value="target")
    private final int targetId;
    @JsonProperty(value="shuffle")
    @JsonSerialize(using=ShuffleJsonSerializer.class)
    @JsonDeserialize(using=ShuffleJsonDeserializer.class)
    private final ExecEdge.Shuffle shuffle;
    @JsonProperty(value="shuffleMode")
    private final StreamExchangeMode exchangeMode;

    @JsonCreator
    JsonPlanEdge(@JsonProperty(value="source") int sourceId, @JsonProperty(value="target") int targetId, @JsonProperty(value="shuffle") ExecEdge.Shuffle shuffle, @JsonProperty(value="shuffleMode") StreamExchangeMode exchangeMode) {
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.shuffle = shuffle;
        this.exchangeMode = exchangeMode;
    }

    int getSourceId() {
        return this.sourceId;
    }

    int getTargetId() {
        return this.targetId;
    }

    ExecEdge.Shuffle getShuffle() {
        return this.shuffle;
    }

    StreamExchangeMode getExchangeMode() {
        return this.exchangeMode;
    }

    static JsonPlanEdge fromExecEdge(ExecEdge execEdge) {
        return new JsonPlanEdge(execEdge.getSource().getId(), execEdge.getTarget().getId(), execEdge.getShuffle(), execEdge.getExchangeMode());
    }
}

