/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.ddl.SqlDistribution;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.ddl.position.SqlTableColumnPosition;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

public abstract class SchemaConverter {
    protected static final String EX_MSG_PREFIX = "Failed to execute ALTER TABLE statement.\n";
    protected List<String> sortedColumnNames = new ArrayList<String>();
    protected Set<String> alterColNames = new HashSet<String>();
    protected Map<String, Schema.UnresolvedColumn> columns = new HashMap<String, Schema.UnresolvedColumn>();
    @Nullable
    protected Schema.UnresolvedWatermarkSpec watermarkSpec = null;
    @Nullable
    protected TableDistribution distribution = null;
    @Nullable
    protected Schema.UnresolvedPrimaryKey primaryKey = null;
    protected Function<SqlNode, String> escapeExpressions;
    protected SqlNodeConverter.ConvertContext context;
    protected List<TableChange> changesCollector;
    protected List<Function<ResolvedSchema, List<TableChange>>> changeBuilders = new ArrayList<Function<ResolvedSchema, List<TableChange>>>();

    SchemaConverter(ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        this.changesCollector = new ArrayList<TableChange>();
        this.context = context;
        this.escapeExpressions = sqlNode -> OperationConverterUtils.getQuotedSqlString(sqlNode, context.getFlinkPlanner());
        Schema oldSchema = oldTable.getUnresolvedSchema();
        this.populateColumnsFromSourceTable(oldSchema);
        this.populatePrimaryKeyFromSourceTable(oldSchema);
        this.populateWatermarkFromSourceTable(oldSchema);
        this.populateDistributionFromSourceTable(oldTable);
    }

    public List<TableChange> getChangesCollector() {
        return this.changesCollector;
    }

    private void populateColumnsFromSourceTable(Schema oldSchema) {
        oldSchema.getColumns().forEach(column -> {
            String name = column.getName();
            this.sortedColumnNames.add(name);
            this.columns.put(name, (Schema.UnresolvedColumn)column);
        });
    }

    private void populatePrimaryKeyFromSourceTable(Schema oldSchema) {
        if (oldSchema.getPrimaryKey().isPresent()) {
            this.primaryKey = (Schema.UnresolvedPrimaryKey)oldSchema.getPrimaryKey().get();
        }
    }

    private void populateDistributionFromSourceTable(ResolvedCatalogTable oldTable) {
        oldTable.getDistribution().ifPresent(distribution -> {
            this.distribution = distribution;
        });
    }

    private void populateWatermarkFromSourceTable(Schema oldSchema) {
        Iterator iterator = oldSchema.getWatermarkSpecs().iterator();
        while (iterator.hasNext()) {
            Schema.UnresolvedWatermarkSpec sourceWatermarkSpec;
            this.watermarkSpec = sourceWatermarkSpec = (Schema.UnresolvedWatermarkSpec)iterator.next();
        }
    }

    public void updateColumn(List<SqlNode> alterColumnPositions) {
        this.applyColumnPosition(alterColumnPositions);
        for (SqlNode sqlNode : alterColumnPositions) {
            Schema.UnresolvedComputedColumn newColumn;
            SqlTableColumnPosition alterColumnPos = (SqlTableColumnPosition)sqlNode;
            SqlTableColumn alterColumn = alterColumnPos.getColumn();
            if (alterColumn instanceof SqlTableColumn.SqlComputedColumn) {
                newColumn = this.convertComputedColumn((SqlTableColumn.SqlComputedColumn)alterColumn);
            } else if (alterColumn instanceof SqlTableColumn.SqlMetadataColumn) {
                newColumn = this.convertMetadataColumn((SqlTableColumn.SqlMetadataColumn)alterColumn);
            } else if (alterColumn instanceof SqlTableColumn.SqlRegularColumn) {
                newColumn = this.convertPhysicalColumn((SqlTableColumn.SqlRegularColumn)alterColumn);
            } else {
                throw new UnsupportedOperationException(String.format("Unsupported sql table column class: %s", alterColumn.getClass().getCanonicalName()));
            }
            this.columns.put(newColumn.getName(), (Schema.UnresolvedColumn)newColumn);
        }
    }

    public void updatePrimaryKey(SqlTableConstraint alterPrimaryKey) {
        this.checkAndCollectPrimaryKeyChange();
        List<String> primaryKeyColumns = Arrays.asList(alterPrimaryKey.getColumnNames());
        this.primaryKey = new Schema.UnresolvedPrimaryKey(alterPrimaryKey.getConstraintName().orElseGet(() -> primaryKeyColumns.stream().collect(Collectors.joining("_", "PK_", ""))), primaryKeyColumns);
    }

    private void updatePrimaryKeyNullability(String columnName) {
        Schema.UnresolvedColumn column = this.columns.get(columnName);
        if (column instanceof Schema.UnresolvedPhysicalColumn) {
            AbstractDataType oldType = ((Schema.UnresolvedPhysicalColumn)column).getDataType();
            this.columns.put(columnName, (Schema.UnresolvedColumn)new Schema.UnresolvedPhysicalColumn(columnName, oldType.notNull(), (String)column.getComment().orElse(null)));
        }
    }

    public void updateWatermark(SqlWatermark alterWatermarkSpec) {
        this.checkAndCollectWatermarkChange();
        SqlIdentifier eventTimeColumnName = alterWatermarkSpec.getEventTimeColumnName();
        if (!eventTimeColumnName.isSimple()) {
            throw new ValidationException(String.format("%sWatermark strategy on nested column is not supported yet.", EX_MSG_PREFIX));
        }
        this.watermarkSpec = new Schema.UnresolvedWatermarkSpec(eventTimeColumnName.getSimple(), (Expression)new SqlCallExpression(this.escapeExpressions.apply(alterWatermarkSpec.getWatermarkStrategy())));
    }

    public void updateDistribution(SqlDistribution distribution) {
        TableDistribution tableDistribution = OperationConverterUtils.getDistributionFromSqlDistribution(distribution);
        this.checkAndCollectDistributionChange(tableDistribution);
        this.distribution = OperationConverterUtils.getDistributionFromSqlDistribution(distribution);
    }

    private Schema.UnresolvedPhysicalColumn convertPhysicalColumn(SqlTableColumn.SqlRegularColumn physicalColumn) {
        DataType dataType = this.getDataType(physicalColumn.getType());
        return new Schema.UnresolvedPhysicalColumn(physicalColumn.getName().getSimple(), (AbstractDataType)dataType, this.getComment(physicalColumn));
    }

    private Schema.UnresolvedMetadataColumn convertMetadataColumn(SqlTableColumn.SqlMetadataColumn metadataColumn) {
        DataType dataType = this.getDataType(metadataColumn.getType());
        return new Schema.UnresolvedMetadataColumn(metadataColumn.getName().getSimple(), (AbstractDataType)dataType, (String)metadataColumn.getMetadataAlias().orElse(null), metadataColumn.isVirtual(), this.getComment(metadataColumn));
    }

    private Schema.UnresolvedComputedColumn convertComputedColumn(SqlTableColumn.SqlComputedColumn column) {
        return new Schema.UnresolvedComputedColumn(column.getName().getSimple(), (Expression)new SqlCallExpression(this.escapeExpressions.apply(column.getExpr())), this.getComment(column));
    }

    private DataType getDataType(SqlDataTypeSpec typeSpec) {
        RelDataType relType = typeSpec.deriveType(this.context.getSqlValidator(), typeSpec.getNullable() == null || typeSpec.getNullable() != false);
        return TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory.toLogicalType(relType));
    }

    @Nullable
    protected String getComment(SqlTableColumn column) {
        return OperationConverterUtils.getComment(column);
    }

    private void applyColumnPosition(List<SqlNode> alterColumns) {
        for (SqlNode alterColumn : alterColumns) {
            SqlTableColumnPosition columnPosition = (SqlTableColumnPosition)alterColumn;
            SqlTableColumn column = columnPosition.getColumn();
            String columnName = SchemaConverter.getColumnName(column.getName());
            if (!this.alterColNames.add(columnName)) {
                throw new ValidationException(String.format("%sEncounter duplicate column `%s`.", EX_MSG_PREFIX, columnName));
            }
            this.updatePositionAndCollectColumnChange(columnPosition, columnName);
        }
    }

    protected String getReferencedColumn(SqlTableColumnPosition columnPosition) {
        SqlIdentifier referencedIdent = columnPosition.getAfterReferencedColumn();
        Preconditions.checkNotNull((Object)referencedIdent, (String)String.format("%sCould not refer to a null column", EX_MSG_PREFIX));
        if (!referencedIdent.isSimple()) {
            throw new UnsupportedOperationException(String.format("%sAlter nested row type is not supported yet.", EX_MSG_PREFIX));
        }
        String referencedName = referencedIdent.getSimple();
        if (!this.sortedColumnNames.contains(referencedName)) {
            throw new ValidationException(String.format("%sReferenced column `%s` by 'AFTER' does not exist in the table.", EX_MSG_PREFIX, referencedName));
        }
        return referencedName;
    }

    public Schema convert() {
        Schema.Builder resultBuilder = Schema.newBuilder();
        if (this.primaryKey != null) {
            String constraintName = this.primaryKey.getConstraintName();
            List pkColumns = this.primaryKey.getColumnNames();
            pkColumns.forEach(this::updatePrimaryKeyNullability);
            if (constraintName != null) {
                resultBuilder.primaryKeyNamed(constraintName, pkColumns);
            } else {
                resultBuilder.primaryKey(pkColumns);
            }
        }
        ArrayList<Schema.UnresolvedColumn> newColumns = new ArrayList<Schema.UnresolvedColumn>();
        for (String column : this.sortedColumnNames) {
            newColumns.add(this.columns.get(column));
        }
        resultBuilder.fromColumns(newColumns);
        if (this.watermarkSpec != null) {
            resultBuilder.watermark(this.watermarkSpec.getColumnName(), this.watermarkSpec.getWatermarkExpression());
        }
        Schema updatedSchema = resultBuilder.build();
        try {
            ResolvedSchema resolvedSchema = this.context.getCatalogManager().getSchemaResolver().resolve(updatedSchema);
            this.changesCollector.addAll(this.changeBuilders.stream().flatMap(changeBuilder -> ((List)changeBuilder.apply(resolvedSchema)).stream()).collect(Collectors.toList()));
            return updatedSchema;
        }
        catch (Exception e) {
            throw new ValidationException(String.format("%s%s", EX_MSG_PREFIX, e.getMessage()), (Throwable)e);
        }
    }

    protected abstract void updatePositionAndCollectColumnChange(SqlTableColumnPosition var1, String var2);

    protected abstract void checkAndCollectPrimaryKeyChange();

    protected abstract void checkAndCollectDistributionChange(TableDistribution var1);

    protected abstract void checkAndCollectWatermarkChange();

    protected static String getColumnName(SqlIdentifier identifier) {
        if (!identifier.isSimple()) {
            throw new UnsupportedOperationException(String.format("%sAlter nested row type %s is not supported yet.", EX_MSG_PREFIX, identifier));
        }
        return identifier.getSimple();
    }

    protected <T> T unwrap(Optional<T> value) {
        return value.orElseThrow(() -> new TableException("The value should never be empty."));
    }
}

