/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.runtime.scheduler.adaptivebatch.BatchExecutionOptionsInternal;
import org.apache.flink.runtime.scheduler.adaptivebatch.StreamGraphOptimizationStrategy;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ExplainFormat;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.InternalPlan;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.processor.AdaptiveJoinProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.DeadlockBreakupProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.DynamicFilteringDependencyProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ForwardHashExchangeProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.MultipleInputNodeCreationProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;
import org.apache.flink.table.planner.plan.optimize.BatchCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import org.apache.flink.table.runtime.strategy.AdaptiveBroadcastJoinOptimizationStrategy;
import org.apache.flink.table.runtime.strategy.AdaptiveSkewedJoinOptimizationStrategy;
import org.apache.flink.table.runtime.strategy.PostProcessAdaptiveJoinStrategy;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\t\u0013\u0001}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!I\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u000f\u0005\ns\u0001\u0011\t\u0011)A\u0005u\u0001C\u0011\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ#\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dCQa\u0014\u0001\u0005\u0002ACQ\u0001\u0017\u0001\u0005ReCQ\u0001\u001e\u0001\u0005RUDQ! \u0001\u0005ByDq!a\u000b\u0001\t#\ni\u0003C\u0004\u0002f\u0001!\t%a\u001a\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r!9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBAY\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003\u007f\u0003A\u0011IA4\u00051\u0011\u0015\r^2i!2\fgN\\3s\u0015\t\u0019B#\u0001\u0006eK2,w-\u0019;j_:T!!\u0006\f\u0002\u000fAd\u0017M\u001c8fe*\u0011q\u0003G\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00033i\tQA\u001a7j].T!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO\u000e\u00011C\u0001\u0001!!\t\t#%D\u0001\u0013\u0013\t\u0019#CA\u0006QY\u0006tg.\u001a:CCN,\u0017\u0001C3yK\u000e,Ho\u001c:\u0011\u0005\u0019BS\"A\u0014\u000b\u0005M1\u0012BA\u0015(\u0005!)\u00050Z2vi>\u0014\u0018a\u0003;bE2,7i\u001c8gS\u001e\u0004\"\u0001L\u0018\u000e\u00035R!A\f\f\u0002\u0007\u0005\u0004\u0018.\u0003\u00021[\tYA+\u00192mK\u000e{gNZ5h\u00035iw\u000eZ;mK6\u000bg.Y4feB\u00111GN\u0007\u0002i)\u0011QGF\u0001\u0007[>$W\u000f\\3\n\u0005]\"$!D'pIVdW-T1oC\u001e,'/\u0003\u00022E\u0005ya-\u001e8di&|gnQ1uC2|w\r\u0005\u0002<}5\tAH\u0003\u0002>-\u000591-\u0019;bY><\u0017BA =\u0005=1UO\\2uS>t7)\u0019;bY><\u0017BA\u001d#\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ\u0004\"aO\"\n\u0005\u0011c$AD\"bi\u0006dwnZ'b]\u0006<WM]\u0005\u0003\u0003\n\n1b\u00197bgNdu.\u00193feB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0005Y\u0006twMC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%aC\"mCN\u001cHj\\1eKJ\fa\u0001P5oSRtDcB)S'R+fk\u0016\t\u0003C\u0001AQ\u0001J\u0004A\u0002\u0015BQAK\u0004A\u0002-BQ!M\u0004A\u0002IBQ!O\u0004A\u0002iBQ!Q\u0004A\u0002\tCQAR\u0004A\u0002\u001d\u000bAbZ3u)J\f\u0017\u000e\u001e#fMN,\u0012A\u0017\t\u00047z\u0003W\"\u0001/\u000b\u0003u\u000bQa]2bY\u0006L!a\u0018/\u0003\u000b\u0005\u0013(/Y=1\u0005\u0005\\\u0007c\u00012hS6\t1M\u0003\u0002eK\u0006!\u0001\u000f\\1o\u0015\t1'$A\u0004dC2\u001c\u0017\u000e^3\n\u0005!\u001c'a\u0003*fYR\u0013\u0018-\u001b;EK\u001a\u0004\"A[6\r\u0001\u0011IA\u000eCA\u0001\u0002\u0003\u0015\t!\u001c\u0002\u0004?\u0012\n\u0014C\u00018r!\tYv.\u0003\u0002q9\n9aj\u001c;iS:<\u0007C\u00012s\u0013\t\u00198M\u0001\u0005SK2$&/Y5u\u000319W\r^(qi&l\u0017N_3s+\u00051\bCA<|\u001b\u0005A(BA={\u0003!y\u0007\u000f^5nSj,'B\u00013\u0015\u0013\ta\bPA\u0005PaRLW.\u001b>fe\u0006Qr-\u001a;Fq\u0016\u001cgj\u001c3f\u000fJ\f\u0007\u000f\u001b)s_\u000e,7o]8sgV\tq\u0010\u0005\u0004\u0002\u0002\u0005E\u0011q\u0003\b\u0005\u0003\u0007\tiA\u0004\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIAH\u0001\u0007yI|w\u000e\u001e \n\u0003uK1!a\u0004]\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0005\u0002\u0016\t\u00191+Z9\u000b\u0007\u0005=A\f\u0005\u0003\u0002\u001a\u0005\u001dRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0013A\u0014xnY3tg>\u0014(\u0002BA\u0011\u0003G\tA!\u001a=fG*\u0019\u0011Q\u0005>\u0002\u000b9|G-Z:\n\t\u0005%\u00121\u0004\u0002\u0017\u000bb,7MT8eK\u001e\u0013\u0018\r\u001d5Qe>\u001cWm]:pe\u0006yAO]1og2\fG/\u001a+p!2\fg\u000e\u0006\u0003\u00020\u0005e\u0003CBA\u0019\u0003o\tY$\u0004\u0002\u00024)\u0019\u0011QG&\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003s\t\u0019D\u0001\u0003MSN$\b\u0007BA\u001f\u0003\u001b\u0002b!a\u0010\u0002H\u0005-SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0007\u0011\fwM\u0003\u0002/1%!\u0011\u0011JA!\u00059!&/\u00198tM>\u0014X.\u0019;j_:\u00042A[A'\t-\tyeCA\u0001\u0002\u0003\u0015\t!!\u0015\u0003\u0007}##'E\u0002o\u0003'\u00022aWA+\u0013\r\t9\u0006\u0018\u0002\u0004\u0003:L\bbBA.\u0017\u0001\u0007\u0011QL\u0001\nKb,7m\u0012:ba\"\u0004B!a\u0018\u0002b5\u0011\u0011qD\u0005\u0005\u0003G\nyBA\u0007Fq\u0016\u001cgj\u001c3f\u000fJ\f\u0007\u000f[\u0001\u0011C\u001a$XM\u001d+sC:\u001cH.\u0019;j_:$\"!!\u001b\u0011\u0007m\u000bY'C\u0002\u0002nq\u0013A!\u00168ji\u00069Q\r\u001f9mC&tG\u0003CA:\u0003\u0007\u000b\u0019*!(\u0011\t\u0005U\u0014Q\u0010\b\u0005\u0003o\nI\bE\u0002\u0002\u0006qK1!a\u001f]\u0003\u0019\u0001&/\u001a3fM&!\u0011qPAA\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0010/\t\u000f\u0005\u0015U\u00021\u0001\u0002\b\u0006Qq\u000e]3sCRLwN\\:\u0011\r\u0005E\u0012qGAE!\u0011\tY)a$\u000e\u0005\u00055%bAAC-%!\u0011\u0011SAG\u0005%y\u0005/\u001a:bi&|g\u000eC\u0004\u0002\u00166\u0001\r!a&\u0002\r\u0019|'/\\1u!\ra\u0013\u0011T\u0005\u0004\u00037k#!D#ya2\f\u0017N\u001c$pe6\fG\u000fC\u0004\u0002 6\u0001\r!!)\u0002\u0019\u0015DHO]1EKR\f\u0017\u000e\\:\u0011\u000bm\u000b\u0019+a*\n\u0007\u0005\u0015FL\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u00022\u0001LAU\u0013\r\tY+\f\u0002\u000e\u000bb\u0004H.Y5o\t\u0016$\u0018-\u001b7\u0002%\r\u0014X-\u0019;f\tVlW.\u001f)mC:tWM\u001d\u000b\u0002#\u0006YQ\r\u001f9mC&t\u0007\u000b\\1o)\u0019\t\u0019(!.\u0002>\"1Am\u0004a\u0001\u0003o\u00032AJA]\u0013\r\tYl\n\u0002\r\u0013:$XM\u001d8bYBc\u0017M\u001c\u0005\b\u0003?{\u0001\u0019AAQ\u0003E\u0011WMZ8sKR\u0013\u0018M\\:mCRLwN\u001c")
public class BatchPlanner
extends PlannerBase {
    private final TableConfig tableConfig;
    private final ClassLoader classLoader;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), RelCollationTraitDef.INSTANCE});
    }

    @Override
    public Optimizer getOptimizer() {
        return new BatchCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors() {
        ArrayList<ExecNodeGraphProcessor> processors = new ArrayList<ExecNodeGraphProcessor>();
        processors.add(new DeadlockBreakupProcessor());
        Object object = Predef$.MODULE$.Boolean2boolean((Boolean)this.getTableConfig().get(OptimizerConfigOptions.TABLE_OPTIMIZER_DYNAMIC_FILTERING_ENABLED)) ? BoxesRunTime.boxToBoolean((boolean)processors.add(new DynamicFilteringDependencyProcessor())) : BoxedUnit.UNIT;
        Object object2 = Predef$.MODULE$.Boolean2boolean((Boolean)this.getTableConfig().get(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED)) ? BoxesRunTime.boxToBoolean((boolean)processors.add(new MultipleInputNodeCreationProcessor(false))) : BoxedUnit.UNIT;
        processors.add(new ForwardHashExchangeProcessor());
        processors.add(new AdaptiveJoinProcessor());
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(processors);
    }

    @Override
    public List<Transformation<?>> translateToPlan(ExecNodeGraph execGraph) {
        this.beforeTranslation();
        BatchPlanner planner = this.createDummyPlanner();
        Buffer transformations = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execGraph.getRootNodes()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecNode execNode = x0$1;
            if (execNode instanceof BatchExecNode) {
                BatchExecNode batchExecNode = (BatchExecNode)execNode;
                return batchExecNode.translateToPlan(planner);
            }
            throw new TableException("Cannot generate BoundedStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
        }, Buffer$.MODULE$.canBuildFrom());
        this.afterTranslation();
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(transformations.$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(planner.extraTransformations())));
    }

    @Override
    public void afterTranslation() {
        BoxedUnit boxedUnit;
        super.afterTranslation();
        TableConfig configuration = this.getTableConfig();
        ArrayList<String> optimizationStrategies = new ArrayList<String>();
        Object object = configuration.get(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_BROADCAST_JOIN_STRATEGY);
        OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy adaptiveBroadcastJoinStrategy = OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy.NONE;
        boolean isAdaptiveBroadcastJoinEnabled = object == null ? adaptiveBroadcastJoinStrategy != null : !object.equals(adaptiveBroadcastJoinStrategy);
        Object object2 = configuration.get(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_STRATEGY);
        OptimizerConfigOptions.AdaptiveSkewedJoinOptimizationStrategy adaptiveSkewedJoinOptimizationStrategy = OptimizerConfigOptions.AdaptiveSkewedJoinOptimizationStrategy.NONE;
        boolean isAdaptiveSkewedJoinEnabled = object2 == null ? adaptiveSkewedJoinOptimizationStrategy != null : !object2.equals(adaptiveSkewedJoinOptimizationStrategy);
        Object object3 = isAdaptiveBroadcastJoinEnabled ? BoxesRunTime.boxToBoolean((boolean)optimizationStrategies.add(AdaptiveBroadcastJoinOptimizationStrategy.class.getName())) : BoxedUnit.UNIT;
        if (isAdaptiveSkewedJoinEnabled) {
            optimizationStrategies.add(AdaptiveSkewedJoinOptimizationStrategy.class.getName());
            configuration.set(BatchExecutionOptionsInternal.ADAPTIVE_SKEWED_OPTIMIZATION_SKEWED_FACTOR, configuration.get(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_SKEWED_FACTOR));
            boxedUnit = configuration.set(BatchExecutionOptionsInternal.ADAPTIVE_SKEWED_OPTIMIZATION_SKEWED_THRESHOLD, configuration.get(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_SKEWED_THRESHOLD));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object4 = isAdaptiveBroadcastJoinEnabled || isAdaptiveSkewedJoinEnabled ? BoxesRunTime.boxToBoolean((boolean)optimizationStrategies.add(PostProcessAdaptiveJoinStrategy.class.getName())) : BoxedUnit.UNIT;
        configuration.set(StreamGraphOptimizationStrategy.STREAM_GRAPH_OPTIMIZATION_STRATEGY, optimizationStrategies);
    }

    public String explain(List<Operation> operations, ExplainFormat format, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        ExplainFormat explainFormat = format;
        ExplainFormat explainFormat2 = ExplainFormat.TEXT;
        if (explainFormat == null ? explainFormat2 != null : !explainFormat.equals(explainFormat2)) {
            throw new UnsupportedOperationException(new java.lang.StringBuilder(29).append("Unsupported explain format [").append(format.getClass().getCanonicalName()).append("]").toString());
        }
        if (extraDetails.contains((Object)ExplainDetail.PLAN_ADVICE)) {
            throw new UnsupportedOperationException("EXPLAIN PLAN_ADVICE is not supported under batch mode.");
        }
        Tuple4<Buffer<RelNode>, Seq<RelNode>, ExecNodeGraph, StreamGraph> tuple4 = this.getExplainGraphs(operations);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Buffer sinkRelNodes = (Buffer)tuple4._1();
        Seq optimizedRelNodes = (Seq)tuple4._2();
        ExecNodeGraph execGraph = (ExecNodeGraph)tuple4._3();
        StreamGraph streamGraph = (StreamGraph)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)sinkRelNodes, (Object)optimizedRelNodes, (Object)execGraph, (Object)streamGraph);
        Buffer sinkRelNodes2 = (Buffer)tuple42._1();
        Seq optimizedRelNodes2 = (Seq)tuple42._2();
        ExecNodeGraph execGraph2 = (ExecNodeGraph)tuple42._3();
        StreamGraph streamGraph2 = (StreamGraph)tuple42._4();
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes2.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7(), FlinkRelOptUtil$.MODULE$.toString$default$8()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Physical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        optimizedRelNodes2.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)rel, explainLevel, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7(), FlinkRelOptUtil$.MODULE$.toString$default$8()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph2));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph2.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private BatchPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        DefaultExecutor executor = new DefaultExecutor(dummyExecEnv);
        return new BatchPlanner(executor, this.tableConfig, super.moduleManager(), super.functionCatalog(), super.catalogManager(), this.classLoader);
    }

    public String explainPlan(InternalPlan plan, Seq<ExplainDetail> extraDetails) {
        throw new UnsupportedOperationException("The compiled plan feature is not supported in batch mode.");
    }

    @Override
    public void beforeTranslation() {
        RuntimeExecutionMode runtimeMode;
        super.beforeTranslation();
        RuntimeExecutionMode runtimeExecutionMode = runtimeMode = (RuntimeExecutionMode)this.getTableConfig().get(ExecutionOptions.RUNTIME_MODE);
        RuntimeExecutionMode runtimeExecutionMode2 = RuntimeExecutionMode.BATCH;
        if (runtimeExecutionMode == null ? runtimeExecutionMode2 != null : !runtimeExecutionMode.equals(runtimeExecutionMode2)) {
            throw new IllegalArgumentException("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        }
    }

    public String explainPlan(InternalPlan plan, ExplainDetail[] extraDetails) {
        return this.explainPlan(plan, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public String explain(List<Operation> operations, ExplainFormat format, ExplainDetail[] extraDetails) {
        return this.explain(operations, format, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public BatchPlanner(Executor executor, TableConfig tableConfig, ModuleManager moduleManager, FunctionCatalog functionCatalog, CatalogManager catalogManager, ClassLoader classLoader) {
        this.tableConfig = tableConfig;
        this.classLoader = classLoader;
        super(executor, tableConfig, moduleManager, functionCatalog, catalogManager, false, classLoader);
    }
}

