/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.planner.calcite.FlinkSqlCallBinding;
import org.apache.flink.table.planner.functions.sql.ml.SqlMLTableFunction;

@Internal
public final class ProcedureNamespace
extends AbstractNamespace {
    private final SqlValidatorScope scope;
    private final SqlCall call;

    ProcedureNamespace(SqlValidatorImpl validator, SqlValidatorScope scope, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.scope = scope;
        this.call = call;
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.inferUnknownTypes(this.validator.unknownType, this.scope, this.call);
        SqlOperator operator = this.call.getOperator();
        FlinkSqlCallBinding callBinding = new FlinkSqlCallBinding(this.validator, this.scope, this.call);
        SqlCall permutedCall = callBinding.permutedCall();
        if (operator instanceof SqlWindowTableFunction || operator instanceof SqlMLTableFunction) {
            permutedCall.validate(this.validator, this.scope);
        }
        this.validator.deriveTypeImpl(this.scope, permutedCall);
        if (!(operator instanceof SqlTableFunction)) {
            throw new IllegalArgumentException("Argument must be a table function: " + String.valueOf(operator.getNameAsId()));
        }
        SqlTableFunction tableFunction = (SqlTableFunction)((Object)operator);
        SqlReturnTypeInference rowTypeInference = tableFunction.getRowTypeInference();
        return Objects.requireNonNull(rowTypeInference.inferReturnType(callBinding), () -> "got null from inferReturnType for call " + String.valueOf(callBinding.getCall()));
    }

    @Override
    public SqlNode getNode() {
        return this.call;
    }
}

