/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.KeyedMultipleInputTransformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexTableArgCall;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.planner.codegen.HashCodeGenerator;
import org.apache.flink.table.planner.codegen.ProcessTableRunnerGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.utils.TransformationMetadata;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalProcessTableFunction;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.GeneratedProcessTableRunner;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.process.ProcessTableOperatorFactory;
import org.apache.flink.table.runtime.operators.process.RuntimeChangelogMode;
import org.apache.flink.table.runtime.operators.process.RuntimeStateInfo;
import org.apache.flink.table.runtime.operators.process.RuntimeTableSemantics;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.StaticArgumentTrait;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@ExecNodeMetadata(name="stream-exec-process-table-function", version=1, producedTransformations={"process"}, minPlanVersion=FlinkVersion.v2_1, minStateVersion=FlinkVersion.v2_1)
public class StreamExecProcessTableFunction
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String PROCESS_TRANSFORMATION = "process";
    public static final String FIELD_NAME_UID = "uid";
    public static final String FIELD_NAME_FUNCTION_CALL = "functionCall";
    public static final String FIELD_NAME_INPUT_CHANGELOG_MODES = "inputChangelogModes";
    public static final String FIELD_NAME_OUTPUT_CHANGELOG_MODE = "outputChangelogMode";
    @JsonProperty(value="uid")
    private final @Nullable String uid;
    @JsonProperty(value="functionCall")
    private final RexCall invocation;
    @JsonProperty(value="inputChangelogModes")
    private final List<ChangelogMode> inputChangelogModes;
    @JsonProperty(value="outputChangelogMode")
    private final ChangelogMode outputChangelogMode;

    public StreamExecProcessTableFunction(ReadableConfig tableConfig, List<InputProperty> inputProperties, RowType outputType, String description, @Nullable String uid, RexCall invocation, List<ChangelogMode> inputChangelogModes, ChangelogMode outputChangelogMode) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecProcessTableFunction.class), ExecNodeContext.newPersistedConfig(StreamExecProcessTableFunction.class, tableConfig), inputProperties, outputType, description, uid, invocation, inputChangelogModes, outputChangelogMode);
    }

    @JsonCreator
    public StreamExecProcessTableFunction(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description, @JsonProperty(value="uid") @Nullable String uid, @JsonProperty(value="functionCall") RexNode invocation, @JsonProperty(value="inputChangelogModes") List<ChangelogMode> inputChangelogModes, @JsonProperty(value="outputChangelogMode") ChangelogMode outputChangelogMode) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.uid = uid;
        this.invocation = (RexCall)invocation;
        this.inputChangelogModes = inputChangelogModes;
        this.outputChangelogMode = outputChangelogMode;
    }

    public @Nullable String getUid() {
        return this.uid;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        List<Transformation<RowData>> inputTransforms = this.getInputEdges().stream().map(e -> e.translateToPlan(planner)).collect(Collectors.toList());
        List<Ord<StaticArgument>> providedInputArgs = StreamPhysicalProcessTableFunction.getProvidedInputArgs(this.invocation);
        List<RexNode> operands = this.invocation.getOperands();
        List<Integer> inputTimeColumns = StreamPhysicalProcessTableFunction.toInputTimeColumns(this.invocation);
        List<RuntimeTableSemantics> runtimeTableSemantics = providedInputArgs.stream().map(providedInputArg -> {
            RexTableArgCall tableArgCall = (RexTableArgCall)operands.get(providedInputArg.i);
            StaticArgument tableArg = (StaticArgument)providedInputArg.e;
            return this.createRuntimeTableSemantics(tableArg, tableArgCall, inputTimeColumns);
        }).collect(Collectors.toList());
        CodeGeneratorContext ctx = new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader());
        RexCall udfCall = StreamPhysicalProcessTableFunction.toUdfCall(this.invocation);
        ProcessTableRunnerGenerator.GeneratedRunnerResult generated = ProcessTableRunnerGenerator.generate(ctx, udfCall, inputTimeColumns, this.inputChangelogModes, this.outputChangelogMode);
        GeneratedProcessTableRunner generatedRunner = generated.runner();
        LinkedHashMap<String, TypeInferenceUtil.StateInfo> stateInfos = generated.stateInfos();
        List runtimeStateInfos = stateInfos.entrySet().stream().map(stateInfo -> StreamExecProcessTableFunction.createRuntimeStateInfo((String)stateInfo.getKey(), (TypeInferenceUtil.StateInfo)stateInfo.getValue(), config)).collect(Collectors.toList());
        GeneratedHashFunction[] stateHashCode = (GeneratedHashFunction[])runtimeStateInfos.stream().map(RuntimeStateInfo::getDataType).map(DataType::getLogicalType).map(t -> HashCodeGenerator.generateRowHash(ctx, t, "StateHashCode", IntStream.range(0, LogicalTypeChecks.getFieldCount((LogicalType)t)).toArray())).toArray(GeneratedHashFunction[]::new);
        GeneratedRecordEqualiser[] stateEquals = (GeneratedRecordEqualiser[])runtimeStateInfos.stream().map(RuntimeStateInfo::getDataType).map(DataType::getLogicalType).map(t -> EqualiserCodeGenerator.generateRowEquals(ctx, t, "StateEquals")).toArray(GeneratedRecordEqualiser[]::new);
        RuntimeChangelogMode producedChangelogMode = RuntimeChangelogMode.serialize((ChangelogMode)this.outputChangelogMode);
        ProcessTableOperatorFactory operatorFactory = new ProcessTableOperatorFactory(runtimeTableSemantics, runtimeStateInfos, generatedRunner, stateHashCode, stateEquals, producedChangelogMode);
        String effectiveUid = this.uid != null ? this.uid : this.createTransformationUid(PROCESS_TRANSFORMATION, config);
        TransformationMetadata metadata = new TransformationMetadata(effectiveUid, this.createTransformationName(config), this.createTransformationDescription(config));
        Transformation<RowData> transform = runtimeTableSemantics.stream().anyMatch(RuntimeTableSemantics::hasSetSemantics) ? this.createKeyedTransformation(inputTransforms, metadata, operatorFactory, planner, runtimeTableSemantics) : this.createNonKeyedTransformation(inputTransforms, metadata, operatorFactory);
        if (this.inputsContainSingleton()) {
            transform.setParallelism(1);
            transform.setMaxParallelism(1);
        }
        return transform;
    }

    private RuntimeTableSemantics createRuntimeTableSemantics(StaticArgument tableArg, RexTableArgCall tableArgCall, List<Integer> inputTimeColumns) {
        RuntimeChangelogMode consumedChangelogMode = RuntimeChangelogMode.serialize((ChangelogMode)this.inputChangelogModes.get(tableArgCall.getInputIndex()));
        DataType dataType = tableArg.getDataType().isPresent() ? (DataType)tableArg.getDataType().get() : DataTypes.of((LogicalType)FlinkTypeFactory.toLogicalRowType(tableArgCall.type));
        int timeColumn = inputTimeColumns.get(tableArgCall.getInputIndex());
        return new RuntimeTableSemantics(tableArg.getName(), tableArgCall.getInputIndex(), dataType, tableArgCall.getPartitionKeys(), consumedChangelogMode, tableArg.is(StaticArgumentTrait.PASS_COLUMNS_THROUGH), tableArg.is(StaticArgumentTrait.SET_SEMANTIC_TABLE), timeColumn);
    }

    private Transformation<RowData> createKeyedTransformation(List<Transformation<RowData>> inputTransforms, TransformationMetadata metadata, ProcessTableOperatorFactory operatorFactory, PlannerBase planner, List<RuntimeTableSemantics> runtimeTableSemantics) {
        assert (runtimeTableSemantics.size() == inputTransforms.size());
        List keySelectors = runtimeTableSemantics.stream().map(inputSemantics -> KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), inputSemantics.partitionByColumns(), (InternalTypeInfo<RowData>)((InternalTypeInfo)((Transformation)inputTransforms.get(inputSemantics.getInputIndex())).getOutputType()))).collect(Collectors.toList());
        KeyedMultipleInputTransformation transform = ExecNodeUtil.createKeyedMultiInputTransformation(inputTransforms, keySelectors, ((RowDataKeySelector)keySelectors.get(0)).getProducedType(), metadata, operatorFactory, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransforms.get(0).getParallelism(), false);
        transform.setChainingStrategy(ChainingStrategy.HEAD_WITH_SOURCES);
        return transform;
    }

    private Transformation<RowData> createNonKeyedTransformation(List<Transformation<RowData>> inputTransforms, TransformationMetadata metadata, ProcessTableOperatorFactory operatorFactory) {
        Transformation<RowData> inputTransform = inputTransforms.get(0);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, metadata, operatorFactory, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), false);
    }

    private static RuntimeStateInfo createRuntimeStateInfo(String name, TypeInferenceUtil.StateInfo stateInfo, ExecNodeConfig config) {
        return new RuntimeStateInfo(name, stateInfo.getDataType(), StreamExecProcessTableFunction.deriveStateTimeToLive(stateInfo.getTimeToLive().orElse(null), config.getStateRetentionTime()));
    }

    private static long deriveStateTimeToLive(@Nullable Duration declaration, long globalRetentionTime) {
        if (declaration != null) {
            return declaration.toMillis();
        }
        if (globalRetentionTime == 0L) {
            return Long.MAX_VALUE;
        }
        return globalRetentionTime;
    }
}

