package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.BuyDownFeeAmortizationDetails;
import org.apache.fineract.client.models.LoanAmortizationAllocationResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoanBuyDownFeesApi {
    /**
    * Retrieve a BuyDown Fees allocation data
    * Retrieves BuyDown Fees allocation data according to the Loan external ID and Loan Transaction external IDExample Requests:  /loans/external-id/1/buydown-fees/1   /loans/external-id/1/buydown-fees/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
        * @param loanExternalId loanExternalId (required)
        * @param loanTransactionExternalId loanTransactionExternalId (required)
    * @return Call&lt;LoanAmortizationAllocationResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/buydown-fees/external-id/{loanTransactionExternalId}")
    Call<LoanAmortizationAllocationResponse> getBuyDownFeesAllocationDataByExternalIds(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanTransactionExternalId") String loanTransactionExternalId);

    /**
    * Retrieve a BuyDown Fees allocation data
    * Retrieves BuyDown Fees allocation data according to the Loan external ID and Loan Transaction IDExample Requests:  /loans/external-id/1/buydown-fees/1   /loans/external-id/1/buydown-fees/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
        * @param loanExternalId loanExternalId (required)
        * @param loanTransactionId loanTransactionId (required)
    * @return Call&lt;LoanAmortizationAllocationResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/buydown-fees/{loanTransactionId}")
    Call<LoanAmortizationAllocationResponse> getBuyDownFeesAllocationDataByLoanExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanTransactionId") Long loanTransactionId);

    /**
    * Retrieve a BuyDown Fees allocation data
    * Retrieves BuyDown Fees allocation data according to the Loan ID and Loan Transaction external IDExample Requests:  /loans/1/buydown-fees/external-id/1   /loans/1/buydown-fees/external-id/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
        * @param loanId loanId (required)
        * @param loanTransactionExternalId loanTransactionExternalId (required)
    * @return Call&lt;LoanAmortizationAllocationResponse&gt;
    */
    @GET("v1/loans/{loanId}/buydown-fees/external-id/{loanTransactionExternalId}")
    Call<LoanAmortizationAllocationResponse> getBuyDownFeesAllocationDataByTransactionExternalId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanTransactionExternalId") String loanTransactionExternalId);

    /**
    * Retrieve a BuyDown Fees allocation data
    * Retrieves BuyDown Fees allocation data according to the Loan ID and Loan Transaction IDExample Requests:  /loans/1/buydown-fees/1   /loans/1/buydown-fees/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
        * @param loanId loanId (required)
        * @param loanTransactionId loanTransactionId (required)
    * @return Call&lt;LoanAmortizationAllocationResponse&gt;
    */
    @GET("v1/loans/{loanId}/buydown-fees/{loanTransactionId}")
    Call<LoanAmortizationAllocationResponse> retrieveBuyDownFeesAllocationData(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanTransactionId") Long loanTransactionId);

    /**
    * Get the amortization details of Buy Down fees for a loan
    * Returns a list of all Buy Down fee entries with amortization details for the specified loan.
        * @param loanId loanId (required)
    * @return Call&lt;List&lt;BuyDownFeeAmortizationDetails&gt;&gt;
    */
    @GET("v1/loans/{loanId}/buydown-fees")
    Call<List<BuyDownFeeAmortizationDetails>> retrieveLoanBuyDownFeeAmortizationDetails(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Get the amortization details of Buy Down fees for a loan by external ID
    * Returns a list of all Buy Down fee entries with amortization details for the loan specified by external ID.
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;List&lt;BuyDownFeeAmortizationDetails&gt;&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/buydown-fees")
    Call<List<BuyDownFeeAmortizationDetails>> retrieveLoanBuyDownFeeAmortizationDetailsByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId);



        /**
        * Retrieve a BuyDown Fees allocation data
        * Retrieves BuyDown Fees allocation data according to the Loan external ID and Loan Transaction external IDExample Requests:  /loans/external-id/1/buydown-fees/1   /loans/external-id/1/buydown-fees/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
            * @param loanExternalId loanExternalId (required)
            * @param loanTransactionExternalId loanTransactionExternalId (required)
        * @return Call&lt;LoanAmortizationAllocationResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/buydown-fees/external-id/{loanTransactionExternalId}")
    Call<LoanAmortizationAllocationResponse> getBuyDownFeesAllocationDataByExternalIds(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanTransactionExternalId") String loanTransactionExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a BuyDown Fees allocation data
        * Retrieves BuyDown Fees allocation data according to the Loan external ID and Loan Transaction IDExample Requests:  /loans/external-id/1/buydown-fees/1   /loans/external-id/1/buydown-fees/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
            * @param loanExternalId loanExternalId (required)
            * @param loanTransactionId loanTransactionId (required)
        * @return Call&lt;LoanAmortizationAllocationResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/buydown-fees/{loanTransactionId}")
    Call<LoanAmortizationAllocationResponse> getBuyDownFeesAllocationDataByLoanExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanTransactionId") Long loanTransactionId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a BuyDown Fees allocation data
        * Retrieves BuyDown Fees allocation data according to the Loan ID and Loan Transaction external IDExample Requests:  /loans/1/buydown-fees/external-id/1   /loans/1/buydown-fees/external-id/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
            * @param loanId loanId (required)
            * @param loanTransactionExternalId loanTransactionExternalId (required)
        * @return Call&lt;LoanAmortizationAllocationResponse&gt;
        */
    @GET("v1/loans/{loanId}/buydown-fees/external-id/{loanTransactionExternalId}")
    Call<LoanAmortizationAllocationResponse> getBuyDownFeesAllocationDataByTransactionExternalId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanTransactionExternalId") String loanTransactionExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a BuyDown Fees allocation data
        * Retrieves BuyDown Fees allocation data according to the Loan ID and Loan Transaction IDExample Requests:  /loans/1/buydown-fees/1   /loans/1/buydown-fees/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
            * @param loanId loanId (required)
            * @param loanTransactionId loanTransactionId (required)
        * @return Call&lt;LoanAmortizationAllocationResponse&gt;
        */
    @GET("v1/loans/{loanId}/buydown-fees/{loanTransactionId}")
    Call<LoanAmortizationAllocationResponse> retrieveBuyDownFeesAllocationData(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanTransactionId") Long loanTransactionId, @HeaderMap Map<String, String> headers);

        /**
        * Get the amortization details of Buy Down fees for a loan
        * Returns a list of all Buy Down fee entries with amortization details for the specified loan.
            * @param loanId loanId (required)
        * @return Call&lt;List&lt;BuyDownFeeAmortizationDetails&gt;&gt;
        */
    @GET("v1/loans/{loanId}/buydown-fees")
    Call<List<BuyDownFeeAmortizationDetails>> retrieveLoanBuyDownFeeAmortizationDetails(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Get the amortization details of Buy Down fees for a loan by external ID
        * Returns a list of all Buy Down fee entries with amortization details for the loan specified by external ID.
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;List&lt;BuyDownFeeAmortizationDetails&gt;&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/buydown-fees")
    Call<List<BuyDownFeeAmortizationDetails>> retrieveLoanBuyDownFeeAmortizationDetailsByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);


}
