/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.service;

import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatRepositoryWrapper;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.share.ShareAccountApproveBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.share.ShareAccountCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.account.service.AccountNumberGenerator;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountTransactionEnumData;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccount;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountChargePaidBy;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountRepositoryWrapper;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountTransaction;
import org.apache.fineract.portfolio.shareaccounts.serialization.ShareAccountDataSerializer;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountWritePlatformService;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProduct;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductRepositoryWrapper;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;

public class ShareAccountWritePlatformServiceJpaRepositoryImpl
implements ShareAccountWritePlatformService {
    private final ShareAccountDataSerializer accountDataSerializer;
    private final ShareAccountRepositoryWrapper shareAccountRepository;
    private final ShareProductRepositoryWrapper shareProductRepository;
    private final AccountNumberGenerator accountNumberGenerator;
    private final AccountNumberFormatRepositoryWrapper accountNumberFormatRepository;
    private final JournalEntryWritePlatformService journalEntryWritePlatformService;
    private final NoteRepository noteRepository;
    private final BusinessEventNotifierService businessEventNotifierService;

    public CommandProcessingResult createShareAccount(JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.accountDataSerializer.validateAndCreate(jsonCommand);
            this.shareAccountRepository.saveAndFlush(account);
            this.generateAccountNumber(account);
            this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, account.getPendingForApprovalSharePurchaseTransactions()));
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new ShareAccountCreateBusinessEvent(account));
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId((Long)account.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(jsonCommand, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private void generateAccountNumber(ShareAccount account) {
        if (account.isAccountNumberRequiresAutoGeneration()) {
            AccountNumberFormat accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(EntityAccountType.SHARES);
            account.updateAccountNumber(this.accountNumberGenerator.generate(account, accountNumberFormat));
            this.shareAccountRepository.save(account);
        }
    }

    private Map<String, Object> populateJournalEntries(ShareAccount account, Set<ShareAccountTransaction> transactions) {
        HashMap<String, Object> accountingBridgeData = new HashMap<String, Object>();
        Boolean cashBasedAccounting = account.getShareProduct().getAccountingType() == 2;
        accountingBridgeData.put("cashBasedAccountingEnabled", cashBasedAccounting);
        accountingBridgeData.put("accrualBasedAccountingEnabled", Boolean.FALSE);
        accountingBridgeData.put("shareAccountId", account.getId());
        accountingBridgeData.put("shareProductId", account.getShareProduct().getId());
        accountingBridgeData.put("officeId", account.getOfficeId());
        accountingBridgeData.put("currencyCode", account.getCurrency().getCode());
        ArrayList newTransactionsMap = new ArrayList();
        accountingBridgeData.put("newTransactions", newTransactionsMap);
        for (ShareAccountTransaction transaction : transactions) {
            HashMap<String, Serializable> transactionDto = new HashMap<String, Serializable>();
            transactionDto.put("officeId", account.getOfficeId());
            transactionDto.put("id", transaction.getId());
            transactionDto.put("date", transaction.getPurchasedDate());
            Integer status = transaction.getTransactionStatus();
            ShareAccountTransactionEnumData statusEnum = new ShareAccountTransactionEnumData(Long.valueOf(status.longValue()), null, null);
            Integer type = transaction.getTransactionType();
            ShareAccountTransactionEnumData typeEnum = new ShareAccountTransactionEnumData(Long.valueOf(type.longValue()), null, null);
            transactionDto.put("status", (Serializable)statusEnum);
            transactionDto.put("type", (Serializable)typeEnum);
            if (transaction.isPurchaseRejectedTransaction() || transaction.isRedeemTransaction()) {
                BigDecimal amount = transaction.amount();
                if (transaction.chargeAmount() != null) {
                    amount = amount.add(transaction.chargeAmount());
                }
                transactionDto.put("amount", amount);
            } else {
                transactionDto.put("amount", transaction.amount());
            }
            transactionDto.put("chargeAmount", transaction.chargeAmount());
            transactionDto.put("paymentTypeId", null);
            if (transaction.getChargesPaidBy() != null && !transaction.getChargesPaidBy().isEmpty()) {
                ArrayList chargesPaidData = new ArrayList();
                transactionDto.put("chargesPaid", chargesPaidData);
                Set chargesPaidBySet = transaction.getChargesPaidBy();
                for (ShareAccountChargePaidBy chargesPaidBy : chargesPaidBySet) {
                    HashMap<String, Number> chargesPaidDto = new HashMap<String, Number>();
                    chargesPaidDto.put("chargeId", chargesPaidBy.getChargeId());
                    chargesPaidDto.put("sharesChargeId", chargesPaidBy.getShareChargeId());
                    chargesPaidDto.put("amount", chargesPaidBy.getAmount());
                    chargesPaidData.add(chargesPaidDto);
                }
            }
            newTransactionsMap.add(transactionDto);
        }
        return accountingBridgeData;
    }

    public CommandProcessingResult updateShareAccount(Long accountId, JsonCommand jsonCommand) {
        try {
            LocalDate transactionDate = DateUtils.getBusinessLocalDate();
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndUpdate(jsonCommand, account);
            if (!changes.isEmpty()) {
                this.shareAccountRepository.save(account);
            }
            if (changes.containsKey("reversalIds")) {
                ArrayList reversalIds = (ArrayList)changes.get("reversalIds");
                this.journalEntryWritePlatformService.revertShareAccountJournalEntries(reversalIds, transactionDate);
                this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, account.getPendingForApprovalSharePurchaseTransactions()));
                changes.remove("reversalIds");
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(jsonCommand, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult applyAddtionalShares(Long accountId, JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndApplyAddtionalShares(jsonCommand, account);
            ShareAccountTransaction transaction = null;
            if (!changes.isEmpty()) {
                this.shareAccountRepository.saveAndFlush(account);
                transaction = (ShareAccountTransaction)changes.get("additionalshares");
                transaction = account.getShareAccountTransaction(transaction);
                if (transaction != null) {
                    changes.clear();
                    changes.put("additionalshares", transaction.getId());
                    HashSet<ShareAccountTransaction> transactions = new HashSet<ShareAccountTransaction>();
                    transactions.add(transaction);
                    this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, transactions));
                }
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult approveShareAccount(Long accountId, JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndApprove(jsonCommand, account);
            if (!changes.isEmpty()) {
                this.shareAccountRepository.save(account);
                String noteText = jsonCommand.stringValueOfParameterNamed("note");
                if (StringUtils.isNotBlank((CharSequence)noteText)) {
                    Note note = Note.shareNote((ShareAccount)account, (String)noteText);
                    changes.put("note", noteText);
                    this.noteRepository.save((Object)note);
                }
            }
            Set transactions = account.getShareAccountTransactions();
            HashSet<ShareAccountTransaction> journalTransactions = new HashSet<ShareAccountTransaction>();
            Long totalSubsribedShares = 0L;
            for (ShareAccountTransaction transaction : transactions) {
                if (!transaction.isActive() || !transaction.isPurchasTransaction()) continue;
                journalTransactions.add(transaction);
                totalSubsribedShares = totalSubsribedShares + transaction.getTotalShares();
            }
            ShareProduct shareProduct = account.getShareProduct();
            shareProduct.addSubscribedShares(totalSubsribedShares);
            this.shareProductRepository.save(shareProduct);
            this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, journalTransactions));
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new ShareAccountApproveBusinessEvent(account));
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult rejectShareAccount(Long accountId, JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndReject(jsonCommand, account);
            if (!changes.isEmpty()) {
                this.shareAccountRepository.save(account);
                String noteText = jsonCommand.stringValueOfParameterNamed("note");
                if (StringUtils.isNotBlank((CharSequence)noteText)) {
                    Note note = Note.shareNote((ShareAccount)account, (String)noteText);
                    changes.put("note", noteText);
                    this.noteRepository.save((Object)note);
                }
            }
            Set transactions = account.getShareAccountTransactions();
            HashSet<ShareAccountTransaction> journalTransactions = new HashSet<ShareAccountTransaction>();
            for (ShareAccountTransaction transaction : transactions) {
                if (!transaction.isActive() || transaction.isChargeTransaction()) continue;
                journalTransactions.add(transaction);
            }
            this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, journalTransactions));
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult undoApproveShareAccount(Long accountId, JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndUndoApprove(jsonCommand, account);
            if (!changes.isEmpty()) {
                this.shareAccountRepository.save(account);
                String noteText = jsonCommand.stringValueOfParameterNamed("note");
                if (StringUtils.isNotBlank((CharSequence)noteText)) {
                    Note note = Note.shareNote((ShareAccount)account, (String)noteText);
                    changes.put("note", noteText);
                    this.noteRepository.save((Object)note);
                }
            }
            Set transactions = account.getShareAccountTransactions();
            ArrayList<Long> journalEntryTransactions = new ArrayList<Long>();
            for (ShareAccountTransaction transaction : transactions) {
                if (!transaction.isActive() || transaction.isChargeTransaction()) continue;
                journalEntryTransactions.add((Long)transaction.getId());
            }
            LocalDate transactionDate = DateUtils.getBusinessLocalDate();
            this.journalEntryWritePlatformService.revertShareAccountJournalEntries(journalEntryTransactions, transactionDate);
            this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, account.getPendingForApprovalSharePurchaseTransactions()));
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult activateShareAccount(Long accountId, JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndActivate(jsonCommand, account);
            if (!changes.isEmpty()) {
                this.shareAccountRepository.save(account);
            }
            this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, account.getChargeTransactions()));
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult approveAdditionalShares(Long accountId, JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndApproveAddtionalShares(jsonCommand, account);
            if (!changes.isEmpty()) {
                this.shareAccountRepository.save(account);
                ArrayList transactionIds = (ArrayList)changes.get("requestedShares");
                Long totalSubscribedShares = 0L;
                if (transactionIds != null) {
                    HashSet<ShareAccountTransaction> transactions = new HashSet<ShareAccountTransaction>();
                    for (Long id : transactionIds) {
                        ShareAccountTransaction transaction = account.retrievePurchasedShares(id);
                        transactions.add(transaction);
                        totalSubscribedShares = totalSubscribedShares + transaction.getTotalShares();
                    }
                    this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, transactions));
                }
                if (!totalSubscribedShares.equals(0L)) {
                    ShareProduct shareProduct = account.getShareProduct();
                    shareProduct.addSubscribedShares(totalSubscribedShares);
                    this.shareProductRepository.save(shareProduct);
                }
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult rejectAdditionalShares(Long accountId, JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndRejectAddtionalShares(jsonCommand, account);
            if (!changes.isEmpty()) {
                this.shareAccountRepository.save(account);
                ArrayList transactionIds = (ArrayList)changes.get("requestedShares");
                if (transactionIds != null) {
                    HashSet<ShareAccountTransaction> transactions = new HashSet<ShareAccountTransaction>();
                    for (Long id : transactionIds) {
                        ShareAccountTransaction transaction = account.retrievePurchasedShares(id);
                        transactions.add(transaction);
                    }
                    this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, transactions));
                }
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult redeemShares(Long accountId, JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndRedeemShares(jsonCommand, account);
            if (!changes.isEmpty()) {
                this.shareAccountRepository.saveAndFlush(account);
                ShareAccountTransaction transaction = (ShareAccountTransaction)changes.get("requestedShares");
                transaction = account.getShareAccountTransaction(transaction);
                Long redeemShares = transaction.getTotalShares();
                ShareProduct shareProduct = account.getShareProduct();
                shareProduct.removeSubscribedShares(redeemShares);
                this.shareProductRepository.saveAndFlush(shareProduct);
                HashSet<ShareAccountTransaction> transactions = new HashSet<ShareAccountTransaction>();
                transactions.add(transaction);
                this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, transactions));
                changes.clear();
                changes.put("requestedShares", transaction.getId());
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult closeShareAccount(Long accountId, JsonCommand jsonCommand) {
        try {
            ShareAccount account = this.shareAccountRepository.findOneWithNotFoundDetection(accountId);
            Map changes = this.accountDataSerializer.validateAndClose(jsonCommand, account);
            if (!changes.isEmpty()) {
                this.shareAccountRepository.saveAndFlush(account);
                String noteText = jsonCommand.stringValueOfParameterNamed("note");
                if (StringUtils.isNotBlank((CharSequence)noteText)) {
                    Note note = Note.shareNote((ShareAccount)account, (String)noteText);
                    changes.put("note", noteText);
                    this.noteRepository.save((Object)note);
                }
                ShareAccountTransaction transaction = (ShareAccountTransaction)changes.get("requestedShares");
                transaction = account.getShareAccountTransaction(transaction);
                HashSet<ShareAccountTransaction> transactions = new HashSet<ShareAccountTransaction>();
                transactions.add(transaction);
                this.journalEntryWritePlatformService.createJournalEntriesForShares(this.populateJournalEntries(account, transactions));
                changes.clear();
                changes.put("requestedShares", transaction.getId());
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(accountId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.shareaccount.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    @Generated
    public ShareAccountWritePlatformServiceJpaRepositoryImpl(ShareAccountDataSerializer accountDataSerializer, ShareAccountRepositoryWrapper shareAccountRepository, ShareProductRepositoryWrapper shareProductRepository, AccountNumberGenerator accountNumberGenerator, AccountNumberFormatRepositoryWrapper accountNumberFormatRepository, JournalEntryWritePlatformService journalEntryWritePlatformService, NoteRepository noteRepository, BusinessEventNotifierService businessEventNotifierService) {
        this.accountDataSerializer = accountDataSerializer;
        this.shareAccountRepository = shareAccountRepository;
        this.shareProductRepository = shareProductRepository;
        this.accountNumberGenerator = accountNumberGenerator;
        this.accountNumberFormatRepository = accountNumberFormatRepository;
        this.journalEntryWritePlatformService = journalEntryWritePlatformService;
        this.noteRepository = noteRepository;
        this.businessEventNotifierService = businessEventNotifierService;
    }
}

