/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.handler.loan.reamortization;

import lombok.Generated;
import org.apache.fineract.commands.annotation.CommandType;
import org.apache.fineract.commands.handler.NewCommandSourceHandler;
import org.apache.fineract.infrastructure.DataIntegrityErrorHandler;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.portfolio.loanaccount.service.reamortization.LoanReAmortizationService;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;

@Service
@CommandType(entity="LOAN", action="UNDO_REAMORTIZE")
public class LoanUndoReAmortizationCommandHandler
implements NewCommandSourceHandler {
    private final LoanReAmortizationService loanReAmortizationService;
    private final DataIntegrityErrorHandler dataIntegrityErrorHandler;

    public CommandProcessingResult processCommand(JsonCommand command) {
        try {
            return this.loanReAmortizationService.undoReAmortize(command.getLoanId(), command);
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.dataIntegrityErrorHandler.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve, "loan.undoReAmortize", "Error while handling undo re-amortizing");
            return CommandProcessingResult.empty();
        }
    }

    @Generated
    public LoanUndoReAmortizationCommandHandler(LoanReAmortizationService loanReAmortizationService, DataIntegrityErrorHandler dataIntegrityErrorHandler) {
        this.loanReAmortizationService = loanReAmortizationService;
        this.dataIntegrityErrorHandler = dataIntegrityErrorHandler;
    }
}

