/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.domain;

import java.time.LocalDate;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepository;
import org.apache.fineract.portfolio.group.exception.GroupNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupRepositoryWrapper {
    private final GroupRepository repository;

    @Autowired
    public GroupRepositoryWrapper(GroupRepository repository) {
        this.repository = repository;
    }

    public Group findOneWithNotFoundDetection(Long id) {
        return (Group)this.repository.findById((Object)id).orElseThrow(() -> new GroupNotFoundException(id));
    }

    public Group findByOfficeWithNotFoundDetection(Long id, Office office) {
        Group group = this.findOneWithNotFoundDetection(id);
        if (!((Long)group.getOffice().getId()).equals(office.getId())) {
            throw new GroupNotFoundException(id);
        }
        return group;
    }

    public void save(Group entity) {
        this.repository.save((Object)entity);
    }

    public void saveAndFlush(Group entity) {
        this.repository.saveAndFlush((Object)entity);
    }

    public void delete(Group entity) {
        this.repository.delete((Object)entity);
    }

    public void flush() {
        this.repository.flush();
    }

    public LocalDate retrieveSubmittedOndate(Long groupId) {
        return this.repository.retrieveGroupTypeSubmitteOndDate(groupId);
    }
}

