/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.accountdetails.service;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.portfolio.accountdetails.data.AccountSummaryCollectionData;
import org.apache.fineract.portfolio.accountdetails.data.GuarantorAccountSummaryData;
import org.apache.fineract.portfolio.accountdetails.data.LoanAccountSummaryData;
import org.apache.fineract.portfolio.accountdetails.data.SavingsAccountSummaryData;
import org.apache.fineract.portfolio.accountdetails.data.ShareAccountSummaryData;
import org.apache.fineract.portfolio.accountdetails.service.AccountDetailsReadPlatformService;
import org.apache.fineract.portfolio.accountdetails.service.AccountDetailsReadPlatformServiceJpaRepositoryImpl;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class AccountDetailsReadPlatformServiceJpaRepositoryImpl
implements AccountDetailsReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final ClientReadPlatformService clientReadPlatformService;
    private final GroupReadPlatformService groupReadPlatformService;
    private final ColumnValidator columnValidator;

    public AccountSummaryCollectionData retrieveClientAccountDetails(Long clientId) {
        this.clientReadPlatformService.retrieveOne(clientId);
        String loanwhereClause = " where l.client_id = ?";
        String glimLoanClause = " where l.client_id = ? and l.loan_type_enum=4";
        String savingswhereClause = " where sa.client_id = ? order by sa.status_enum ASC, sa.account_no ASC";
        String guarantorWhereClause = " where g.entity_id = ? and g.is_active = true order by l.account_no ASC";
        List glimAccounts = this.retrieveLoanAccountDetails(" where l.client_id = ? and l.loan_type_enum=4", new Object[]{clientId});
        List loanAccounts = this.retrieveLoanAccountDetails(" where l.client_id = ?", new Object[]{clientId});
        List savingsAccounts = this.retrieveAccountDetails(" where sa.client_id = ? order by sa.status_enum ASC, sa.account_no ASC", new Object[]{clientId});
        List shareAccounts = this.retrieveShareAccountDetails(clientId);
        List guarantorloanAccounts = this.retrieveGuarantorLoanAccountDetails(" where g.entity_id = ? and g.is_active = true order by l.account_no ASC", new Object[]{clientId});
        return new AccountSummaryCollectionData((Collection)loanAccounts, (Collection)glimAccounts, (Collection)savingsAccounts, (Collection)shareAccounts, (Collection)guarantorloanAccounts);
    }

    public AccountSummaryCollectionData retrieveGroupAccountDetails(Long groupId) {
        this.groupReadPlatformService.retrieveOne(groupId);
        String loanWhereClauseForGroup = " where l.group_id = ? and l.client_id is null";
        String loanWhereClauseForGroupAndLoanType = " where l.group_id = ? and l.loan_type_enum=4";
        String loanWhereClauseForMembers = " where l.group_id = ? and l.client_id is not null";
        String savingswhereClauseForGroup = " where sa.group_id = ? and sa.client_id is null order by sa.status_enum ASC, sa.account_no ASC";
        String savingswhereClauseForMembers = " where sa.group_id = ? and sa.client_id is not null order by sa.status_enum ASC, sa.account_no ASC";
        String guarantorWhereClauseForGroup = " where l.group_id = ? and l.client_id is null and g.is_active = true order by l.account_no ASC";
        String guarantorWhereClauseForMembers = " where l.group_id = ? and l.client_id is not null and g.is_active = true order by l.account_no ASC";
        List glimAccounts = this.retrieveLoanAccountDetails(" where l.group_id = ? and l.loan_type_enum=4", new Object[]{groupId});
        List groupLoanAccounts = this.retrieveLoanAccountDetails(" where l.group_id = ? and l.client_id is null", new Object[]{groupId});
        List groupSavingsAccounts = this.retrieveAccountDetails(" where sa.group_id = ? and sa.client_id is null order by sa.status_enum ASC, sa.account_no ASC", new Object[]{groupId});
        List groupGuarantorloanAccounts = this.retrieveGuarantorLoanAccountDetails(" where l.group_id = ? and l.client_id is null and g.is_active = true order by l.account_no ASC", new Object[]{groupId});
        List memberLoanAccounts = this.retrieveLoanAccountDetails(" where l.group_id = ? and l.client_id is not null", new Object[]{groupId});
        List memberSavingsAccounts = this.retrieveAccountDetails(" where sa.group_id = ? and sa.client_id is not null order by sa.status_enum ASC, sa.account_no ASC", new Object[]{groupId});
        List memberGuarantorloanAccounts = this.retrieveGuarantorLoanAccountDetails(" where l.group_id = ? and l.client_id is not null and g.is_active = true order by l.account_no ASC", new Object[]{groupId});
        return new AccountSummaryCollectionData((Collection)groupLoanAccounts, (Collection)glimAccounts, (Collection)groupSavingsAccounts, (Collection)groupGuarantorloanAccounts, (Collection)memberLoanAccounts, (Collection)memberSavingsAccounts, (Collection)memberGuarantorloanAccounts);
    }

    public AccountSummaryCollectionData retrieveGroupAccountDetails(Long groupId, Long gsimId) {
        this.groupReadPlatformService.retrieveOne(groupId);
        String loanWhereClauseForGroup = " where l.group_id = ? and l.client_id is null";
        String loanWhereClauseForGroupAndLoanType = " where l.group_id = ? and l.loan_type_enum=4";
        String loanWhereClauseForMembers = " where l.group_id = ? and l.client_id is not null";
        String savingswhereClauseForGroup = " where sa.group_id = ? and sa.gsim_id = ? sa.client_id is null order by sa.status_enum ASC, sa.account_no ASC";
        String savingswhereClauseForMembers = " where sa.group_id = ? and sa.client_id is not null order by sa.status_enum ASC, sa.account_no ASC";
        List glimAccounts = this.retrieveLoanAccountDetails(" where l.group_id = ? and l.loan_type_enum=4", new Object[]{groupId});
        List groupLoanAccounts = this.retrieveLoanAccountDetails(" where l.group_id = ? and l.client_id is null", new Object[]{groupId});
        List gsimSavingsAccounts = this.retrieveAccountDetails(" where sa.group_id = ? and sa.gsim_id = ? sa.client_id is null order by sa.status_enum ASC, sa.account_no ASC", new Object[]{groupId, gsimId});
        List memberLoanAccounts = this.retrieveLoanAccountDetails(" where l.group_id = ? and l.client_id is not null", new Object[]{groupId});
        List memberSavingsAccounts = this.retrieveAccountDetails(" where sa.group_id = ? and sa.client_id is not null order by sa.status_enum ASC, sa.account_no ASC", new Object[]{groupId});
        return new AccountSummaryCollectionData((Collection)groupLoanAccounts, (Collection)glimAccounts, (Collection)gsimSavingsAccounts, null, (Collection)memberLoanAccounts, (Collection)memberSavingsAccounts, null);
    }

    public Collection<LoanAccountSummaryData> retrieveClientLoanAccountsByLoanOfficerId(Long clientId, Long loanOfficerId) {
        this.clientReadPlatformService.retrieveOne(clientId);
        String loanWhereClause = " where l.client_id = ? and l.loan_officer_id = ?";
        return this.retrieveLoanAccountDetails(" where l.client_id = ? and l.loan_officer_id = ?", new Object[]{clientId, loanOfficerId});
    }

    public Collection<LoanAccountSummaryData> retrieveGroupLoanAccountsByLoanOfficerId(Long groupId, Long loanOfficerId) {
        this.groupReadPlatformService.retrieveOne(groupId);
        String loanWhereClause = " where l.group_id = ? and l.client_id is null and l.loan_officer_id = ?";
        return this.retrieveLoanAccountDetails(" where l.group_id = ? and l.client_id is null and l.loan_officer_id = ?", new Object[]{groupId, loanOfficerId});
    }

    public Collection<LoanAccountSummaryData> retrieveClientActiveLoanAccountSummary(Long clientId) {
        String loanWhereClause = " where l.client_id = ? and l.loan_status_id = 300 ";
        return this.retrieveLoanAccountDetails(" where l.client_id = ? and l.loan_status_id = 300 ", new Object[]{clientId});
    }

    public List<LoanAccountSummaryData> retrieveLoanAccountDetailsByGroupIdAndGlimAccountNumber(Long groupId, String glimAccount) {
        LoanAccountSummaryDataMapper rm = new LoanAccountSummaryDataMapper();
        String loanWhereClauseForGroupAndLoanType = " where l.group_id =? and glim.account_number=? and l.loan_type_enum=4";
        String sql = "select " + rm.loanAccountSummarySchema() + " where l.group_id =? and glim.account_number=? and l.loan_type_enum=4";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{groupId, glimAccount});
    }

    public Collection<LoanAccountSummaryData> retrieveGroupActiveLoanAccountSummary(Long groupId) {
        String loanWhereClause = " where l.group_id = ? and l.loan_status_id = 300 and l.client_id is null";
        return this.retrieveLoanAccountDetails(" where l.group_id = ? and l.loan_status_id = 300 and l.client_id is null", new Object[]{groupId});
    }

    private List<LoanAccountSummaryData> retrieveLoanAccountDetails(String loanwhereClause, Object[] inputs) {
        LoanAccountSummaryDataMapper rm = new LoanAccountSummaryDataMapper();
        String sql = "select " + rm.loanAccountSummarySchema() + loanwhereClause;
        this.columnValidator.validateSqlInjection(rm.loanAccountSummarySchema(), new String[]{loanwhereClause});
        return this.jdbcTemplate.query(sql, (RowMapper)rm, inputs);
    }

    private List<SavingsAccountSummaryData> retrieveAccountDetails(String savingswhereClause, Object[] inputs) {
        SavingsAccountSummaryDataMapper savingsAccountSummaryDataMapper = new SavingsAccountSummaryDataMapper();
        String savingsSql = "select " + savingsAccountSummaryDataMapper.schema() + savingswhereClause;
        this.columnValidator.validateSqlInjection(savingsAccountSummaryDataMapper.schema(), new String[]{savingswhereClause});
        return this.jdbcTemplate.query(savingsSql, (RowMapper)savingsAccountSummaryDataMapper, inputs);
    }

    private List<ShareAccountSummaryData> retrieveShareAccountDetails(Long clientId) {
        ShareAccountSummaryDataMapper mapper = new ShareAccountSummaryDataMapper();
        String query = "select " + mapper.schema() + " where sa.client_id = ?";
        return this.jdbcTemplate.query(query, (RowMapper)mapper, new Object[]{clientId});
    }

    private List<GuarantorAccountSummaryData> retrieveGuarantorLoanAccountDetails(String loanwhereClause, Object[] inputs) {
        GuarantorLoanAccountSummaryDataMapper rm = new GuarantorLoanAccountSummaryDataMapper();
        String sql = "select " + rm.guarantorLoanAccountSummarySchema() + loanwhereClause;
        return this.jdbcTemplate.query(sql, (RowMapper)rm, inputs);
    }

    @Generated
    public AccountDetailsReadPlatformServiceJpaRepositoryImpl(JdbcTemplate jdbcTemplate, ClientReadPlatformService clientReadPlatformService, GroupReadPlatformService groupReadPlatformService, ColumnValidator columnValidator) {
        this.jdbcTemplate = jdbcTemplate;
        this.clientReadPlatformService = clientReadPlatformService;
        this.groupReadPlatformService = groupReadPlatformService;
        this.columnValidator = columnValidator;
    }
}

