/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.executealldirtyjobs;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetail;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetailRepository;
import org.apache.fineract.infrastructure.jobs.service.JobRegisterService;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.stereotype.Component;

@Component
public class ExecuteAllDirtyJobsTasklet
implements Tasklet {
    private final JobRegisterService jobRegisterService;
    private final ScheduledJobDetailRepository scheduledJobDetailsRepository;
    private final FineractProperties fineractProperties;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        List jobDetails = this.scheduledJobDetailsRepository.findAllMismatchedJobs(true);
        for (ScheduledJobDetail scheduledJobDetail : jobDetails) {
            if (!scheduledJobDetail.getNodeId().toString().equals(this.fineractProperties.getNodeId())) continue;
            this.jobRegisterService.executeJobWithParameters((Long)scheduledJobDetail.getId(), null);
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public ExecuteAllDirtyJobsTasklet(JobRegisterService jobRegisterService, ScheduledJobDetailRepository scheduledJobDetailsRepository, FineractProperties fineractProperties) {
        this.jobRegisterService = jobRegisterService;
        this.scheduledJobDetailsRepository = scheduledJobDetailsRepository;
        this.fineractProperties = fineractProperties;
    }
}

