/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.processor;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.hooks.domain.Hook;
import org.apache.fineract.infrastructure.hooks.domain.HookConfiguration;
import org.apache.fineract.infrastructure.hooks.processor.HookProcessor;
import org.apache.fineract.infrastructure.hooks.processor.ProcessorHelper;
import org.apache.fineract.infrastructure.hooks.processor.WebHookService;
import org.springframework.stereotype.Service;
import retrofit2.Callback;

@Service
public class ElasticSearchHookProcessor
implements HookProcessor {
    private final ProcessorHelper processorHelper;

    public void process(Hook hook, String payload, String entityName, String actionName, FineractContext context) {
        Set config = hook.getConfig();
        String url = "";
        String contentType = "";
        for (HookConfiguration conf : config) {
            String fieldName = conf.getFieldName();
            if (fieldName.equals("Payload URL")) {
                url = conf.getFieldValue();
            }
            if (!fieldName.equals("Content Type")) continue;
            contentType = conf.getFieldValue();
        }
        this.sendRequest(url, contentType, payload, entityName, actionName, context);
    }

    private void sendRequest(String url, String contentType, String payload, String entityName, String actionName, FineractContext context) {
        String fineractEndpointUrl = System.getProperty("baseUrl");
        WebHookService service = this.processorHelper.createWebHookService(url);
        Callback callback = this.processorHelper.createCallback(url, payload);
        if (contentType.equalsIgnoreCase("json") || contentType.contains("json")) {
            JsonObject json = (JsonObject)new Gson().fromJson(payload, JsonObject.class);
            service.sendJsonRequest(entityName, actionName, context.getTenantContext().getTenantIdentifier(), fineractEndpointUrl, json).enqueue(callback);
        } else {
            Map map = new HashMap();
            map = (Map)new Gson().fromJson(payload, map.getClass());
            service.sendFormRequest(entityName, actionName, context.getTenantContext().getTenantIdentifier(), fineractEndpointUrl, map).enqueue(callback);
        }
    }

    @Generated
    public ElasticSearchHookProcessor(ProcessorHelper processorHelper) {
        this.processorHelper = processorHelper;
    }
}

