/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.jersey.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.fineract.infrastructure.core.jersey.converter.JsonConverter;

public class LocalDateJsonConverter
implements JsonConverter<LocalDate> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;

    public LocalDate convertToObject(JsonParser parser) throws IOException {
        LocalDate result = null;
        if (parser.hasToken(JsonToken.VALUE_STRING)) {
            String formattedDate = parser.getText();
            result = LocalDate.parse(formattedDate, FORMATTER);
        }
        return result;
    }

    public void convertToJson(LocalDate value, JsonGenerator generator) throws IOException {
        if (value != null) {
            generator.writeString(FORMATTER.format(value));
        }
    }

    public Class<LocalDate> convertedType() {
        return LocalDate.class;
    }
}

