/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.journalentry;

import java.util.ArrayList;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ExtrasSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.GlAccountSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class JournalEntriesWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final OfficeSheetPopulator officeSheetPopulator;
    private final GlAccountSheetPopulator glAccountSheetPopulator;
    private final ExtrasSheetPopulator extrasSheetPopulator;

    public JournalEntriesWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, GlAccountSheetPopulator glAccountSheetPopulator, ExtrasSheetPopulator extrasSheetPopulator) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.glAccountSheetPopulator = glAccountSheetPopulator;
        this.extrasSheetPopulator = extrasSheetPopulator;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet addJournalEntriesSheet = workbook.createSheet("AddJournalEntries");
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.glAccountSheetPopulator.populate(workbook, dateFormat);
        this.extrasSheetPopulator.populate(workbook, dateFormat);
        this.setRules(addJournalEntriesSheet);
        this.setDefaults(addJournalEntriesSheet);
        this.setLayout(addJournalEntriesSheet);
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 4000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(15, 10000);
        this.writeString(0, rowHeader, "Office Name*");
        this.writeString(1, rowHeader, "Transaction On *");
        this.writeString(2, rowHeader, "Currecy Type*");
        this.writeString(3, rowHeader, "Payment Type*");
        this.writeString(4, rowHeader, "Transaction Id*");
        this.writeString(5, rowHeader, "Credit Account Type*");
        this.writeString(6, rowHeader, "Amount*");
        this.writeString(7, rowHeader, "Debit Account Type*");
        this.writeString(8, rowHeader, "Amount*");
        this.writeString(10, rowHeader, "Account#");
        this.writeString(11, rowHeader, "Cheque#");
        this.writeString(12, rowHeader, "Routing code");
        this.writeString(13, rowHeader, "Receipt#");
        this.writeString(14, rowHeader, "Bank#");
        this.writeString(15, rowHeader, "Comments");
    }

    private void setRules(Sheet worksheet) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList currencyCodeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList paymenttypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList glaccountCreditRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 5, 5);
        CellRangeAddressList glaccountDebitRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        this.setNames(worksheet);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint currencyCodeConstraint = validationHelper.createFormulaListConstraint("Currency");
        DataValidationConstraint paymentTypeConstraint = validationHelper.createFormulaListConstraint("PaymentType");
        DataValidationConstraint glaccountConstraint = validationHelper.createFormulaListConstraint("GlAccounts");
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation currencyCodeValidation = validationHelper.createValidation(currencyCodeConstraint, currencyCodeRange);
        DataValidation paymentTypeValidation = validationHelper.createValidation(paymentTypeConstraint, paymenttypeRange);
        DataValidation glaccountCreditValidation = validationHelper.createValidation(glaccountConstraint, glaccountCreditRange);
        DataValidation glaccountDebitValidation = validationHelper.createValidation(glaccountConstraint, glaccountDebitRange);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(currencyCodeValidation);
        worksheet.addValidationData(paymentTypeValidation);
        worksheet.addValidationData(glaccountCreditValidation);
        worksheet.addValidationData(glaccountDebitValidation);
    }

    private void setNames(Sheet worksheet) {
        Workbook addJournalEntriesWorkbook = worksheet.getWorkbook();
        ArrayList officeNames = new ArrayList(this.officeSheetPopulator.getOfficeNames());
        Name officeGroup = addJournalEntriesWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (officeNames.size() + 1));
        Name paymentTypeGroup = addJournalEntriesWorkbook.createName();
        paymentTypeGroup.setNameName("PaymentType");
        paymentTypeGroup.setRefersToFormula("Extras!$D$2:$D$" + (this.extrasSheetPopulator.getPaymentTypesSize() + 1));
        Name currencyGroup = addJournalEntriesWorkbook.createName();
        currencyGroup.setNameName("Currency");
        currencyGroup.setRefersToFormula("Extras!$F$2:$F$" + (this.extrasSheetPopulator.getCurrenciesSize() + 1));
        Name glaccountGroup = addJournalEntriesWorkbook.createName();
        glaccountGroup.setNameName("GlAccounts");
        glaccountGroup.setRefersToFormula("GlAccounts!$B$2:$B$" + (this.glAccountSheetPopulator.getGlAccountNamesSize() + 1));
    }

    private void setDefaults(Sheet worksheet) {
        Integer rowNo = 1;
        while (rowNo < 1000) {
            worksheet.createRow(rowNo.intValue());
            Integer n = rowNo;
            rowNo = rowNo + 1;
        }
    }
}

