/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.google.inject.Inject;
import com.navercorp.pinpoint.bootstrap.plugin.RequestRecorderFactory;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.DisableRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.profiler.context.config.ContextConfig;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.DefaultProxyRequestRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.ProxyRequestParser;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.ProxyRequestParserLoaderService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultRequestRecorderFactory<T>
implements RequestRecorderFactory<T> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProxyRequestParserLoaderService proxyRequestParserLoaderService;
    private final boolean enable;

    @Inject
    public DefaultRequestRecorderFactory(ProxyRequestParserLoaderService proxyRequestParserLoaderService, ContextConfig contextConfig) {
        this.proxyRequestParserLoaderService = proxyRequestParserLoaderService;
        this.enable = contextConfig.isProxyHttpHeaderEnable();
    }

    public ProxyRequestRecorder<T> getProxyRequestRecorder(RequestAdaptor<T> requestAdaptor) {
        if (!this.enable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Disable record proxy http header.");
            }
            return new DisableRequestRecorder();
        }
        List<ProxyRequestParser> proxyRequestParserList = this.proxyRequestParserLoaderService.getProxyRequestParserList();
        return new DefaultProxyRequestRecorder<T>(proxyRequestParserList, requestAdaptor);
    }
}

