/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.storage.DisabledUriStatStorage;
import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import java.util.Objects;

@InterfaceAudience.LimitedPrivate(value={"vert.x"})
public class ListenableAsyncState
implements AsyncState {
    private final LocalTraceRoot traceRoot;
    private final AsyncStateListener asyncStateListener;
    private final ActiveTraceHandle activeTraceHandle;
    private final UriStatStorage uriStatStorage;
    private boolean setup = false;
    private boolean await = false;
    private boolean finish = false;

    public ListenableAsyncState(LocalTraceRoot traceRoot, AsyncStateListener asyncStateListener, ActiveTraceHandle activeTraceHandle, UriStatStorage uriStatStorage) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.asyncStateListener = Objects.requireNonNull(asyncStateListener, "asyncStateListener");
        this.activeTraceHandle = Objects.requireNonNull(activeTraceHandle, "activeTraceHandle");
        this.uriStatStorage = Objects.requireNonNull(uriStatStorage, "uriStatStorage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        boolean finished = false;
        ListenableAsyncState listenableAsyncState = this;
        synchronized (listenableAsyncState) {
            if (this.await && !this.finish) {
                finished = true;
            }
            this.finish = true;
        }
        if (finished) {
            this.asyncStateListener.finish();
            long purgeTime = System.currentTimeMillis();
            this.activeTraceHandle.purge(purgeTime);
            this.storeUriTemplate(purgeTime);
        }
    }

    private void storeUriTemplate(long purgeTime) {
        if (this.uriStatStorage == DisabledUriStatStorage.INSTANCE) {
            return;
        }
        Shared shared = this.traceRoot.getShared();
        long traceStartTime = this.traceRoot.getTraceStartTime();
        boolean status = this.getStatus(shared.getErrorCode());
        this.uriStatStorage.store(shared.getUriTemplate(), shared.getHttpMethod(), status, traceStartTime, purgeTime);
    }

    private boolean getStatus(int errorCode) {
        return errorCode == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        ListenableAsyncState listenableAsyncState = this;
        synchronized (listenableAsyncState) {
            this.setup = true;
        }
    }

    public boolean await() {
        boolean await = this.await0();
        if (!await) {
            long purgeTime = System.currentTimeMillis();
            this.activeTraceHandle.purge(purgeTime);
            this.storeUriTemplate(purgeTime);
        }
        return await;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0() {
        ListenableAsyncState listenableAsyncState = this;
        synchronized (listenableAsyncState) {
            if (!this.setup || this.finish) {
                return false;
            }
            this.await = true;
            return true;
        }
    }

    public String toString() {
        return "ListenableAsyncState{asyncStateListener=" + this.asyncStateListener + ", setup=" + this.setup + ", await=" + this.await + ", finish=" + this.finish + '}';
    }

    static class DisableAsyncStateListener
    implements AsyncStateListener {
        DisableAsyncStateListener() {
        }

        @Override
        public void finish() {
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"LocalTraceContext"})
    public static interface AsyncStateListener {
        public static final AsyncStateListener EMPTY = new DisableAsyncStateListener();

        public void finish();
    }
}

